/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.xmlsocket;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import netjfwatcher.engine.server.xmlsocket.XMLSocketInfo;
import netjfwatcher.engine.socket.info.XMLSocketConnectState;

public final class XMLSocketConnectPushQueue {
    private static final int MS_COUNT = 1000;
    private static final int LISTSIZE = 50;
    private static Map<String, XMLSocketInfo> clientEventQueue = Collections.synchronizedMap(new HashMap());
    private static Logger logger = null;
    private final DateFormat simpleDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private XMLSocketConnectPushQueue() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static XMLSocketConnectPushQueue getInstance() {
        return SingletonXMLSocketConnectInstance.INSTANCE;
    }

    public synchronized boolean createXMLSocketObject(String threadName, String remoteIP, String targetIPAddress) {
        if (clientEventQueue.size() <= 50 && !clientEventQueue.containsKey(threadName)) {
            XMLSocketInfo xmlSocketinfo = new XMLSocketInfo(remoteIP);
            xmlSocketinfo.setTargetIpAddress(targetIPAddress);
            clientEventQueue.put(threadName, xmlSocketinfo);
            return true;
        }
        return false;
    }

    public synchronized void dellThreadKeyInXMLSocketInfoMap(String threadName) {
        clientEventQueue.remove(threadName);
    }

    public synchronized void addEventToXMLSocketInfoList(Object eventObj) {
        Set<String> set = clientEventQueue.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String threadNameKey = iterator.next().toString();
            XMLSocketInfo xmlSocketInfo = clientEventQueue.get(threadNameKey);
            xmlSocketInfo.getEventList().add(eventObj);
            clientEventQueue.put(threadNameKey, xmlSocketInfo);
        }
    }

    public synchronized XMLSocketInfo popXMLSocketInfo(String threadName) {
        XMLSocketInfo xmlSocketInfo = null;
        if (clientEventQueue.containsKey(threadName)) {
            xmlSocketInfo = clientEventQueue.get(threadName);
        }
        return xmlSocketInfo;
    }

    public synchronized Object popXMLSocketConnectEvent(String threadName) throws IndexOutOfBoundsException {
        XMLSocketInfo socketinfo;
        Object eventObj = null;
        if (clientEventQueue.containsKey(threadName) && (socketinfo = clientEventQueue.get(threadName)).getEventList().size() > 0) {
            eventObj = socketinfo.getEventList().get(0);
            socketinfo.getEventList().remove(0);
            clientEventQueue.put(threadName, socketinfo);
        }
        return eventObj;
    }

    public synchronized ArrayList getConnectInfo() {
        ArrayList<XMLSocketConnectState> connectList = new ArrayList<XMLSocketConnectState>();
        Set<String> set = clientEventQueue.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String threadKey = iterator.next().toString();
            XMLSocketInfo socketinfo = clientEventQueue.get(threadKey);
            String remoteIP = socketinfo.getRemoteIP();
            Date startTime = socketinfo.getStartTime();
            XMLSocketConnectState connectstate = new XMLSocketConnectState(remoteIP, startTime);
            String hostName = "UnknownHost";
            try {
                InetAddress host = InetAddress.getByName(remoteIP);
                hostName = host.getHostName();
            }
            catch (UnknownHostException e) {
                logger.warning("UnknownHostException Remote IP = " + remoteIP + "  " + e.getMessage());
            }
            connectstate.setHostName(hostName);
            connectstate.setStartDate(this.simpleDateformat.format(startTime));
            connectstate.setDurationDate(this.convDurationDate(startTime));
            connectList.add(connectstate);
        }
        return connectList;
    }

    private String convDurationDate(Date startDate) {
        Date date = Calendar.getInstance().getTime();
        long opTime = date.getTime() - startDate.getTime();
        String optimeString = "";
        if (opTime != 0L) {
            int day = (int)opTime / 86400000;
            int hour = (int)(opTime - (long)(day * 1000 * 60 * 60 * 24)) / 3600000;
            int min = (int)(opTime - (long)(day * 1000 * 60 * 60 * 24) - (long)(hour * 1000 * 60 * 60)) / 60000;
            int sec = (int)(opTime - (long)(day * 1000 * 60 * 60 * 24) - (long)(hour * 1000 * 60 * 60) - (long)(min * 1000 * 60)) / 1000;
            String dayString = day == 0 ? "" : String.valueOf(day) + "day ";
            String hourString = hour == 0 ? "" : String.valueOf(hour) + "hour";
            String minString = min == 0 ? "" : String.valueOf(min) + "min";
            optimeString = " (" + dayString + hourString + minString + sec + "sec)";
        }
        return optimeString;
    }

    /* synthetic */ XMLSocketConnectPushQueue(XMLSocketConnectPushQueue xMLSocketConnectPushQueue) {
        this();
    }

    private static class SingletonXMLSocketConnectInstance {
        static final XMLSocketConnectPushQueue INSTANCE = new XMLSocketConnectPushQueue(null);

        private SingletonXMLSocketConnectInstance() {
        }
    }
}

