/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.xmlsocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.engine.command.control.AbstractConnectClientCheck;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.server.xmlsocket.XMLSocketThread;

public final class XMLSocketServer
extends AbstractConnectClientCheck
implements Runnable {
    private static Logger logger = null;
    private ServerSocket server;
    private List<Socket> socketList = Collections.synchronizedList(new LinkedList());
    private Thread xmlSocketServerThread;
    private SystemResourceFileParse resourceInfo;
    private int port;
    private String allowHost;

    private XMLSocketServer() {
        logger = Logger.getLogger(this.getClass().getName());
        this.resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse();
        this.port = Integer.parseInt(this.resourceInfo.getResourceInfo().getXmlSocketPort());
        this.allowHost = this.resourceInfo.getResourceInfo().getXmlsocketAllowHost();
    }

    public static XMLSocketServer getInstance() {
        return SingletonResource.RESOURCE;
    }

    public void startXMLSocketServerThread() throws IOException {
        this.server = new ServerSocket(this.port);
        logger.info("Create server socket : " + this.server.getLocalPort());
        this.xmlSocketServerThread = new Thread(SingletonResource.RESOURCE);
        this.xmlSocketServerThread.setDaemon(true);
        this.xmlSocketServerThread.start();
    }

    public void stopXMLSocketServerReceiving() {
        if (this.xmlSocketServerThread == null) {
            return;
        }
        this.xmlSocketServerThread.interrupt();
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
            while (this.xmlSocketServerThread != null && this.xmlSocketServerThread.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
            this.server = null;
        }
        logger.info("XML Socket receive thread stop");
        this.xmlSocketServerThread = null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                while (true) {
                    socket = this.server.accept();
                    XMLSocketServer.logger.info("Accept Address : " + socket.getInetAddress().getHostAddress() + " : port :" + socket.getLocalPort());
                    XMLSocketServer.logger.info("allowHost : " + this.allowHost);
                    socket.setKeepAlive(true);
                    remoteIPAddress = socket.getInetAddress().getHostAddress();
                    XMLSocketServer.logger.info("Connect remote IP Address : " + remoteIPAddress);
                    isAllowClient = this.checkHost(this.allowHost, remoteIPAddress);
                    if (!isAllowClient) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            XMLSocketServer.logger.warning("Reject socket close error" + e.getMessage());
                            e.printStackTrace();
                        }
                        continue;
                    }
                    this.socketList.add(socket);
                    XMLSocketServer.logger.info("Client address = " + socket.getLocalSocketAddress());
                    XMLSocketServer.logger.info("Client port = " + socket.getLocalPort());
                    xmlthread = new XMLSocketThread(socket);
                    xmlthread.startXMLSocketThread(remoteIPAddress);
                }
            }
            catch (IOException ex) {
                if (this.server.isClosed()) {
                    XMLSocketServer.logger.info("Server socket closed " + ex.getMessage());
                }
                XMLSocketServer.logger.warning(ex.getMessage());
            }
        }
        finally {
            i = 0;
            ** while (i < this.socketList.size())
        }
lbl-1000:
        // 1 sources

        {
            var7_13 = this.socketList.get(i);
            try {
                XMLSocketServer.logger.info("Closed socket = " + i);
                var7_13.close();
            }
            catch (IOException e) {
                XMLSocketServer.logger.warning(e.getMessage());
                e.printStackTrace();
            }
            ++i;
            continue;
        }
lbl45:
        // 1 sources

        this.socketList.clear();
        if (this.server == null) return;
        try {
            this.server.close();
            return;
        }
        catch (IOException e) {
            XMLSocketServer.logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    public Thread getXmlSocketServerThread() {
        return this.xmlSocketServerThread;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.server != null) {
            this.server.close();
        }
    }

    /* synthetic */ XMLSocketServer(XMLSocketServer xMLSocketServer) {
        this();
    }

    private static class SingletonResource {
        static final XMLSocketServer RESOURCE = new XMLSocketServer(null);

        private SingletonResource() {
        }
    }
}

