/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.xmlsocket;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.server.xmlsocket.FlashPolicyException;
import netjfwatcher.engine.server.xmlsocket.XMLSocketConnectPushQueue;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLSocketThread
extends DataStringDisplay
implements Runnable {
    private static final int SLEEP_TIME = 3000;
    private boolean isSocketClient = true;
    public static final String CONNECT_CHECK = "Connection_Check";
    public static final String ENCODING = "Shift_JIS";
    public static final String POLICY = "policy-file-request";
    public static final String NULL_CODE = "\u0000";
    public static final String TERMINAL_CODE = "\u0000";
    public static final String RESP_INFO = "resp_info";
    public static final String RESP_STR = "resp_str";
    public static final String ECLIPSE_RCP = "Eclipse RCP";
    public static final String SEND_TEXT = "send_text";
    public static final String XML_SOCKET_RESPONSE_TAG = "<resp_info resp_str=";
    public static final String ALL_TARGET = "all";
    private static final int BUFF_LEN = 200;
    private XMLOutputter outputter = new XMLOutputter();
    private static Logger logger = null;
    private static final int POSITION_TARGET_ADDRESS_OR_CONNECT_STATUS = 0;
    private static final int POSITION_TO_ADDRESS = 1;
    private static final int POSITION_FROM_ADDRESS = 2;
    private static final int POSITION_MESSAGE = 3;
    private static final boolean IS_ECHO_RESPONSE = false;
    private Thread thisThread;
    private Socket xmlSocket;
    private OutputStreamWriter osw;
    private String remoteip;
    private InputStream xmlSocketInStream;

    protected XMLSocketThread(Socket socket) throws IOException {
        logger = Logger.getLogger(this.getClass().getName());
        this.xmlSocket = socket;
        this.xmlSocketInStream = this.xmlSocket.getInputStream();
        this.setXMLOutputterFormat();
    }

    public void startXMLSocketThread(String remoteIP) {
        this.remoteip = remoteIP;
        this.thisThread = Thread.currentThread();
        this.thisThread.setName(this.thisThread + " : " + remoteIP);
        this.thisThread = new Thread(this);
        this.thisThread.setName(this.thisThread + " : " + remoteIP);
        logger.info("XML Socket thread start : " + this.thisThread + " Remote IP=" + remoteIP + " Port=" + this.xmlSocket.getPort());
        this.thisThread.start();
    }

    public void run() {
        Thread curThread = Thread.currentThread();
        curThread.setName(curThread + " : " + this.remoteip);
        try {
            try {
                this.pushEventtoClient();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        finally {
            if (this.osw != null) {
                try {
                    this.osw.close();
                    this.osw = null;
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (this.xmlSocketInStream != null) {
                try {
                    this.xmlSocketInStream.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                this.xmlSocketInStream = null;
            }
            if (this.xmlSocket != null) {
                try {
                    this.xmlSocket.close();
                    this.xmlSocket = null;
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    private void pushEventtoClient() throws FlashPolicyException, UnsupportedEncodingException, IOException {
        XMLSocketConnectPushQueue pushQueue = XMLSocketConnectPushQueue.getInstance();
        String targetIPAddress = null;
        try {
            this.osw = new OutputStreamWriter(this.xmlSocket.getOutputStream(), ENCODING);
            targetIPAddress = this.getReceiveTargetIpAddress();
        }
        catch (FlashPolicyException e) {
            logger.warning("Abort parse receive data at client IP = " + this.remoteip + " by FlashPolicyException (" + e.getMessage() + ")");
            e.printStackTrace();
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            logger.warning("Abort parse receive data at client IP = " + this.remoteip + " by IOException (" + e.getMessage() + ")");
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            logger.warning("Abort parse receive data at client IP = " + this.remoteip + " by IOException (" + e.getMessage() + ")");
            e.printStackTrace();
            throw e;
        }
        if (targetIPAddress.equals(POLICY)) {
            logger.info("Policy Request : " + targetIPAddress);
            return;
        }
        String threadName = Thread.currentThread().getName();
        pushQueue.createXMLSocketObject(threadName, this.remoteip, targetIPAddress);
        Date date = Calendar.getInstance().getTime();
        DateFormat dateformat = DateFormat.getDateTimeInstance();
        pushQueue.addEventToXMLSocketInfoList("CONNECT:" + this.remoteip + ":    " + dateformat.format(date));
        String targetMode = pushQueue.popXMLSocketInfo(threadName).getTargetIpAddress();
        try {
            try {
                String popEventData = (String)pushQueue.popXMLSocketConnectEvent(threadName);
                while (true) {
                    if (popEventData != null) {
                        this.parseEvent(popEventData, targetMode);
                    }
                    popEventData = (String)pushQueue.popXMLSocketConnectEvent(threadName);
                    Thread.sleep(3000L);
                    this.checkReceiveData();
                    String str = "<resp_info resp_str='Connection_Check'/>\u0000";
                    if (this.isSocketClient) {
                        this.sendTextResponseFlash(str, this.osw);
                        continue;
                    }
                    this.sendResponseSocketRCP(this.createDocument(CONNECT_CHECK), this.osw);
                }
            }
            catch (InterruptedException e) {
                logger.warning("Disconnect client IP = " + this.remoteip + " by InterruptedException (" + e.getMessage() + ")");
            }
            catch (UnsupportedEncodingException e) {
                logger.warning("Disconnect client IP = " + this.remoteip + " by UnsupportedEncodingException (" + e.getMessage() + ")");
            }
            catch (SocketException e) {
                logger.info("Disconnect client IP = " + this.remoteip + " by SocketException (" + e.getMessage() + ")");
            }
            catch (IOException e) {
                logger.info("Disconnect client IP = " + this.remoteip + " by IOException (" + e.getMessage() + ")");
            }
            catch (Exception e) {
                logger.warning("Disconnect client IP = " + this.remoteip + " by  Exception (" + e.getMessage() + ")");
            }
        }
        finally {
            date = Calendar.getInstance().getTime();
            dateformat = DateFormat.getDateTimeInstance();
            pushQueue.addEventToXMLSocketInfoList("DISCONNECT:" + this.remoteip + ":    " + dateformat.format(date));
            pushQueue.dellThreadKeyInXMLSocketInfoMap(threadName);
        }
    }

    private void parseEvent(String popEventData, String mode) throws IOException {
        XMLSocketConnectPushQueue pushQueue = XMLSocketConnectPushQueue.getInstance();
        String threadName = Thread.currentThread().getName();
        String[] clientInfo = popEventData.split(":", 4);
        if (!clientInfo[0].equals("MAINTENANCE")) {
            if (mode.equals(ALL_TARGET) || mode.equals(clientInfo[0]) || clientInfo[0].equals("CONNECT") || clientInfo[0].equals("DISCONNECT")) {
                String str = "<resp_info resp_str='" + popEventData + "'" + "/>" + "\u0000";
                if (this.isSocketClient) {
                    this.sendTextResponseFlash(str, this.osw);
                } else {
                    this.sendResponseSocketRCP(this.createDocument(popEventData), this.osw);
                }
            }
        } else {
            String remoteIp = pushQueue.popXMLSocketInfo(threadName).getRemoteIP();
            if (mode.equals("MAINTENANCE") && (clientInfo[1].equals(ALL_TARGET) || remoteIp.equals(clientInfo[1]))) {
                String str = "<resp_info resp_str='To " + clientInfo[1] + "  From " + clientInfo[2] + " : " + clientInfo[3] + "'" + "/>" + "\u0000";
                if (this.isSocketClient) {
                    this.sendTextResponseFlash(str, this.osw);
                }
                logger.info("Message Send : " + clientInfo[1]);
            } else {
                logger.info("Not Found Address : " + clientInfo[1]);
            }
        }
    }

    private String getReceiveTargetIpAddress() throws FlashPolicyException, UnsupportedEncodingException, IOException {
        byte[] buf = new byte[200];
        String targetIpAddress = ALL_TARGET;
        int len = this.xmlSocketInStream.read(buf);
        ByteArrayInputStream inbuff = new ByteArrayInputStream(buf, 0, len - 1);
        targetIpAddress = this.parseReceiveXMLData(inbuff, false);
        return targetIpAddress;
    }

    protected void checkReceiveData() throws FlashPolicyException, UnsupportedEncodingException, IOException {
        try {
            byte[] buf = new byte[200];
            if (this.xmlSocketInStream.available() < 1) {
                return;
            }
            int len = this.xmlSocketInStream.read(buf);
            ByteArrayInputStream inbuff = new ByteArrayInputStream(buf, 0, len - 1);
            String recData = this.parseReceiveXMLData(inbuff, true);
            if (recData.equals(POLICY)) {
                logger.warning("Illegal request client Flash Policy");
                return;
            }
        }
        catch (UnsupportedEncodingException ex) {
            logger.warning("UnsupportedEncodingException : " + ex.getMessage());
            throw ex;
        }
        catch (IOException ex) {
            logger.warning("Error client message : " + ex.getMessage());
            throw ex;
        }
    }

    private String parseReceiveXMLData(InputStream inbuff, boolean isResponse) throws FlashPolicyException, UnsupportedEncodingException, IOException {
        Document doc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(inbuff);
        }
        catch (UTFDataFormatException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (JDOMException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        Element root = doc.getRootElement();
        if (root.getName().equals(POLICY)) {
            this.sendFlashXMLSocketPolicy();
            return POLICY;
        }
        String filterDate = root.getAttributeValue(SEND_TEXT);
        if (isResponse) {
            this.sendResponse(filterDate);
        }
        Date date = Calendar.getInstance().getTime();
        DateFormat dateformat = DateFormat.getDateTimeInstance();
        String[] receiveItem = filterDate.split(":", 3);
        if (receiveItem.length > 1) {
            if (!receiveItem[0].equals("MAINTENANCE")) {
                XMLSocketConnectPushQueue pushqueue = XMLSocketConnectPushQueue.getInstance();
                pushqueue.addEventToXMLSocketInfoList(String.valueOf(receiveItem[0]) + ": " + dateformat.format(date) + ": " + receiveItem[1]);
            } else {
                XMLSocketConnectPushQueue pushqueue = XMLSocketConnectPushQueue.getInstance();
                pushqueue.addEventToXMLSocketInfoList(String.valueOf(receiveItem[0]) + ":" + receiveItem[1] + ":" + this.remoteip + ": " + dateformat.format(date) + ": " + receiveItem[2]);
            }
        }
        if (filterDate.equals(ECLIPSE_RCP)) {
            filterDate = ALL_TARGET;
            this.isSocketClient = false;
        }
        return filterDate;
    }

    private void sendResponse(String str) throws UnsupportedEncodingException, IOException {
        String resData = "";
        String responseData = "<resp_info resp_str=\"" + resData.replace('\"', '\'') + "\" />" + "\u0000";
        String resDataConvert = resData.replace('\"', '\'');
        try {
            if (this.isSocketClient) {
                this.sendTextResponseFlash(responseData, this.osw);
            } else {
                this.sendResponseSocketRCP(this.createDocument(resDataConvert), this.osw);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    private void sendFlashXMLSocketPolicy() throws FlashPolicyException, UnsupportedEncodingException, IOException {
        File policyFlie = new File("resources/flash_policy.xml");
        BufferedReader buffReader = null;
        if (policyFlie == null) {
            throw new FlashPolicyException("Not found Flash Policy : resources/flash_policy.xml");
        }
        try {
            FileReader fileReader = new FileReader("resources/flash_policy.xml");
            buffReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException e1) {
            logger.warning(String.valueOf(e1.getMessage()) + "Path : " + policyFlie.getAbsolutePath());
            throw new FlashPolicyException("FileNotFoundException : resources/flash_policy.xml : " + e1.getMessage());
        }
        char[] charBuff = new char[200];
        try {
            try {
                buffReader.read(charBuff);
            }
            catch (IOException e1) {
                logger.warning(String.valueOf(e1.getMessage()) + " File path : " + policyFlie.getAbsolutePath());
                e1.printStackTrace();
                throw new FlashPolicyException("IOException : resources/flash_policy.xml : " + e1.getMessage());
            }
        }
        finally {
            if (buffReader != null) {
                try {
                    buffReader.close();
                }
                catch (IOException e3) {
                    logger.warning(e3.getMessage());
                    e3.printStackTrace();
                }
            }
        }
        try {
            if (this.isSocketClient) {
                this.sendCharResponseFlash(charBuff, this.osw);
            }
            logger.info("Response Flash XMLSocket Policy");
        }
        catch (UnsupportedEncodingException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public Document createDocument(String value) {
        Element confElement = new Element(RESP_INFO);
        Document doc = new Document(confElement);
        confElement.setAttribute(RESP_STR, value);
        return doc;
    }

    private void sendResponseSocketRCP(Document doc, OutputStreamWriter osw) throws IOException {
        String sendText = String.valueOf(this.outputter.outputString(doc)) + "\u0000";
        osw.write(sendText);
        osw.flush();
    }

    private void sendTextResponseFlash(String sendText, OutputStreamWriter osw) throws IOException {
        osw.write(sendText);
        osw.flush();
    }

    private void sendCharResponseFlash(char[] charBuff, OutputStreamWriter osw) throws IOException {
        osw.write(charBuff);
        osw.flush();
    }

    private void setXMLOutputterFormat() {
        Format format = this.outputter.getFormat();
        format.setEncoding("UTF-8");
        format.setLineSeparator(System.getProperty("line.separator"));
        format.setIndent("  ");
        this.outputter.setFormat(format);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.xmlSocket != null) {
            try {
                this.xmlSocket.close();
                this.xmlSocket = null;
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
    }
}

