/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.engine.snmpmanager.process.ManagerV3MP;
import netjfwatcher.engine.snmpmanager.process.ManagerV3MessageInfo;
import netjfwatcher.engine.snmpmanager.process.SnmpRequestIDManager;
import netjfwatcher.engine.snmpmanager.process.SnmpV3MsgIDManager;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmp.snmpv3.UsmSecuritySubsystem;
import netjfwatcher.snmp.snmpv3.UsmUserEntry;
import netjfwatcher.snmp.snmpv3.UsmUserManager;
import netjfwatcher.snmpmanager.SnmpManagerQueue;

public class ManagerV3MPDiscoveryAgent
extends ManagerV3MP {
    private static Logger logger;
    private SnmpV3ManagerConfigInfo snmpConfigInformation;
    private SnmpV3ManagerUserConfigInfo userConfigInfo;
    private DateFormat dateformat = new SimpleDateFormat("HH:mm:ss");

    public ManagerV3MPDiscoveryAgent(DatagramSocket dSocket, InetAddress hostAddress, String community) {
        logger = Logger.getLogger(this.getClass().getName());
        this.version = 3;
        this.dSocket = dSocket;
        this.targetAddress = hostAddress;
        this.community = community;
    }

    public ManagerV3MessageInfo discoveryAgent() throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpErrorStatusException, SnmpBadValueException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpV3ConfigurationException, IOException {
        this.snmpConfigInformation = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(this.targetAddress.getHostAddress());
        this.userConfigInfo = (SnmpV3ManagerUserConfigInfo)this.snmpConfigInformation.getUserList().get(0);
        int requestID = SnmpRequestIDManager.getInstance().getRequestID(Thread.currentThread().getName(), "discoveryAgent");
        int msgID = SnmpV3MsgIDManager.getInstance().getMsgID(Thread.currentThread().getName(), "discoveryAgent");
        SnmpSequence sequenceData = null;
        try {
            sequenceData = this.createDiscoverySnmpEngineIDMessage(requestID, msgID);
        }
        catch (SnmpBadValueException e) {
            logger.warning("create message for engineID discovery : " + e.getMessage());
            throw e;
        }
        DatagramPacket inPacket = null;
        ManagerV3MessageInfo receiveMessageInfo = null;
        try {
            byte[] sendData = sequenceData.getBEREncoding();
            this.dSocket.connect(this.targetAddress, this.snmpPort);
            try {
                this.sendByteDataToAgent(sendData, "discoveryAgent", this.dSocket);
            }
            catch (IOException e3) {
                logger.warning(e3.getMessage());
                e3.printStackTrace();
                throw e3;
            }
            inPacket = new DatagramPacket(new byte[8196], 8196);
            try {
                this.dSocket.receive(inPacket);
            }
            catch (SocketTimeoutException e) {
                try {
                    logger.warning("SnmpEngineID Discovery socket timeout : " + this.dSocket.getSoTimeout());
                }
                catch (SocketException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                    throw e1;
                }
                e.printStackTrace();
                throw e;
            }
            catch (IOException e) {
                logger.warning("SnmpEngineID Discovery : " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
            byte[] receiveDataByte = inPacket.getData();
            logger.fine("EngineID Discovery receive data : " + this.hexBytetoString(receiveDataByte, inPacket.getLength()));
            Date date = Calendar.getInstance().getTime();
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue("EngineID Discovery receive data : " + this.dateformat.format(date) + " : Data length : " + inPacket.getLength() + "Byte");
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(this.hexBytetoString(receiveDataByte, inPacket.getLength()));
            receiveMessageInfo = this.parseSnmpV3ReceiveData(receiveDataByte, requestID, msgID, "discoveryAgent");
            System.out.println("Discovery engineID : " + receiveMessageInfo.getMsgAuthoritativeEngineID());
            String msgAuthoritativeEngineID = receiveMessageInfo.getMsgAuthoritativeEngineID();
            String snmpEngineID = "";
            String msgAuthoritativeUserName = receiveMessageInfo.getMsgUserName();
            snmpEngineID = msgAuthoritativeEngineID.substring(2);
            this.snmpConfigInformation.setSnmpEngineID(snmpEngineID);
            logger.info("Discovery Agent : " + this.snmpConfigInformation.getIpAddress());
            logger.info("Discovery Agent AuthPassPhrase : " + ((SnmpV3ManagerUserConfigInfo)this.snmpConfigInformation.getUserList().get(0)).getAuthPassPhrase());
            SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(this.targetAddress.getHostAddress(), this.snmpConfigInformation);
            try {
                this.setSnmpV3USMUserManagerList(this.snmpConfigInformation);
            }
            catch (SnmpV3ConfigurationException e) {
                logger.warning("SnmpV3USMUserManagerList abort : " + e.getMessage());
                throw e;
            }
            if (this.snmpConfigInformation != null) {
                System.out.println("IP Address : " + this.snmpConfigInformation.getIpAddress());
                System.out.println("User Name : " + this.userConfigInfo.getUsername());
            } else {
                logger.warning("Not found Agent Address : " + this.targetAddress.toString());
            }
            String userName = this.userConfigInfo.getUsername();
            requestID = SnmpRequestIDManager.getInstance().getRequestID(Thread.currentThread().getName(), "DiscoverySnmpBootsAndTimeMessage");
            msgID = SnmpV3MsgIDManager.getInstance().getMsgID(Thread.currentThread().getName(), "DiscoverySnmpBootsAndTimeMessage");
            if (!userName.equals(msgAuthoritativeUserName)) {
                logger.warning("Not found UserName : " + msgAuthoritativeUserName);
            }
            try {
                sequenceData = this.createDiscoverySnmpBootsAndTimeMessage(requestID, msgID, snmpEngineID, userName);
            }
            catch (GeneralSecurityException e) {
                logger.warning(e.getMessage());
                throw e;
            }
            catch (SnmpV3ConfigurationException e) {
                logger.warning(e.getMessage());
                throw e;
            }
            catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
                throw new SnmpBadValueException(e.getMessage());
            }
            sendData = sequenceData.getBEREncoding();
            try {
                this.sendByteDataToAgent(sendData, "discoveryAgent", this.dSocket);
            }
            catch (IOException e1) {
                logger.warning("Send to discovery agent : " + e1.getMessage());
                e1.printStackTrace();
                throw e1;
            }
            inPacket = new DatagramPacket(new byte[8196], 8196);
            try {
                this.dSocket.receive(inPacket);
            }
            catch (SocketTimeoutException e) {
                logger.warning("Receive socket timeout from discovery Agent : " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
            catch (IOException e) {
                logger.warning("Receive from discovery Agent : " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
            receiveDataByte = inPacket.getData();
            logger.fine("EngineBoots/Time Discovery receive data : " + this.hexBytetoString(receiveDataByte, inPacket.getLength()));
            date = Calendar.getInstance().getTime();
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue("EngineBoots/Time Discovery receive data : " + this.dateformat.format(date) + " : Data length : " + inPacket.getLength() + "Byte");
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(this.hexBytetoString(receiveDataByte, inPacket.getLength()));
            receiveMessageInfo = this.parseSnmpV3ReceiveData(receiveDataByte, requestID, msgID, "discoveryAgent");
            System.out.println("Discovery engineBoots and time : " + receiveMessageInfo.getMsgAuthoritativeEngineID());
            System.out.println("Discovery engineBoots and time : " + receiveMessageInfo.getMsgAuthoritativeBoots());
            System.out.println("Discovery engineBoots and time : " + receiveMessageInfo.getMsgAuthoritativeBoots());
        }
        finally {
            this.dSocket.disconnect();
        }
        return receiveMessageInfo;
    }

    private void setSnmpV3USMUserManagerList(SnmpV3ManagerConfigInfo info) throws SnmpV3ConfigurationException {
        SnmpEngineID snmpEngineID = new SnmpEngineID(info.getSnmpEngineID());
        System.out.println("SnmpEngineID : " + snmpEngineID);
        UsmUserManager.getInstance().registList(snmpEngineID, info);
        try {
            MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning("MessageDigest MD5 : " + e.getMessage());
            throw new SnmpV3ConfigurationException("MessageDigest MD5 : " + e.getMessage());
        }
        try {
            MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning("MessageDigest SHA-1 : " + e.getMessage());
            throw new SnmpV3ConfigurationException("MessageDigest SHA-1 : " + e.getMessage());
        }
        try {
            Mac.getInstance("HmacMD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning("Mac HmacMD5 : " + e.getMessage());
            throw new SnmpV3ConfigurationException("Mac HmacMD5 : " + e.getMessage());
        }
        try {
            Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning("Mac HmacSHA1 : " + e.getMessage());
            throw new SnmpV3ConfigurationException("Mac HmacSHA1 : " + e.getMessage());
        }
        try {
            Cipher.getInstance("DES");
        }
        catch (NoSuchPaddingException e) {
            logger.warning("Cipher DES : " + e.getMessage());
            throw new SnmpV3ConfigurationException("Cipher DES : " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning("Cipher DES : " + e.getMessage());
            throw new SnmpV3ConfigurationException("Cipher DES : " + e.getMessage());
        }
        try {
            SecretKeyFactory.getInstance("DES");
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning("SecretKeyFactory DES : " + e.getMessage());
            throw new SnmpV3ConfigurationException("SecretKeyFactory DES : " + e.getMessage());
        }
        catch (Throwable e) {
            logger.warning("MessageDigest MD5 : " + e.getMessage());
            throw new SnmpV3ConfigurationException(e.toString());
        }
    }

    public SnmpSequence createDiscoverySnmpEngineIDMessage(int requestID, int requestMsgID) throws SnmpBadValueException {
        int snmpVersion = 3;
        int securityModel = 3;
        Object snmpEngineID = null;
        int snmpEngineBoots = 0;
        SnmpSequence sendSNMPSequence = new SnmpSequence();
        try {
            System.out.println("snmpEngineID : " + snmpEngineID);
            sendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));
            SnmpSequence msgGlobalData = new SnmpSequence();
            msgGlobalData.addSNMPObject(new SnmpInteger(requestMsgID));
            msgGlobalData.addSNMPObject(new SnmpInteger(512L));
            byte msgFlag = 4;
            msgGlobalData.addSNMPObject(new SnmpOctetString(new byte[]{msgFlag}));
            msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
            sendSNMPSequence.addSNMPObject(msgGlobalData);
            SnmpSequence msgSecurityParameters = new SnmpSequence();
            msgSecurityParameters.addSNMPObject(new SnmpOctetString());
            msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineBoots));
            int snmpEngineTime = 0;
            msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineTime));
            msgSecurityParameters.addSNMPObject(new SnmpOctetString());
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
            sendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()));
            SnmpSequence msgData = new SnmpSequence();
            msgData.addSNMPObject(new SnmpOctetString());
            msgData.addSNMPObject(new SnmpOctetString());
            SnmpPDU sendPDU = null;
            int errorStatus = 0;
            int errorIndex = 0;
            try {
                SnmpSequence varList = new SnmpSequence();
                sendPDU = new SnmpPDU(-96, requestID, errorStatus, errorIndex, varList);
            }
            catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                throw e;
            }
            msgData.addSNMPObject(sendPDU);
            sendSNMPSequence.addSNMPObject(msgData);
        }
        catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }
        return sendSNMPSequence;
    }

    public SnmpSequence createDiscoverySnmpBootsAndTimeMessage(int requestID, int requestMsgID, String snmpEngineIDString, String userNameString) throws GeneralSecurityException, SnmpBadValueException, SnmpV3ConfigurationException {
        SnmpSequence sendSNMPSequence;
        block13: {
            int snmpVersion = 3;
            int securityModel = 3;
            String userName = userNameString;
            SnmpEngineID snmpEngineID = new SnmpEngineID(snmpEngineIDString);
            int snmpEngineBoots = 0;
            String contextName = this.snmpConfigInformation.getContextName();
            sendSNMPSequence = new SnmpSequence();
            UsmUserEntry usmUserEntry = UsmUserManager.getInstance().getUsmUserEntry(snmpEngineID, userName);
            if (usmUserEntry == null) {
                System.out.println("Not user entry");
                System.out.println("snmpEngineID : " + snmpEngineID);
                System.out.println("userName : " + userName);
                throw new SnmpV3ConfigurationException("Agent discovery EngineBoots/Time : ");
            }
            try {
                System.out.println("SnmpEngineID : " + snmpEngineID);
                System.out.println("UserName : " + userName);
                sendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));
                SnmpSequence msgGlobalData = new SnmpSequence();
                msgGlobalData.addSNMPObject(new SnmpInteger(requestMsgID));
                msgGlobalData.addSNMPObject(new SnmpInteger(1472L));
                byte msgFlag = 4;
                String authPriv = this.userConfigInfo.getAuthPriv();
                if (authPriv.equals("AUTH") || authPriv.equals("PRIV")) {
                    msgFlag = (byte)(msgFlag | 1);
                }
                msgGlobalData.addSNMPObject(new SnmpOctetString(new byte[]{msgFlag}));
                msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
                sendSNMPSequence.addSNMPObject(msgGlobalData);
                SnmpSequence msgSecurityParameters = new SnmpSequence();
                msgSecurityParameters.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
                msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineBoots));
                int snmpEngineTime = 0;
                msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineTime));
                msgSecurityParameters.addSNMPObject(new SnmpOctetString(userName));
                if (authPriv.equals("AUTH") || authPriv.equals("PRIV")) {
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[12]));
                } else {
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
                }
                msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
                sendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()));
                SnmpSequence msgData = new SnmpSequence();
                msgData.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
                msgData.addSNMPObject(new SnmpOctetString(contextName));
                SnmpPDU sendPDU = null;
                int errorStatus = 0;
                int errorIndex = 0;
                try {
                    SnmpSequence varList = new SnmpSequence();
                    sendPDU = new SnmpPDU(-96, requestID, errorStatus, errorIndex, varList);
                }
                catch (SnmpBadValueException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                    throw new SnmpBadValueException(e.getMessage());
                }
                msgData.addSNMPObject(sendPDU);
                sendSNMPSequence.addSNMPObject(msgData);
                if (!authPriv.equals("AUTH") && !authPriv.equals("PRIV")) break block13;
                try {
                    SnmpOctetString msgAuthenticationParametersOctet = null;
                    msgAuthenticationParametersOctet = UsmSecuritySubsystem.getInstance().setAuth(sendSNMPSequence, msgSecurityParameters, usmUserEntry.getUsmUserAuthKey());
                    msgSecurityParameters.addSNMPObject(msgAuthenticationParametersOctet, 4);
                }
                catch (GeneralSecurityException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                    throw e2;
                }
                sendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()), 2);
            }
            catch (SnmpBadValueException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
                throw e1;
            }
        }
        return sendSNMPSequence;
    }
}

