/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.engine.snmpmanager.process.ManagerDispatcher;
import netjfwatcher.engine.snmpmanager.process.SnmpCommandErrorTestException;
import netjfwatcher.engine.snmpmanager.process.SnmpOperationDataHolder;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpMappingTableController;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmp.snmpv3.UsmUserManager;
import netjfwatcher.snmptest.SnmpErrorTest;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public final class SnmpCommandOperation {
    private static Logger logger;
    private SnmpV3ManagerConfigInfo info = null;
    private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String reportOidDescription = "";
    private String searchOidDescription = "";
    private String searchOidAccess = "";

    private SnmpCommandOperation() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void getRequest(SnmpOperationDataHolder dataHolder) {
        SnmpVarBindList newVars;
        String returnOid;
        ManagerDispatcher dispacher;
        String targetIPAddress;
        int version;
        block30: {
            version = dataHolder.getSnmpVersion();
            if (version == 3 && !SnmpErrorTest.getInstance().getManagerErrorControlCode().equals("Normal")) {
                logger.info("Error test : " + SnmpErrorTest.getInstance().getManagerErrorControlCode());
                try {
                    this.setTestError(dataHolder);
                }
                catch (SnmpCommandErrorTestException e) {
                    MessageBox alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                    alertMessageBox.setMessage(e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();
                    return;
                }
            }
            targetIPAddress = dataHolder.getTargetIP();
            String community = dataHolder.getRoCommunity();
            String oid = dataHolder.getTargetOid();
            dispacher = null;
            returnOid = oid;
            dispacher = new ManagerDispatcher();
            dispacher.setManagerDispatcher(targetIPAddress, community, version);
            newVars = dispacher.dispathGetMessage(version, (byte)-96, returnOid);
            if (newVars != null) break block30;
            MessageBox alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
            alertMessageBox.setMessage("Abort MIB Get");
            alertMessageBox.open();
            dispacher.closeConnection();
            return;
        }
        try {
            MessageBox alertMessageBox;
            try {
                TableItem item;
                Table oidTable;
                String[] mib;
                SnmpSequence responsePair = (SnmpSequence)newVars.getSNMPObjectAt(0);
                SnmpObjectIdentifier responseOID = (SnmpObjectIdentifier)responsePair.getSNMPObjectAt(0);
                AbstractSnmpObject responseValue = responsePair.getSNMPObjectAt(1);
                String responseTypeString = responseValue.getTagDescription();
                logger.info("Return OID :" + responseOID.toString());
                logger.info("Return responseValue :" + responseValue);
                logger.info("Return responseTypeString :" + responseTypeString);
                if (this.checkReportOID(responseOID.toString())) {
                    mib = new String[5];
                    mib[0] = this.reportOidDescription;
                    mib[1] = responseOID.toString();
                    mib[2] = responseValue.toString();
                    mib[3] = responseTypeString;
                    this.findOidDescription(mib[1]);
                    mib[4] = this.searchOidAccess;
                    oidTable = NetJFWatcherApplication.getOidTableView().getViewer().getTable();
                    item = new TableItem(oidTable, 0);
                    item.setText(mib);
                    item.setData((Object)mib);
                }
                mib = new String[5];
                mib[1] = responseOID.toString();
                mib[2] = responseValue.toString();
                mib[3] = responseTypeString;
                this.findOidDescription(mib[1]);
                mib[0] = this.searchOidDescription;
                mib[4] = this.searchOidAccess;
                oidTable = NetJFWatcherApplication.getOidTableView().getViewer().getTable();
                item = new TableItem(oidTable, 0);
                item.setText(mib);
                item.setData((Object)mib);
                returnOid = responseOID.toString();
                if (version == 3) {
                    this.info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(targetIPAddress);
                    if (this.info != null) {
                        if (this.info.isLearned()) {
                            dataHolder.getAgentLearnedText().setText("Dicovery");
                        } else {
                            dataHolder.getAgentLearnedText().setText("Undiscovery");
                        }
                        if (this.info.getSnmpEngineID() != null && !this.info.getSnmpEngineID().equals("")) {
                            dataHolder.getEngineIDText().setText("0x" + this.info.getSnmpEngineID());
                        } else {
                            dataHolder.getEngineIDText().setText("");
                        }
                        dataHolder.getEngineBootText().setText(this.info.getSnmpEngineBoots());
                        long agentSnmpEngineTime = 0L;
                        agentSnmpEngineTime = Long.parseLong(this.info.getSnmpEngineTime());
                        Date agentDate = Calendar.getInstance().getTime();
                        agentDate.setTime(agentSnmpEngineTime);
                        dataHolder.getEngineSysUpTimeText().setText(this.dateformat.format(agentDate));
                        if (!SnmpErrorTest.getInstance().getManagerErrorControlCode().equals("Normal")) {
                            this.info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(dataHolder.getTargetIP());
                            this.info.setLearned(false);
                            SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(dataHolder.getTargetIP(), this.info);
                            dataHolder.getAgentLearnedText().setText("Undiscovery");
                        }
                    }
                }
            }
            catch (SnmpErrorStatusException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
            }
            catch (SnmpUnmuchRequestIDException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpUnmuchRequestMsgIDException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (GeneralSecurityException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SocketException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpBadValueException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpConfigurationException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpV3ConfigurationException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpV3DecryptAbortException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpV3AuthAbortException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpMIBGetException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpSetException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (UnknownHostException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage("UnknownHostException : " + e1.getMessage());
                alertMessageBox.open();
            }
            catch (IOException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            dispacher.closeConnection();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getNextRequest(SnmpOperationDataHolder dataHolder) {
        block31: {
            version = dataHolder.getSnmpVersion();
            if (version == 3 && !SnmpErrorTest.getInstance().getManagerErrorControlCode().equals("Normal")) {
                SnmpCommandOperation.logger.info("Error test : " + SnmpErrorTest.getInstance().getManagerErrorControlCode());
                try {
                    this.setTestError(dataHolder);
                }
                catch (SnmpCommandErrorTestException e) {
                    alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                    alertMessageBox.setMessage(e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();
                    return;
                }
            }
            targetIPAddress = dataHolder.getTargetIP();
            community = dataHolder.getRoCommunity();
            oid = dataHolder.getTargetOid();
            dispacher = null;
            try {
                returnOid = oid;
                dispacher = new ManagerDispatcher();
                dispacher.setManagerDispatcher(targetIPAddress, community, version);
lbl22:
                // 2 sources

                while (true) {
                    newVars = dispacher.dispathGetMessage(version, (byte)-95, returnOid);
                    if (newVars == null) {
                        alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                        alertMessageBox.setMessage("Abort MIB Get");
                        alertMessageBox.open();
                        dispacher.closeConnection();
                        return;
                    }
                    break;
                }
            }
            catch (SnmpErrorStatusException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
            }
            catch (SnmpUnmuchRequestIDException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpUnmuchRequestMsgIDException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (GeneralSecurityException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SocketException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpBadValueException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpConfigurationException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpV3ConfigurationException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpV3DecryptAbortException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpV3AuthAbortException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpMIBGetException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (SnmpSetException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
                e1.printStackTrace();
            }
            catch (UnknownHostException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage("UnknownHostException : " + e1.getMessage());
                alertMessageBox.open();
            }
            catch (IOException e1) {
                alertMessageBox = new MessageBox(dataHolder.getViewSite().getShell(), 72);
                alertMessageBox.setMessage(e1.getMessage());
                alertMessageBox.open();
            }
            catch (Throwable var18_36) {
                dispacher.closeConnection();
                throw var18_36;
            }
            {
                responsePair = (SnmpSequence)newVars.getSNMPObjectAt(0);
                responseOID = (SnmpObjectIdentifier)responsePair.getSNMPObjectAt(0);
                SnmpCommandOperation.logger.info("Return OID :" + responseOID.toString());
                responseValue = responsePair.getSNMPObjectAt(1);
                responseTypeString = responseValue.getTagDescription();
                if (this.checkReportOID(responseOID.toString())) {
                    mib = new String[5];
                    mib[0] = this.reportOidDescription;
                    mib[1] = responseOID.toString();
                    mib[2] = responseValue.toString();
                    mib[3] = responseTypeString;
                    this.findOidDescription(mib[1]);
                    mib[4] = this.searchOidAccess;
                    oidTable = NetJFWatcherApplication.getOidTableView().getViewer().getTable();
                    item = new TableItem(oidTable, 0);
                    item.setText(mib);
                    item.setData((Object)mib);
                } else {
                    checkOidPos = responseOID.toString().lastIndexOf(".");
                    workSearchOid = "";
                    if (checkOidPos >= 0) {
                        workSearchOid = responseOID.toString().substring(0, checkOidPos);
                    }
                    if (workSearchOid.indexOf(oid) >= 0) {
                        mib = new String[5];
                        mib[1] = responseOID.toString();
                        mib[2] = responseValue.toString();
                        mib[3] = responseTypeString;
                        this.findOidDescription(mib[1]);
                        mib[0] = this.searchOidDescription;
                        mib[4] = this.searchOidAccess;
                        oidTable = NetJFWatcherApplication.getOidTableView().getViewer().getTable();
                        item = new TableItem(oidTable, 0);
                        item.setText(mib);
                        item.setData((Object)mib);
                        returnOid = responseOID.toString();
                        ** continue;
                    }
                }
                if (version != 3) break block31;
                this.info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(targetIPAddress);
                if (this.info == null) break block31;
                if (this.info.isLearned()) {
                    dataHolder.getAgentLearnedText().setText("Dicovery");
                } else {
                    dataHolder.getAgentLearnedText().setText("Undiscovery");
                }
                if (this.info.getSnmpEngineID() != null && !this.info.getSnmpEngineID().equals("")) {
                    dataHolder.getEngineIDText().setText("0x" + this.info.getSnmpEngineID());
                } else {
                    dataHolder.getEngineIDText().setText("");
                }
                dataHolder.getEngineBootText().setText(this.info.getSnmpEngineBoots());
                agentSnmpEngineTime = 0L;
                agentSnmpEngineTime = Long.parseLong(this.info.getSnmpEngineTime());
                agentDate = Calendar.getInstance().getTime();
                agentDate.setTime(agentSnmpEngineTime);
                dataHolder.getEngineSysUpTimeText().setText(this.dateformat.format(agentDate));
                if (SnmpErrorTest.getInstance().getManagerErrorControlCode().equals("Normal")) break block31;
                this.info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(dataHolder.getTargetIP());
                this.info.setLearned(false);
                SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(dataHolder.getTargetIP(), this.info);
                dataHolder.getAgentLearnedText().setText("Undiscovery");
            }
        }
        dispacher.closeConnection();
    }

    public void setRequest(SnmpOperationDataHolder dataholder) {
        block8: {
            ManagerDispatcher dispacher = null;
            try {
                try {
                    String rwCommunity = dataholder.getRwCommunity();
                    int version = dataholder.getSnmpVersion();
                    logger.info("IP=" + dataholder.getTargetIP() + " version=" + version + " Community=" + rwCommunity);
                    dispacher = new ManagerDispatcher();
                    dispacher.setManagerDispatcher(dataholder.getTargetIP(), rwCommunity, version);
                    String itemID = dataholder.getTargetOid();
                    String valueString = dataholder.getSetValue();
                    String valueTypeString = dataholder.getSetType();
                    logger.info("valueTypeString = " + valueTypeString);
                    AbstractSnmpObject itemValue = SnmpMappingTableController.getInstance().getSnmpObjectInstance(valueTypeString);
                    itemValue.setValue(valueString);
                    SnmpVarBindList newVars = dispacher.dispathSetMessage(version, (byte)-93, itemID, itemValue);
                    SnmpSequence responsePair = (SnmpSequence)newVars.getSNMPObjectAt(0);
                    SnmpObjectIdentifier responseOID = (SnmpObjectIdentifier)responsePair.getSNMPObjectAt(0);
                    logger.info("Response OID = " + responseOID.toString());
                    if (this.checkReportOID(responseOID.toString())) {
                        logger.info("Report ID = " + responseOID.toString() + " : " + this.reportOidDescription);
                        AbstractSnmpObject responseValue = responsePair.getSNMPObjectAt(1);
                        String responseTypeString = responseValue.getTagDescription();
                        String[] mib = new String[5];
                        mib[0] = this.reportOidDescription;
                        mib[1] = responseOID.toString();
                        mib[2] = responseValue.toString();
                        mib[3] = responseTypeString;
                        this.findOidDescription(mib[1]);
                        mib[4] = this.searchOidAccess;
                        Table oidTable = NetJFWatcherApplication.getOidTableView().getViewer().getTable();
                        TableItem item = new TableItem(oidTable, 0);
                        item.setText(mib);
                        item.setData((Object)mib);
                        break block8;
                    }
                    logger.info("Return OID = " + responseOID.toString());
                    AbstractSnmpObject responseValue = responsePair.getSNMPObjectAt(1);
                    String responseTypeString = responseValue.getTagDescription();
                    String[] mib = new String[5];
                    mib[1] = responseOID.toString();
                    mib[2] = responseValue.toString();
                    mib[3] = responseTypeString;
                    this.findOidDescription(mib[1]);
                    mib[0] = this.searchOidDescription;
                    mib[4] = this.searchOidAccess;
                    Table oidTable = NetJFWatcherApplication.getOidTableView().getViewer().getTable();
                    TableItem item = new TableItem(oidTable, 0);
                    item.setText(mib);
                    item.setData((Object)mib);
                }
                catch (SnmpSetException e) {
                    logger.warning(e.getMessage());
                    MessageBox alertMessageBox = new MessageBox(dataholder.getViewSite().getShell(), 72);
                    alertMessageBox.setMessage(e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();
                }
                catch (UnknownHostException e) {
                    logger.warning(e.getMessage());
                    MessageBox alertMessageBox = new MessageBox(dataholder.getViewSite().getShell(), 72);
                    alertMessageBox.setMessage("UnknownHostException : " + e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();
                }
                catch (Exception e) {
                    logger.warning(e.getMessage());
                    MessageBox alertMessageBox = new MessageBox(dataholder.getViewSite().getShell(), 72);
                    alertMessageBox.setMessage(e.getMessage());
                    alertMessageBox.open();
                    e.printStackTrace();
                }
            }
            finally {
                dispacher.closeConnection();
            }
        }
    }

    public boolean checkReportOID(String checkOID) {
        boolean isCheckReportOID = false;
        this.reportOidDescription = "";
        if (checkOID.equals("1.3.6.1.6.3.15.1.1.1.0")) {
            this.reportOidDescription = "Unsupported security level";
            isCheckReportOID = true;
        } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.2.0")) {
            this.reportOidDescription = "Not in time packet";
            isCheckReportOID = true;
        } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.3.0")) {
            this.reportOidDescription = "Unknown user name";
            isCheckReportOID = true;
        } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.4.0")) {
            this.reportOidDescription = "Unknown engine ID";
            isCheckReportOID = true;
        } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.5.0")) {
            this.reportOidDescription = "Wrong digest";
            isCheckReportOID = true;
        } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.6.0")) {
            this.reportOidDescription = "Descryption error";
            isCheckReportOID = true;
        }
        logger.info("isCheckReportOID = " + isCheckReportOID);
        logger.info("oidDescription = " + this.reportOidDescription);
        return isCheckReportOID;
    }

    public void findOidDescription(String oid) {
        this.searchOidDescription = "unknown";
        this.searchOidAccess = "unknown";
        int oidwork = oid.lastIndexOf(".");
        String searchOid = oid.substring(0, oidwork);
        System.out.println("oidNext : " + oid.substring(0, oidwork));
        int i = 0;
        while (i < oid.length()) {
            if (ManagerMibTree.getInstance().getOidHashMap().containsKey(searchOid)) {
                MibInfo miboid = (MibInfo)ManagerMibTree.getInstance().getOidHashMap().get(searchOid);
                this.searchOidDescription = String.valueOf(miboid.getDescrip()) + oid.substring(miboid.getOid().length(), oid.length());
                if (miboid.getAccess().equals("ro")) {
                    this.searchOidAccess = "read-only";
                    break;
                }
                if (miboid.getAccess().equals("rw")) {
                    this.searchOidAccess = "read-write";
                    break;
                }
                this.searchOidAccess = "not-accessible";
                break;
            }
            searchOid = oid.substring(0, oidwork - i);
            System.out.println("oidworkPos - i : " + (oidwork - i));
            System.out.println("searchOid : " + searchOid);
            ++i;
        }
    }

    private void setTestError(SnmpOperationDataHolder dataholder) throws SnmpCommandErrorTestException {
        int version = dataholder.getSnmpVersion();
        String community = dataholder.getRoCommunity();
        String requestOID = dataholder.getTargetOid();
        ManagerDispatcher dispacher = null;
        try {
            try {
                dispacher = new ManagerDispatcher();
                dispacher.setManagerDispatcher(dataholder.getTargetIP(), community, version);
                dispacher.dispathGetMessage(version, (byte)-95, requestOID);
            }
            catch (SnmpUnmuchRequestIDException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (SnmpUnmuchRequestMsgIDException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (GeneralSecurityException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (SnmpErrorStatusException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (SnmpBadValueException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (SnmpV3AuthAbortException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (SnmpV3DecryptAbortException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (SocketException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (SnmpConfigurationException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (SnmpV3ConfigurationException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (SnmpMIBGetException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (SnmpSetException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
            catch (IOException e) {
                logger.warning("Abort error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort error test : " + e.getMessage());
            }
        }
        finally {
            dispacher.closeConnection();
        }
        this.info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(dataholder.getTargetIP());
        String testCode = SnmpErrorTest.getInstance().getManagerErrorControlCode();
        logger.info("ErrorTest : " + testCode);
        if (testCode.equals("Unsupported security level")) {
            logger.info("UNSUPPORTED_SECURITY_LEVEL : Unknown engine ID");
            this.info.setLearned(false);
            SnmpV3ManagerUserConfigInfo userInfo = (SnmpV3ManagerUserConfigInfo)this.info.getUserList().get(0);
            if (userInfo.getAuthPriv().equals("NOAUTH")) {
                userInfo.setAuthPriv("PRIV");
            } else if (userInfo.getAuthPriv().equals("AUTH")) {
                userInfo.setAuthPriv("NOAUTH");
            } else if (userInfo.getAuthPriv().equals("PRIV")) {
                userInfo.setAuthPriv("NOAUTH");
            }
            this.info.addUserList(userInfo);
            SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(dataholder.getTargetIP(), this.info);
        } else if (testCode.equals("Not in time packet")) {
            this.info.setSnmpEngineBoots(Integer.toString(Integer.MAX_VALUE));
            this.info.setSnmpEngineTime(Integer.toString(Integer.MAX_VALUE));
            SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(dataholder.getTargetIP(), this.info);
        } else if (testCode.equals("Unknown user name")) {
            logger.info("UNKNOWN_USER_NAME : Unknown user name");
            this.info.setLearned(false);
            SnmpV3ManagerUserConfigInfo userInfo = (SnmpV3ManagerUserConfigInfo)this.info.getUserList().get(0);
            userInfo.setUsername("ABC DEF");
            this.info.addUserList(userInfo);
            SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(dataholder.getTargetIP(), this.info);
            try {
                UsmUserManager.getInstance().registList(new SnmpEngineID(this.info.getSnmpEngineID()), this.info);
            }
            catch (NumberFormatException e) {
                logger.warning("Abort UNKNOWN_USER_NAME error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort UNKNOWN_USER_NAME error test : " + e.getMessage());
            }
            catch (SnmpV3ConfigurationException e) {
                logger.warning("Abort UNKNOWN_USER_NAME error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort UNKNOWN_USER_NAME error test : " + e.getMessage());
            }
        } else if (testCode.equals("Unknown engine ID")) {
            logger.info("UNKNOWN_ENGINEID : Unknown engine ID");
            this.info.setLearned(true);
            this.info.setSnmpEngineID(Long.toString(Long.MAX_VALUE));
            this.info.setSnmpEngineBoots(Integer.toString(Integer.MAX_VALUE));
            this.info.setSnmpEngineTime(Integer.toString(Integer.MAX_VALUE));
            SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(dataholder.getTargetIP(), this.info);
            try {
                UsmUserManager.getInstance().registList(new SnmpEngineID(this.info.getSnmpEngineID()), this.info);
            }
            catch (NumberFormatException e) {
                logger.warning("Abort UNKNOWN_ENGINEID error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort UNKNOWN_ENGINEID error test : " + e.getMessage());
            }
            catch (SnmpV3ConfigurationException e) {
                logger.warning("Abort UNKNOWN_ENGINEID error test : " + e.getMessage());
                throw new SnmpCommandErrorTestException("Abort UNKNOWN_ENGINEID error test : " + e.getMessage());
            }
        } else if (testCode.equals("Wrong digest")) {
            logger.info("WRONG_DIGEST : Wrong digest");
            logger.info(((SnmpV3ManagerUserConfigInfo)this.info.getUserList().get(0)).getUsername());
            this.info.setLearned(false);
            SnmpV3ManagerUserConfigInfo userInfo = (SnmpV3ManagerUserConfigInfo)this.info.getUserList().get(0);
            userInfo.setAuthPassPhrase("AUTHPASSPHRASE");
            this.info.addUserList(userInfo);
            SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(dataholder.getTargetIP(), this.info);
            userInfo = (SnmpV3ManagerUserConfigInfo)this.info.getUserList().get(0);
            logger.info("AuthPassPhrase : " + userInfo.getAuthPassPhrase());
        } else if (testCode.equals("Descryption error")) {
            logger.info("DECRYPTION_ERROR : Descryption error");
            logger.info(((SnmpV3ManagerUserConfigInfo)this.info.getUserList().get(0)).getUsername());
            this.info.setLearned(false);
            SnmpV3ManagerUserConfigInfo userInfo = (SnmpV3ManagerUserConfigInfo)this.info.getUserList().get(0);
            userInfo.setPrivPassPhrase("PRIVPASSPHRASE");
            this.info.addUserList(userInfo);
            SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(dataholder.getTargetIP(), this.info);
            userInfo = (SnmpV3ManagerUserConfigInfo)this.info.getUserList().get(0);
            logger.info("PrivPassPhrase : " + userInfo.getPrivPassPhrase());
        } else {
            this.info = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(dataholder.getTargetIP());
        }
    }

    public static SnmpCommandOperation getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ SnmpCommandOperation(SnmpCommandOperation snmpCommandOperation) {
        this();
    }

    private static class SingletonResource {
        static final SnmpCommandOperation RESOURCE = new SnmpCommandOperation(null);

        private SingletonResource() {
        }
    }
}

