/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.common;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeChart;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.osgi.framework.Bundle;

public abstract class AbstractEditorNodeView
extends EditorPart {
    private static Logger logger;
    protected SubStatusLineManager statusLineManager;
    protected Image errorImage;
    protected Image warningImage;
    protected Image infoImage;
    protected Table table;
    protected boolean isSocket;
    protected String errorImageFile = "icons/alarm_level_.gif";
    protected String warningImageFile = "icons/alarm_level_warning.gif";
    protected String infoImageFile = "icons/alarm_level_info.gif";
    protected static Color WHITE_COLOR;
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    static {
        WHITE_COLOR = new Color(null, 255, 255, 255);
    }

    public AbstractEditorNodeView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public abstract void createPartControl(Composite var1);

    protected abstract void setStatusLine();

    protected void createImage(Composite parentComposite) {
        Display display = parentComposite.getDisplay();
        URL url = null;
        try {
            url = this.bundle.getEntry(this.errorImageFile);
            if (url == null) {
                logger.severe("Not found icon file : " + this.errorImageFile);
            } else {
                this.errorImage = new Image((Device)display, url.openStream());
            }
            url = this.bundle.getEntry(this.warningImageFile);
            if (url == null) {
                logger.severe("Not found icon file : " + this.errorImageFile);
            } else {
                this.warningImage = new Image((Device)display, url.openStream());
            }
            url = this.bundle.getEntry(this.infoImageFile);
            if (url == null) {
                logger.severe("Not found icon file : " + this.errorImageFile);
            } else {
                this.infoImage = new Image((Device)display, url.openStream());
            }
        }
        catch (IOException e) {
            logger.warning("Abort create image " + e.getMessage() + " for " + this.errorImageFile);
            e.printStackTrace();
        }
    }

    public void setFocus() {
    }

    public boolean isDirty() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof EditorInputNodeView) && !(input instanceof EditorInputNodeChart)) {
            logger.warning("Wrong input: " + input.getClass());
            throw new PartInitException("Wrong input: " + input.getClass());
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.table != null) {
            this.table.dispose();
        }
    }
}

