/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.jvm;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableGarbageCollection;
import netjfwatcher.engine.garbagecollection.GarbageCollectionMemoryJVM;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionGarbageCollection;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;
import netjfwatcher.engine.socket.info.GarbageCollectionInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EditorGarbageCollectionChart
extends AbstractEditorNodeChart {
    private static Logger logger;
    private static final int DATA_COUNT = 3;
    private static final int DATE_POS = 0;
    private static final int FREE_MEMORY_POS = 1;
    private static final int TOTAL_MEMORY_POS = 2;
    private ArrayList freeMemoryDataList = new ArrayList();
    private ArrayList totalMemoryDataList = new ArrayList();

    public EditorGarbageCollectionChart() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected void setPopupMenu(Composite parent) {
        this.popUpMenu = new Menu((Decorations)parent.getShell(), 8);
        this.canvas.setMenu(this.popUpMenu);
        MenuItem menuItemAll = new MenuItem(this.popUpMenu, 0);
        menuItemAll.setText("All");
        MenuItem menuItemRefresh = new MenuItem(this.popUpMenu, 0);
        menuItemRefresh.setText("Refresh");
        if (this.itemNameList != null && this.itemNameList.size() > 1) {
            MenuItem[] menuItem = new MenuItem[this.itemNameList.size()];
            int i = 0;
            while (i < this.itemNameList.size()) {
                menuItem[i] = new MenuItem(this.popUpMenu, 0);
                menuItem[i].setText((String)this.itemNameList.get(i));
                final int itemCount = i;
                menuItem[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        EditorGarbageCollectionChart.access$0("");
                        EditorGarbageCollectionChart.this.selectNo = itemCount;
                        EditorGarbageCollectionChart.this.redraw();
                    }
                });
                ++i;
            }
        }
        menuItemAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditorGarbageCollectionChart.access$0("all");
                EditorGarbageCollectionChart.this.selectNo = 0;
                EditorGarbageCollectionChart.this.redraw();
            }
        });
        menuItemRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditorGarbageCollectionChart.this.getChartData();
                EditorGarbageCollectionChart.access$0("all");
                EditorGarbageCollectionChart.this.selectNo = 0;
                EditorGarbageCollectionChart.this.redraw();
            }
        });
    }

    protected void getChartData() {
        if (this.maxData == null) {
            this.maxData = new String[2];
            this.minData = new String[2];
        }
        long totalMemoryMaxData = 0L;
        long totalMemoryMinData = 0L;
        long freeMemoryMaxData = 0L;
        long freeMemoryMinData = 0L;
        this.dateList.clear();
        this.allStatisticsDataList.clear();
        this.freeMemoryDataList.clear();
        this.totalMemoryDataList.clear();
        GarbageCollectionControl garbageControl = null;
        ArrayList garbageCollectionDataList = null;
        if (!this.isSocket) {
            DBTableGarbageCollection gar = DBTableGarbageCollection.getInstance();
            try {
                try {
                    garbageCollectionDataList = gar.findAll(null, null);
                    garbageControl = gar.getDataCount();
                }
                catch (DatabaseConnectionException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                catch (SQLException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            finally {
                gar = null;
            }
            if (garbageControl != null) {
                garbageControl.setThreadState(GarbageCollectionMemoryJVM.getInstance().checkThread());
                garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
            }
        } else {
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            System.out.println("EngineAddress : " + engineAddress);
            garbageControl = null;
            ConnectionGarbageCollection garbage = new ConnectionGarbageCollection(engineAddress);
            try {
                garbageControl = garbage.getGarbageCollectionInfo(null, null);
                garbageCollectionDataList = garbageControl.getGarbagCollectionMemoryList();
            }
            catch (EngineConnectException e) {
                logger.warning("Abort connect engine : " + e.getMessage());
            }
            catch (IOException e) {
                logger.warning("Abort connect engine : " + e.getMessage());
            }
        }
        if (garbageControl != null) {
            garbageControl.setGarbagCollectionMemoryList(garbageCollectionDataList);
            totalMemoryMaxData = garbageControl.getTotalMemoryMaxData();
            totalMemoryMinData = garbageControl.getTotalMemoryMinData();
            freeMemoryMaxData = garbageControl.getFreeMemoryMaxData();
            freeMemoryMinData = garbageControl.getFreeMemoryMinData();
            this.maxData[0] = Long.toString(freeMemoryMaxData);
            this.maxData[1] = Long.toString(totalMemoryMaxData);
            this.minData[0] = Long.toString(freeMemoryMinData);
            this.minData[1] = Long.toString(totalMemoryMinData);
        }
        if (garbageCollectionDataList == null || garbageCollectionDataList.size() < 1) {
            return;
        }
        int i = 0;
        while (i < garbageCollectionDataList.size()) {
            GarbageCollectionInfo garbageCollectionInfo = (GarbageCollectionInfo)garbageCollectionDataList.get(i);
            String[] garbageCollectionTableCellArray = new String[]{garbageCollectionInfo.getCheckDate().toString(), Long.toString(garbageCollectionInfo.getFreeMemory()), Long.toString(garbageCollectionInfo.getTotalMemory())};
            this.dateList.add(garbageCollectionTableCellArray[0]);
            this.freeMemoryDataList.add(garbageCollectionTableCellArray[1]);
            this.totalMemoryDataList.add(garbageCollectionTableCellArray[2]);
            ++i;
        }
        this.allStatisticsDataList.add(this.freeMemoryDataList);
        this.allStatisticsDataList.add(this.totalMemoryDataList);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    static /* synthetic */ void access$0(String string) {
        AbstractEditorNodeChart.mode = string;
    }
}

