/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.node;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.nodecontrol.NodeAdd;
import netjfwatcher.engine.nodecontrol.NodeDelete;
import netjfwatcher.engine.nodecontrol.NodeEdit;
import netjfwatcher.engine.socket.info.NodeInformation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class NodeOperationView
extends ViewPart {
    public static final String INITIAL_NODE_GROUP = "Default Group";
    public static final String INITIAL_ENGINE_ADDRESS = "localhost";
    public static final String INITIAL_NODE_PING_PERIOD = "0";
    public static final String INITIAL_NODE_PING_THRESHOLD = "20";
    public static final String INITIAL_NODE_SNMP_PERIOD = "300";
    public static final String INITIAL_NODE_HTTP_PERIOD = "0";
    public static final String INITIAL_NODE_HTTP_PORT = "80";
    public static final String INITIAL_NODE_HTTP_URL = "http://";
    public static final String INITIAL_NODE_SMTP_PERIOD = "0";
    public static final String INITIAL_NODE_POP_PERIOD = "0";
    public static final String INITIAL_NODE_SNMP_LEVEL = "0";
    public static final String INITIAL_NODE_SNMP_ROCOMMUNITY = "public";
    public static final String INITIAL_NODE_SNMP_RWCOMMUNITY = "private";
    public static final int AGENT_LIST_WIDTH = 200;
    public static final int AGENT_LIST_VERTICALSPAN = 7;
    public static final int TEXT_WIDTH1 = 120;
    private static Logger logger;
    private ArrayList nodeInfoFromDatabaseList;
    private HashMap checkAddressList = new HashMap();
    private List agentAddressList;
    private Text nodeNameText;
    private Text nodeIPAddressText;
    private Text nodeGroupText;
    private Combo nodeKindCombo;
    private Text pingPeriodText;
    private Text pingThresholdText;
    private Combo snmpVersionCombo;
    private Combo snmpLevelCombo;
    private Text snmpPeriodText;
    private Text snmpROCommunityText;
    private Text snmpRWCommunityText;
    private Text httpUrlText;
    private Text httpPortText;
    private Text httpPeriodText;
    private Text pop3PeriodText;
    private Text smtpPeriodText;
    private Button loadAgentAddressListButton;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;

    public void createPartControl(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite((Composite)scrollComposite, 0);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData(272));
        GridLayout gridLayout = new GridLayout(4, true);
        Composite composite1 = new Composite(composite0, 0);
        composite1.setLayout((Layout)gridLayout);
        composite1.setLayoutData((Object)new GridData(272));
        GridLayout gridLayout2 = new GridLayout(5, false);
        Composite composite2 = new Composite(composite0, 0);
        composite2.setLayoutData((Object)new GridData(272));
        composite2.setLayout((Layout)gridLayout2);
        gridData = new GridData();
        Label label = new Label(composite1, 0);
        label.setText("Agent address list");
        label.setLayoutData((Object)new GridData());
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.agentAddressList = new List(composite1, 2564);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.verticalSpan = 7;
        data.widthHint = 200;
        data.heightHint = this.agentAddressList.getItemHeight() * 8;
        this.agentAddressList.select(0);
        this.agentAddressList.setLayoutData((Object)data);
        this.loadAgentAddressListButton = new Button(composite1, 0);
        this.loadAgentAddressListButton.setText("Agent address list load");
        data = new GridData();
        data.horizontalSpan = 3;
        this.loadAgentAddressListButton.setLayoutData((Object)data);
        this.addButton = new Button(composite1, 0);
        this.addButton.setText("Node Add");
        data = new GridData();
        data.horizontalSpan = 3;
        this.addButton.setLayoutData((Object)data);
        this.editButton = new Button(composite1, 0);
        this.editButton.setText("Node Edit");
        data = new GridData();
        data.horizontalSpan = 3;
        this.editButton.setLayoutData((Object)data);
        this.deleteButton = new Button(composite1, 0);
        this.deleteButton.setText("Node Delete");
        data = new GridData();
        data.horizontalSpan = 3;
        this.deleteButton.setLayoutData((Object)data);
        label = new Label(composite2, 0);
        label.setText("Node Name");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.nodeNameText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeNameText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Ping");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pingPeriodText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pingPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Node IPAddress");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.nodeIPAddressText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeIPAddressText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Threshold");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pingThresholdText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pingThresholdText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Group");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.nodeGroupText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeGroupText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Snmp");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Version");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpVersionCombo = new Combo(composite2, 12);
        this.snmpVersionCombo.add("V1");
        this.snmpVersionCombo.add("V2");
        this.snmpVersionCombo.add("V3");
        this.snmpVersionCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpVersionCombo.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Node Kind");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.nodeKindCombo = new Combo(composite2, 12);
        HashMap nodeIconMap = MediaResource.getInstance().getIconDataList();
        for (String key : nodeIconMap.keySet()) {
            this.nodeKindCombo.add(key);
        }
        this.nodeKindCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeKindCombo.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Level");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpLevelCombo = new Combo(composite2, 12);
        this.snmpLevelCombo.add("No SNMP");
        this.snmpLevelCombo.add("SNMP Configration");
        this.snmpLevelCombo.add("SNMP ifOctets");
        this.snmpLevelCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpLevelCombo.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpPeriodText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("RO Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpROCommunityText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpROCommunityText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("RW Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpRWCommunityText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.snmpRWCommunityText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Http");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("URL");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.httpUrlText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.httpUrlText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.httpPortText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.httpPortText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.httpPeriodText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.httpPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Pop3");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pop3PeriodText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pop3PeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("SMTP");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpPeriodText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.smtpPeriodText.setLayoutData((Object)gridData);
        scrollComposite.setContent((Control)composite0);
        scrollComposite.setMinSize(800, 600);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.setTextDefaultNodeInfo();
        this.loadAgentAddressListButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                NodeOperationView.this.loadAgentAddressListButton.setEnabled(false);
                NodeOperationView.this.addButton.setEnabled(false);
                NodeOperationView.this.editButton.setEnabled(false);
                NodeOperationView.this.deleteButton.setEnabled(false);
                try {
                    NodeOperationView.this.setAgentNodeList();
                }
                finally {
                    NodeOperationView.this.addButton.setEnabled(true);
                    NodeOperationView.this.editButton.setEnabled(true);
                    NodeOperationView.this.deleteButton.setEnabled(true);
                    NodeOperationView.this.loadAgentAddressListButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.agentAddressList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = NodeOperationView.this.agentAddressList.getSelectionIndex();
                NodeInformation nodeInfo = (NodeInformation)NodeOperationView.this.nodeInfoFromDatabaseList.get(index);
                if (nodeInfo.getPingPeriod() == null || nodeInfo.getPingPeriod().equals("--") || nodeInfo.getPingPeriod().equals("null")) {
                    nodeInfo.setPingPeriod("0");
                }
                if (nodeInfo.getSnmpPeriod() == null || nodeInfo.getSnmpPeriod().equals("--") || nodeInfo.getSnmpPeriod().equals("null")) {
                    nodeInfo.setSnmpPeriod("0");
                }
                if (nodeInfo.getPopPeriod() == null || nodeInfo.getPopPeriod().equals("--") || nodeInfo.getPopPeriod().equals("null")) {
                    nodeInfo.setPopPeriod("0");
                }
                if (nodeInfo.getSmtpPeriod() == null || nodeInfo.getSmtpPeriod().equals("--") || nodeInfo.getSmtpPeriod().equals("null")) {
                    nodeInfo.setSmtpPeriod("0");
                }
                if (nodeInfo.getHttpPeriod() == null || nodeInfo.getHttpPeriod().equals("--") || nodeInfo.getHttpPeriod().equals("null")) {
                    nodeInfo.setHttpPeriod("0");
                }
                if (nodeInfo.getHttpPort() == null || nodeInfo.getHttpPort().equals("--") || nodeInfo.getHttpPort().equals("null")) {
                    nodeInfo.setHttpPort("");
                }
                NodeOperationView.this.setTextNodeInfo(nodeInfo);
            }
        });
        this.addButton.addSelectionListener(new SelectionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent event) {
                NodeOperationView.this.addButton.setEnabled(false);
                NodeOperationView.this.editButton.setEnabled(false);
                NodeOperationView.this.deleteButton.setEnabled(false);
                NodeOperationView.this.loadAgentAddressListButton.setEnabled(false);
                String addIPAddress = NodeOperationView.this.nodeIPAddressText.getText();
                try {
                    NodeOperationView.this.setAgentNodeList();
                    if (addIPAddress == null || addIPAddress.equals("")) {
                        MessageDialog.openError((Shell)NodeOperationView.this.getSite().getShell(), (String)"Error", (String)"Illegal IP Address");
                        return;
                    }
                    if (NodeOperationView.this.checkAddressList.containsKey(addIPAddress)) {
                        MessageDialog.openError((Shell)NodeOperationView.this.getSite().getShell(), (String)"Error", (String)("Already IP Address = " + addIPAddress));
                        return;
                    }
                    NodeInformation addNodeInfo = NodeOperationView.this.createNodeInfo();
                    NodeAdd nodeAddInstance = NodeAdd.getInstance();
                    nodeAddInstance.addNode(addNodeInfo, true);
                    NodeOperationView.this.setAgentNodeList();
                    NodeOperationView.this.setTextDefaultNodeInfo();
                    return;
                }
                finally {
                    NodeOperationView.this.addButton.setEnabled(true);
                    NodeOperationView.this.editButton.setEnabled(true);
                    NodeOperationView.this.deleteButton.setEnabled(true);
                    NodeOperationView.this.loadAgentAddressListButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent event) {
                NodeOperationView.this.addButton.setEnabled(false);
                NodeOperationView.this.editButton.setEnabled(false);
                NodeOperationView.this.deleteButton.setEnabled(false);
                NodeOperationView.this.loadAgentAddressListButton.setEnabled(false);
                String addIPAddress = NodeOperationView.this.nodeIPAddressText.getText();
                try {
                    if (addIPAddress == null || addIPAddress.equals("")) {
                        MessageDialog.openError((Shell)NodeOperationView.this.getSite().getShell(), (String)"Error", (String)"Illegal IP Address");
                        return;
                    }
                    if (!NodeOperationView.this.checkAddressList.containsKey(addIPAddress)) {
                        MessageDialog.openError((Shell)NodeOperationView.this.getSite().getShell(), (String)"Error", (String)("Not found IP Address = " + addIPAddress));
                        return;
                    }
                    NodeInformation addNodeInfo = NodeOperationView.this.createNodeInfo();
                    NodeEdit editNodeInstance = NodeEdit.getInstance();
                    try {
                        editNodeInstance.editNodeInfo(addNodeInfo);
                        NodeOperationView.this.setAgentNodeList();
                        return;
                    }
                    catch (DatabaseConnectionException e1) {
                        MessageDialog.openError((Shell)NodeOperationView.this.getSite().getShell(), (String)"Error", (String)("DatabaseConnectionException " + e1 + " IP Address = " + addIPAddress));
                        return;
                    }
                    catch (SQLException e1) {
                        MessageDialog.openError((Shell)NodeOperationView.this.getSite().getShell(), (String)"Error", (String)("SQLException " + e1.getMessage() + " IP Address = " + addIPAddress));
                    }
                    return;
                }
                finally {
                    NodeOperationView.this.addButton.setEnabled(true);
                    NodeOperationView.this.editButton.setEnabled(true);
                    NodeOperationView.this.deleteButton.setEnabled(true);
                    NodeOperationView.this.loadAgentAddressListButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.deleteButton.addSelectionListener(new SelectionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent event) {
                NodeOperationView.this.addButton.setEnabled(false);
                NodeOperationView.this.editButton.setEnabled(false);
                NodeOperationView.this.deleteButton.setEnabled(false);
                NodeOperationView.this.loadAgentAddressListButton.setEnabled(false);
                try {
                    String addIPAddress = NodeOperationView.this.nodeIPAddressText.getText();
                    if (addIPAddress == null || addIPAddress.equals("")) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)"Illegal IP Address");
                        NodeOperationView.this.deleteButton.setEnabled(true);
                        return;
                    }
                    if (!NodeOperationView.this.checkAddressList.containsKey(addIPAddress)) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)("Not found IP Address = " + addIPAddress));
                        NodeOperationView.this.deleteButton.setEnabled(true);
                        return;
                    }
                    NodeDelete del = NodeDelete.getInstance();
                    del.removeThreadList(addIPAddress);
                    NodeOperationView.this.setAgentNodeList();
                    return;
                }
                finally {
                    NodeOperationView.this.addButton.setEnabled(true);
                    NodeOperationView.this.editButton.setEnabled(true);
                    NodeOperationView.this.deleteButton.setEnabled(true);
                    NodeOperationView.this.loadAgentAddressListButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void setTextDefaultNodeInfo() {
        this.nodeKindCombo.select(0);
        this.snmpVersionCombo.select(0);
        this.snmpLevelCombo.select(0);
        this.nodeGroupText.setText(INITIAL_NODE_GROUP);
        this.pingPeriodText.setText("0");
        this.pingThresholdText.setText(INITIAL_NODE_PING_THRESHOLD);
        this.snmpPeriodText.setText(INITIAL_NODE_SNMP_PERIOD);
        this.snmpROCommunityText.setText(INITIAL_NODE_SNMP_ROCOMMUNITY);
        this.snmpRWCommunityText.setText(INITIAL_NODE_SNMP_RWCOMMUNITY);
        this.httpUrlText.setText(INITIAL_NODE_HTTP_URL);
        this.httpPortText.setText(INITIAL_NODE_HTTP_PORT);
        this.httpPeriodText.setText("0");
        this.pop3PeriodText.setText("0");
        this.smtpPeriodText.setText("0");
    }

    private void setAgentNodeList() {
        this.agentAddressList.removeAll();
        if (this.nodeInfoFromDatabaseList != null) {
            this.nodeInfoFromDatabaseList.clear();
        }
        this.checkAddressList.clear();
        this.nodeInfoFromDatabaseList = this.getNodeList();
        int i = 0;
        while (i < this.nodeInfoFromDatabaseList.size()) {
            NodeInformation nodeInfo = (NodeInformation)this.nodeInfoFromDatabaseList.get(i);
            this.agentAddressList.add(String.valueOf(nodeInfo.getNodename()) + " : " + nodeInfo.getIpaddress());
            this.checkAddressList.put(nodeInfo.getIpaddress(), nodeInfo);
            ++i;
        }
    }

    private NodeInformation createNodeInfo() {
        NodeInformation workNodeInfo = new NodeInformation();
        workNodeInfo.setIpaddress(this.nodeIPAddressText.getText());
        workNodeInfo.setNodename(this.nodeNameText.getText());
        String engineAddress = INITIAL_ENGINE_ADDRESS;
        try {
            engineAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warning(e.getMessage());
        }
        workNodeInfo.setEngineAddress(engineAddress);
        workNodeInfo.setGroup(this.nodeGroupText.getText());
        workNodeInfo.setNodeKind(this.nodeKindCombo.getText());
        workNodeInfo.setPingPeriod(this.pingPeriodText.getText());
        workNodeInfo.setPingThreshold(this.pingThresholdText.getText());
        workNodeInfo.setSnmpPeriod(this.snmpPeriodText.getText());
        workNodeInfo.setRoCommunity(this.snmpROCommunityText.getText());
        workNodeInfo.setRwCommunity(this.snmpRWCommunityText.getText());
        int snmpVersion = this.snmpVersionCombo.getSelectionIndex();
        switch (snmpVersion) {
            case 0: {
                workNodeInfo.setSnmpVersion("SNMPV1");
                break;
            }
            case 1: {
                workNodeInfo.setSnmpVersion("SNMPV2C");
                break;
            }
            case 2: {
                workNodeInfo.setSnmpVersion("SNMPV3");
                break;
            }
            default: {
                logger.warning("Illegal SNMP Version Index " + snmpVersion);
            }
        }
        String snmpLevel = this.snmpLevelCombo.getText();
        if (snmpLevel.equals("No SNMP")) {
            workNodeInfo.setSnmpLevel("0");
        } else if (snmpLevel.equals("SNMP Configration")) {
            workNodeInfo.setSnmpLevel("1");
        } else if (snmpLevel.equals("SNMP ifOctets")) {
            workNodeInfo.setSnmpLevel("2");
        } else {
            workNodeInfo.setSnmpLevel("0");
        }
        workNodeInfo.setHttpUrl(this.httpUrlText.getText());
        workNodeInfo.setHttpPort(this.httpPortText.getText());
        workNodeInfo.setHttpPeriod(this.httpPeriodText.getText());
        workNodeInfo.setPopPeriod(this.pop3PeriodText.getText());
        workNodeInfo.setSmtpPeriod(this.smtpPeriodText.getText());
        return workNodeInfo;
    }

    private void setTextNodeInfo(NodeInformation refreshNodeInfo) {
        this.nodeNameText.setText(refreshNodeInfo.getNodename());
        this.nodeIPAddressText.setText(refreshNodeInfo.getIpaddress());
        this.nodeGroupText.setText(refreshNodeInfo.getGroup());
        if (refreshNodeInfo.getNodeKind() != null) {
            this.nodeKindCombo.setText(refreshNodeInfo.getNodeKind());
        }
        if (refreshNodeInfo.getPingPeriod() != null) {
            this.pingPeriodText.setText(refreshNodeInfo.getPingPeriod());
        }
        if (refreshNodeInfo.getPingThreshold() != null) {
            this.pingThresholdText.setText(refreshNodeInfo.getPingThreshold());
        }
        if (refreshNodeInfo.getSnmpVersion() != null) {
            if (refreshNodeInfo.getSnmpVersion().equals("SNMPV1")) {
                this.snmpVersionCombo.select(0);
            } else if (refreshNodeInfo.getSnmpVersion().equals("SNMPV2C")) {
                this.snmpVersionCombo.select(1);
            } else if (refreshNodeInfo.getSnmpVersion().equals("SNMPV3")) {
                this.snmpVersionCombo.select(2);
            }
        }
        if (refreshNodeInfo.getSnmpLevel() != null) {
            if (refreshNodeInfo.getSnmpLevel().equals("0")) {
                this.snmpLevelCombo.select(0);
            } else if (refreshNodeInfo.getSnmpLevel().equals("1")) {
                this.snmpLevelCombo.select(1);
            } else if (refreshNodeInfo.getSnmpLevel().equals("2")) {
                this.snmpLevelCombo.select(2);
            }
        }
        if (refreshNodeInfo.getSnmpPeriod() != null) {
            this.snmpPeriodText.setText(refreshNodeInfo.getSnmpPeriod());
        }
        if (refreshNodeInfo.getRoCommunity() != null) {
            this.snmpROCommunityText.setText(refreshNodeInfo.getRoCommunity());
        }
        if (refreshNodeInfo.getRwCommunity() != null) {
            this.snmpRWCommunityText.setText(refreshNodeInfo.getRwCommunity());
        }
        if (refreshNodeInfo.getHttpUrl() != null) {
            this.httpUrlText.setText(refreshNodeInfo.getHttpUrl());
        }
        if (refreshNodeInfo.getHttpPort() != null) {
            this.httpPortText.setText(refreshNodeInfo.getHttpPort());
        }
        if (refreshNodeInfo.getHttpPeriod() != null) {
            this.httpPeriodText.setText(refreshNodeInfo.getHttpPeriod());
        }
        if (refreshNodeInfo.getPopPeriod() != null) {
            this.pop3PeriodText.setText(refreshNodeInfo.getPopPeriod());
        }
        if (refreshNodeInfo.getSmtpPeriod() != null) {
            this.smtpPeriodText.setText(refreshNodeInfo.getSmtpPeriod());
        }
    }

    public void setFocus() {
    }

    private ArrayList getNodeList() {
        DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
        ArrayList nodeList = null;
        try {
            try {
                nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
            }
            catch (SQLException e1) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Node List import error", (String)e1.getMessage());
                logger.warning("Node List import error " + e1.getMessage());
                e1.printStackTrace();
            }
            catch (Exception e1) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Node List import error", (String)e1.getMessage());
                logger.warning("Node List import error " + e1.getMessage());
                e1.printStackTrace();
            }
        }
        finally {
            nodeRegisterDBTable = null;
        }
        return nodeList;
    }
}

