/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderNodeDataTable;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeSnmpStatisticsChart;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeSnmpStatisticsTable;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionStatisticsMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibIfDescriptor;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.engine.socket.info.StatisticsMibSetStatus;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.osgi.framework.Bundle;

public class NodeSnmpStatisticsMenu {
    private static Logger logger;
    private Bundle bundle;
    private Image chartImage;
    private Image tableImage;
    private ActionBuilderChart nodeChart = new ActionBuilderChart();
    private ActionBuilderNodeDataTable dataTableAction = new ActionBuilderNodeDataTable();

    public NodeSnmpStatisticsMenu() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void createSnmpStatisticsMenu(IMenuManager manager, NodeInformation targetNodeInfo, boolean isSocket) {
        String ipAddress = targetNodeInfo.getIpaddress();
        ArrayList nodeOidList = this.getStatisticsMibInfo(ipAddress, isSocket);
        if (nodeOidList != null && nodeOidList.size() > 0) {
            MenuManager snmpStatisticsMenu = new MenuManager("Node Snmp Statistics Data");
            manager.add((IContributionItem)snmpStatisticsMenu);
            snmpStatisticsMenu.add((IContributionItem)new Separator());
            int j = 0;
            while (j < nodeOidList.size()) {
                String title;
                ActionBuilderChart.ActionNodeSnmpStatisticsChartView actionSnmpStatistics;
                ActionBuilderNodeDataTable.AbstractDataTableAction snmpStatisticsOidAction;
                String oid = (String)nodeOidList.get(j);
                String oidDescription = "";
                if (ManagerMibTree.getInstance().getOidHashMap().containsKey(oid)) {
                    MibInfo miboid = (MibInfo)ManagerMibTree.getInstance().getOidHashMap().get(oid);
                    oidDescription = miboid.getDescrip();
                }
                if (!isSocket) {
                    snmpStatisticsOidAction = (ActionBuilderNodeDataTable.ActionShowStatisticsData)this.dataTableAction.actionShowStatisticsData();
                    ((ActionBuilderNodeDataTable.ActionShowStatisticsData)snmpStatisticsOidAction).setNodeInfo(targetNodeInfo);
                    ((ActionBuilderNodeDataTable.ActionShowStatisticsData)snmpStatisticsOidAction).setOid(oid);
                    snmpStatisticsOidAction.setText(String.valueOf(oidDescription) + "  OID=" + oid);
                    snmpStatisticsOidAction.setToolTipText(String.valueOf(oidDescription) + "  OID=" + oid);
                    snmpStatisticsMenu.add((IAction)snmpStatisticsOidAction);
                } else {
                    snmpStatisticsOidAction = (ActionBuilderNodeDataTable.ActionShowStatisticsDataSocket)this.dataTableAction.actionShowStatisticsDataSocket();
                    ((ActionBuilderNodeDataTable.ActionShowStatisticsDataSocket)snmpStatisticsOidAction).setNodeInfo(targetNodeInfo);
                    ((ActionBuilderNodeDataTable.ActionShowStatisticsDataSocket)snmpStatisticsOidAction).setOid(oid);
                    snmpStatisticsOidAction.setText(String.valueOf(oidDescription) + "  OID=" + oid);
                    snmpStatisticsOidAction.setToolTipText(String.valueOf(oidDescription) + "  OID=" + oid);
                    snmpStatisticsMenu.add((IAction)snmpStatisticsOidAction);
                }
                ArrayList snmpStatisticsNameList = null;
                try {
                    snmpStatisticsNameList = this.getStatisticsMibInfo(targetNodeInfo.getIpaddress(), oid, isSocket);
                }
                catch (DatabaseConnectionException e) {
                    logger.warning(e.getMessage());
                    return;
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    return;
                }
                if (!isSocket) {
                    actionSnmpStatistics = null;
                    actionSnmpStatistics = (ActionBuilderChart.ActionNodeSnmpStatisticsChartView)this.nodeChart.getNewActionNodeSnmpStatisticsChartView();
                    actionSnmpStatistics.setText(String.valueOf(oidDescription) + "  OID=" + oid);
                    actionSnmpStatistics.setToolTipText(String.valueOf(oidDescription) + "  OID=" + oid);
                    title = String.valueOf(targetNodeInfo.getNodename()) + "(" + targetNodeInfo.getIpaddress() + ") " + " OID=" + oid + " Chart";
                    actionSnmpStatistics.setTitle(title);
                    actionSnmpStatistics.setNodeInfo(targetNodeInfo);
                    actionSnmpStatistics.setOid(oid);
                    actionSnmpStatistics.setNameList(snmpStatisticsNameList);
                    snmpStatisticsMenu.add((IAction)actionSnmpStatistics);
                } else {
                    actionSnmpStatistics = null;
                    actionSnmpStatistics = (ActionBuilderChart.ActionNodeSnmpStatisticsChartViewSocket)this.nodeChart.getNewActionNodeSnmpStatisticsChartViewSocket();
                    actionSnmpStatistics.setText(String.valueOf(oidDescription) + "  OID=" + oid);
                    actionSnmpStatistics.setToolTipText(String.valueOf(oidDescription) + "  OID=" + oid);
                    title = String.valueOf(targetNodeInfo.getNodename()) + "(" + targetNodeInfo.getIpaddress() + ") " + " OID=" + oid + " Chart";
                    actionSnmpStatistics.setTitle(title);
                    actionSnmpStatistics.setNodeInfo(targetNodeInfo);
                    actionSnmpStatistics.setOid(oid);
                    actionSnmpStatistics.setNameList(snmpStatisticsNameList);
                    snmpStatisticsMenu.add((IAction)actionSnmpStatistics);
                }
                ++j;
            }
        }
    }

    public void createSnmpStatisticsMenu(Menu popUpMenu, NodeInformation targetNodeInfo, boolean isSocket) {
        String ipAddress = targetNodeInfo.getIpaddress();
        ArrayList nodeOidList = this.getStatisticsMibInfo(ipAddress, isSocket);
        if (nodeOidList != null && nodeOidList.size() > 0) {
            MenuItem snmpStatisticsMenuItem = new MenuItem(popUpMenu, 64);
            snmpStatisticsMenuItem.setText("Node Snmp Statistics Data");
            Menu submenu = new Menu(snmpStatisticsMenuItem);
            snmpStatisticsMenuItem.setMenu(submenu);
            MenuItem[] menuItemSnmpStatistics = new MenuItem[nodeOidList.size() * 2];
            this.bundle = NetJFWatcherPlugin.getInstance().getBundle();
            ImageDescriptor chartImageDescriptor = ImageDescriptor.createFromURL((URL)this.bundle.getEntry("icons/chart.gif"));
            ImageDescriptor tableImageDescriptor = ImageDescriptor.createFromURL((URL)this.bundle.getEntry("icons/table.gif"));
            if (this.chartImage == null) {
                this.chartImage = chartImageDescriptor.createImage();
            }
            if (this.tableImage == null) {
                this.tableImage = tableImageDescriptor.createImage();
            }
            int j = 0;
            while (j < nodeOidList.size()) {
                String oid = (String)nodeOidList.get(j);
                String oidDescription = "";
                if (ManagerMibTree.getInstance().getOidHashMap().containsKey(oid)) {
                    MibInfo miboid = (MibInfo)ManagerMibTree.getInstance().getOidHashMap().get(oid);
                    oidDescription = miboid.getDescrip();
                }
                menuItemSnmpStatistics[j] = new MenuItem(submenu, 8);
                menuItemSnmpStatistics[j].setText(String.valueOf(oidDescription) + "  OID=" + oid + " Table");
                menuItemSnmpStatistics[j].setImage(this.tableImage);
                NodeMapMenuNodeSnmpStatisticsTable nodeSnmp = new NodeMapMenuNodeSnmpStatisticsTable(targetNodeInfo, isSocket, oid);
                menuItemSnmpStatistics[j].addSelectionListener((SelectionListener)nodeSnmp);
                ArrayList snmpStatisticsNameList = null;
                try {
                    snmpStatisticsNameList = this.getStatisticsMibInfo(targetNodeInfo.getIpaddress(), oid, isSocket);
                }
                catch (DatabaseConnectionException e) {
                    logger.warning(e.getMessage());
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                }
                menuItemSnmpStatistics[j * 2] = new MenuItem(submenu, 8);
                menuItemSnmpStatistics[j * 2].setText(String.valueOf(oidDescription) + "  OID=" + oid + " Chart");
                menuItemSnmpStatistics[j * 2].setImage(this.chartImage);
                NodeMapMenuNodeSnmpStatisticsChart nodeSnmpChart = new NodeMapMenuNodeSnmpStatisticsChart(targetNodeInfo, isSocket, oid, snmpStatisticsNameList);
                menuItemSnmpStatistics[j * 2].addSelectionListener((SelectionListener)nodeSnmpChart);
                ++j;
            }
        }
    }

    protected ArrayList getStatisticsMibInfo(String ipAddress, boolean isSocket) {
        ArrayList<String> oidList = new ArrayList<String>();
        ArrayList statisticsMibSetStatusList = null;
        if (!isSocket) {
            DBTableStatisticsMIBControl mibDBTable = DBTableStatisticsMIBControl.getInstance();
            try {
                statisticsMibSetStatusList = mibDBTable.getList(ipAddress);
            }
            catch (SQLException e1) {
                logger.warning(String.valueOf(e1.getMessage()) + " IP=" + ipAddress);
            }
            catch (DatabaseConnectionException e1) {
                logger.warning(String.valueOf(e1.getMessage()) + " IP=" + ipAddress);
            }
        } else {
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            StatisticsMibControl control = new StatisticsMibControl();
            control.setSubCommand("Statistics_Set_Status_Get");
            control.setIpaddress(ipAddress);
            ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(engineAddress);
            try {
                StatisticsMibProperty mibproperty = statisticsMibGet.getStatisticsMib(control);
                if (mibproperty != null) {
                    statisticsMibSetStatusList = mibproperty.getStatisticsMibSetList();
                }
            }
            catch (EngineConnectException e) {
                logger.warning("EngineConnectException " + e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.warning("IOException " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (statisticsMibSetStatusList == null) {
            return null;
        }
        int i = 0;
        while (i < statisticsMibSetStatusList.size()) {
            StatisticsMibSetStatus snmpStatisticsStatus = (StatisticsMibSetStatus)statisticsMibSetStatusList.get(i);
            oidList.add(snmpStatisticsStatus.getReadOid());
            ++i;
        }
        return oidList;
    }

    private ArrayList getStatisticsMibInfo(String ipAddress, String selectOid, boolean isSocket) throws DatabaseConnectionException, SQLException {
        ArrayList ifDescriptorList = null;
        if (!isSocket) {
            DBTableStatisticsMIBControl mibDBTable = DBTableStatisticsMIBControl.getInstance();
            ifDescriptorList = mibDBTable.findIfDescriptor(ipAddress);
        } else {
            StatisticsMibControl control = new StatisticsMibControl();
            control.setSubCommand("If_Desc_Get");
            control.setIpaddress(ipAddress);
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(engineAddress);
            try {
                StatisticsMibProperty mibproperty = statisticsMibGet.getStatisticsMib(control);
                ifDescriptorList = mibproperty.getMibIfDescriptorList();
            }
            catch (EngineConnectException e) {
                logger.warning("EngineConnectException " + e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.warning("IOException " + e.getMessage());
                e.printStackTrace();
            }
        }
        ArrayList<String> nameList = new ArrayList<String>();
        int i = 0;
        while (i < ifDescriptorList.size()) {
            StatisticsMibIfDescriptor mibIfDesc = (StatisticsMibIfDescriptor)ifDescriptorList.get(i);
            String workOid = mibIfDesc.getOid();
            int checkPoint = "Oid=".length();
            if (checkPoint >= 0 && workOid.substring(checkPoint).equals(selectOid)) {
                if (mibIfDesc.getIfDescriptor().equals("")) {
                    nameList.add(mibIfDesc.getInstance());
                    logger.info("mibIfDesc : " + mibIfDesc.getInstance());
                } else {
                    nameList.add(String.valueOf(mibIfDesc.getInstance()) + " (" + mibIfDesc.getIfDescriptor() + ")");
                    logger.info("mibIfDesc : " + mibIfDesc.getInstance() + " (" + mibIfDesc.getIfDescriptor() + ")");
                }
            }
            ++i;
        }
        return nameList;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.chartImage != null) {
            this.chartImage.dispose();
        }
        if (this.tableImage != null) {
            this.tableImage.dispose();
        }
    }
}

