/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.opaque;

import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.opaque.SnmpOpaque;

public class SnmpOpaqueFloat
extends SnmpOpaque {
    private static Logger logger;
    private float opaqueFloatValue;

    protected SnmpOpaqueFloat(float value) {
        logger = Logger.getLogger(this.getClass().getName());
        this.opaqueFloatValue = value;
    }

    protected SnmpOpaqueFloat(byte[] data, int offset, int length) throws SnmpBadValueException {
        logger = Logger.getLogger(this.getClass().getName());
        this.opaqueFloatValue = this.decode(data, offset, length);
    }

    public String toString() {
        return Float.toString(this.opaqueFloatValue);
    }

    byte[] encode() {
        return this.encode(this.opaqueFloatValue);
    }

    public byte[] encode(float value) {
        int intValue = Float.floatToIntBits(value);
        byte[] array = new byte[]{68, 7, -97, 120, 4, (byte)(intValue >> 24 & 0xFFFFFFFF), (byte)(intValue >> 16 & 0xFFFFFFFF), (byte)(intValue >> 8 & 0xFFFFFFFF), (byte)(intValue & 0xFFFFFFFF)};
        return array;
    }

    public float decode(byte[] data, int offset, int length) throws SnmpBadValueException {
        if (length != 4) {
            throw new SnmpBadValueException(new StringBuffer().append("length is not 4: ").append(length).toString());
        }
        int intValue = 0;
        try {
            int i = 0;
            while (i < length) {
                intValue <<= 8;
                intValue |= data[offset + i] & 0xFFFFFFFF;
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpBadValueException(e.getMessage());
        }
        return Float.intBitsToFloat(intValue);
    }

    public Object getValue() {
        Float valued = new Float(this.opaqueFloatValue);
        return valued;
    }
}

