/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.netjfwatcher;

import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.snmpagent.model.AgentDataImport;
import netjfwatcher.snmpagent.netjfwatcher.NicInfo;
import org.eclipse.swt.widgets.Table;

public class SnmpNetJFWatcher
extends DataStringDisplay {
    private int ifNumber;
    private ArrayList<NicInfo> nicInfoList = new ArrayList();
    private static final String[] SYSTEM_MIB_OID = new String[]{"1.3.6.1.2.1.1.1", "1.3.6.1.2.1.1.2", "1.3.6.1.2.1.1.3", "1.3.6.1.2.1.1.4", "1.3.6.1.2.1.1.5", "1.3.6.1.2.1.1.6"};
    private static final String[] SYSTEM_MIB_OID_VALUE = new String[]{"netjfwatcher", "1.2.4.1", "0", "admin@localhost", "netjfwacher", "sysLocation"};
    private static final String IF_NUMBER_OID = "1.3.6.1.2.1.2.1";
    private static final String[] INTERFACE_OID_ARRAY = new String[]{"1.3.6.1.2.1.2.2.1.1", "1.3.6.1.2.1.2.2.1.2", "1.3.6.1.2.1.2.2.1.3", "1.3.6.1.2.1.2.2.1.4", "1.3.6.1.2.1.2.2.1.5", "1.3.6.1.2.1.2.2.1.6", "1.3.6.1.2.1.2.2.1.7", "1.3.6.1.2.1.2.2.1.8"};

    private SnmpNetJFWatcher() {
    }

    public void setNetJFWatcher(Table mibInstnaceTable) throws Exception {
        String ifStatus;
        NicInfo nicInfo;
        String[] systemMibValue = new String[SYSTEM_MIB_OID.length];
        systemMibValue[0] = SYSTEM_MIB_OID_VALUE[0];
        systemMibValue[1] = SYSTEM_MIB_OID_VALUE[1];
        systemMibValue[2] = SYSTEM_MIB_OID_VALUE[2];
        systemMibValue[3] = SYSTEM_MIB_OID_VALUE[3];
        systemMibValue[4] = SYSTEM_MIB_OID_VALUE[4];
        systemMibValue[5] = SYSTEM_MIB_OID_VALUE[5];
        int counter = 0;
        AgentDataImport agentDataImport = new AgentDataImport();
        agentDataImport.setNetJFWatcher0();
        int i = 0;
        while (i < SYSTEM_MIB_OID.length) {
            agentDataImport.setNetJFWatcher1(++counter, mibInstnaceTable, SYSTEM_MIB_OID[i], "0", systemMibValue[i]);
            ++i;
        }
        this.getNicInfo();
        agentDataImport.setNetJFWatcher1(++counter, mibInstnaceTable, IF_NUMBER_OID, "0", Integer.toString(this.ifNumber));
        int j = 0;
        while (j < this.nicInfoList.size()) {
            agentDataImport.setNetJFWatcher1(++counter, mibInstnaceTable, INTERFACE_OID_ARRAY[0], Integer.toString(j + 1), Integer.toString(j + 1));
            ++j;
        }
        j = 0;
        while (j < this.nicInfoList.size()) {
            nicInfo = this.nicInfoList.get(j);
            agentDataImport.setNetJFWatcher1(++counter, mibInstnaceTable, INTERFACE_OID_ARRAY[1], Integer.toString(j + 1), String.valueOf(nicInfo.getName()) + "(" + nicInfo.getDisplayName() + ")");
            ++j;
        }
        j = 0;
        while (j < this.nicInfoList.size()) {
            agentDataImport.setNetJFWatcher1(++counter, mibInstnaceTable, INTERFACE_OID_ARRAY[2], Integer.toString(j + 1), "1");
            ++j;
        }
        j = 0;
        while (j < this.nicInfoList.size()) {
            nicInfo = this.nicInfoList.get(j);
            agentDataImport.setNetJFWatcher1(++counter, mibInstnaceTable, INTERFACE_OID_ARRAY[3], Integer.toString(j + 1), Integer.toString(nicInfo.getMtu()));
            ++j;
        }
        j = 0;
        while (j < this.nicInfoList.size()) {
            agentDataImport.setNetJFWatcher1(++counter, mibInstnaceTable, INTERFACE_OID_ARRAY[4], Integer.toString(j + 1), "0");
            ++j;
        }
        j = 0;
        while (j < this.nicInfoList.size()) {
            nicInfo = this.nicInfoList.get(j);
            agentDataImport.setNetJFWatcher1(++counter, mibInstnaceTable, INTERFACE_OID_ARRAY[5], Integer.toString(j + 1), nicInfo.getMacAddress());
            ++j;
        }
        j = 0;
        while (j < this.nicInfoList.size()) {
            nicInfo = this.nicInfoList.get(j);
            ifStatus = "1";
            ifStatus = nicInfo.isUP() ? "1" : "2";
            agentDataImport.setNetJFWatcher1(++counter, mibInstnaceTable, INTERFACE_OID_ARRAY[6], Integer.toString(j + 1), ifStatus);
            ++j;
        }
        j = 0;
        while (j < this.nicInfoList.size()) {
            nicInfo = this.nicInfoList.get(j);
            ifStatus = "1";
            ifStatus = nicInfo.isUP() ? "1" : "2";
            agentDataImport.setNetJFWatcher1(++counter, mibInstnaceTable, INTERFACE_OID_ARRAY[7], Integer.toString(j + 1), ifStatus);
            ++j;
        }
        j = 0;
        while (j < this.nicInfoList.size()) {
            agentDataImport.setNetJFWatcher1(++counter, mibInstnaceTable, "1.3.6.1.2.1.2.2.1.9", Integer.toString(j + 1), "0");
            ++j;
        }
        agentDataImport.setNetJFWatcher2();
    }

    private void getNicInfo() throws SocketException {
        this.nicInfoList.clear();
        Enumeration<NetworkInterface> enuNics = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface nic : Collections.list(enuNics)) {
            NicInfo nicInfo = new NicInfo();
            nicInfo.setDisplayName(nic.getDisplayName());
            nicInfo.setName(nic.getName());
            nicInfo.setMtu(nic.getMTU());
            nicInfo.setUP(nic.isUp());
            System.out.println("DisplayName: " + nic.getDisplayName());
            System.out.println("Name: " + nic.getName());
            System.out.println("MTU: " + nic.getMTU());
            System.out.println("isUP: " + nic.isUp());
            if (nic.getHardwareAddress() != null) {
                nicInfo.setMacAddress(this.getMacAddrString(nic.getHardwareAddress()));
                System.out.println("Mac Address: " + this.getMacAddrString(nic.getHardwareAddress()));
                ++this.ifNumber;
                this.nicInfoList.add(nicInfo);
            }
            List<InterfaceAddress> lstAddrs = nic.getInterfaceAddresses();
            for (InterfaceAddress addr : lstAddrs) {
                System.out.println("IP Address: " + addr.getAddress());
                System.out.println("Broadcast Address: " + addr.getBroadcast());
                System.out.println("Subnet mask length: " + addr.getNetworkPrefixLength());
            }
        }
    }

    private String getMacAddrString(byte[] dataArray) {
        String returnString;
        if (dataArray.length > 0 && dataArray.length > 1 && dataArray[0] <= 127 && dataArray[0] >= 32) {
            returnString = new String(dataArray);
        } else {
            returnString = dataArray.length > 2 ? "0x" : "";
            int i = 0;
            while (i < dataArray.length) {
                returnString = String.valueOf(returnString) + this.hexByte(dataArray[i]);
                ++i;
            }
        }
        return returnString;
    }

    public static SnmpNetJFWatcher getInstance() {
        return SingletonResource.NETJ_INSTANCE;
    }

    /* synthetic */ SnmpNetJFWatcher(SnmpNetJFWatcher snmpNetJFWatcher) {
        this();
    }

    private static class SingletonResource {
        static final SnmpNetJFWatcher NETJ_INSTANCE = new SnmpNetJFWatcher(null);

        private SingletonResource() {
        }
    }
}

