/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmpagent.model.AgentMonitorMessageQueue;
import netjfwatcher.snmpagent.process.AbstractAgentMessageProcessing;

public class AgentV1MP
extends AbstractAgentMessageProcessing {
    private static Logger logger;
    private SnmpAgentConfigInfo info;

    public AgentV1MP() throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        this.version = 0;
    }

    public AgentV1MP(DatagramSocket dSocket) throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        this.version = 0;
        this.info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpAgentResourceInfo();
        this.resSendDatagramSocket = dSocket;
    }

    public void process(DatagramPacket inPacket, byte[] encodedMessage, int receiveLength) throws SnmpErrorStatusException, SnmpBadValueException, IOException {
        this.inPacket = inPacket;
        String community = "";
        byte command = 0;
        SnmpMessage receivedMessage = null;
        try {
            receivedMessage = new SnmpMessage();
            SNMPTLV nextTLV = receivedMessage.extractNextTLV(encodedMessage, 0);
            receivedMessage.setTLV(nextTLV);
            byte[] versionByte = receivedMessage.getVersion();
            byte[] communityByte = receivedMessage.getCommunity();
            community = this.bytetoChar(communityByte);
            command = receivedMessage.getCommand();
            logger.info("Version : " + versionByte[0]);
            logger.info("Community : " + this.bytetoChar(communityByte));
            logger.info("Command : " + this.hexByte(command));
        }
        catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            throw e;
        }
        this.receivedMessage = receivedMessage;
        switch (command) {
            case -96: {
                if (community.equals(this.info.getReadCommunity())) {
                    this.getRequest(this.version, this.info.getReadCommunity(), inPacket, receivedMessage);
                    break;
                }
                logger.warning("Receive read community : " + community + " Allow read community : " + this.info.getReadCommunity());
                Date date = Calendar.getInstance().getTime();
                AgentMonitorMessageQueue.getInstance().pushAgentMessage("Community error : " + dateformat.format(date) + "Receive write community : " + community + " Allow write community : " + this.info.getReadCommunity());
                break;
            }
            case -95: {
                if (community.equals(this.info.getReadCommunity())) {
                    this.getNextRequest(this.version, this.info.getReadCommunity(), inPacket, receivedMessage);
                    break;
                }
                logger.warning("Receive read community : " + community + " Allow read community : " + this.info.getReadCommunity());
                Date date = Calendar.getInstance().getTime();
                AgentMonitorMessageQueue.getInstance().pushAgentMessage("Community error : " + dateformat.format(date) + "Receive write community : " + community + " Allow write community : " + this.info.getReadCommunity());
                break;
            }
            case -93: {
                if (community.equals(this.info.getWriteCommunity())) {
                    this.setRequest(this.version, this.info.getWriteCommunity(), inPacket, receivedMessage);
                    break;
                }
                logger.warning("Receive write community : " + community + " Allow write community : " + this.info.getReadCommunity());
                Date date = Calendar.getInstance().getTime();
                AgentMonitorMessageQueue.getInstance().pushAgentMessage("Community error : " + dateformat.format(date) + "Receive write community : " + community + " Allow write community : " + this.info.getReadCommunity());
                break;
            }
            default: {
                logger.warning("Undefined command : " + this.hexByte(command));
                Date date = Calendar.getInstance().getTime();
                SimpleDateFormat dateformat = new SimpleDateFormat("HH:mm:ss");
                AgentMonitorMessageQueue.getInstance().pushAgentMessage("Undefined command : " + this.hexByte(command) + ": " + dateformat.format(date));
            }
        }
    }

    public void sendTrap(String hostAddress, String community, SnmpSequence pdu) throws GeneralSecurityException, UnknownHostException, SnmpBadValueException, IOException {
        InetAddress targetAddress = null;
        try {
            targetAddress = InetAddress.getByName(hostAddress);
        }
        catch (UnknownHostException e) {
            logger.warning(e.getMessage());
            Date date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Abort send trap to " + hostAddress + " : " + dateformat.format(date));
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        SnmpMessage message = null;
        if (!(pdu instanceof SnmpTrapPDU)) {
            throw new SnmpBadValueException("Illegal Trap pdu");
        }
        message = new SnmpMessage(this.version, community, (SnmpTrapPDU)pdu);
        byte[] messageEncoding = message.getBEREncoding();
        DatagramPacket outPacket = new DatagramPacket(messageEncoding, messageEncoding.length, targetAddress, trapPort);
        this.trapDatagramSocket.send(outPacket);
    }
}

