/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmpmanager.OidTableListener;
import netjfwatcher.snmpmanager.OidTableViewContentProvider;
import netjfwatcher.snmpmanager.OidTableViewLabelProvider;
import netjfwatcher.snmpmanager.model.ActionBuilderOidTable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class OidTableView
extends AbstractTableView {
    private static boolean isCol0Direction = false;
    private static boolean isCol1Direction = true;
    private static boolean isCol2Direction = true;
    private static boolean isCol3Direction = true;
    private static boolean isCol4Direction = true;
    private TableColumn col0;
    private TableColumn col1;
    private TableColumn col2;
    private TableColumn col3;
    private TableColumn col4;
    private static final float COLUMN0_OIDDESC = 0.15f;
    private static final float COLUMN1_OID = 0.1f;
    private static final float COLUMN2_VALUE = 0.3f;
    private static final float COLUMN3_TYPE = 0.1f;
    private static final float COLUMN4_ADDRESS = 0.1f;
    private Table table;
    private TableViewer viewer;
    private ActionBuilderOidTable actionOidTableBuilder;
    private SubStatusLineManager statusLineManager;

    private ActionBuilderOidTable getActionBuilder() {
        return this.actionOidTableBuilder;
    }

    public void setFocus() {
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new OidTableViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OidTableViewLabelProvider());
        this.actionOidTableBuilder = new ActionBuilderOidTable(this.table);
        this.createContextMenu();
        this.initActions();
    }

    private int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.15f);
    }

    private int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol2Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.3f);
    }

    private int computeCol3Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol4Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private void createTable(Composite parent) {
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        int snmpPort = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpPort();
        this.statusLineManager.setMessage("Snmp Port=" + snmpPort);
        this.table = new Table(parent, 66304);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.col0 = new TableColumn(this.table, 16384);
        this.col0.setText(OidTableViewLabelProvider.HEADER_COLUMNS[0]);
        this.col0.setWidth(this.computeCol0Width());
        this.col1 = new TableColumn(this.table, 16384);
        this.col1.setText(OidTableViewLabelProvider.HEADER_COLUMNS[1]);
        this.col1.setWidth(this.computeCol1Width());
        this.col2 = new TableColumn(this.table, 16384);
        this.col2.setText(OidTableViewLabelProvider.HEADER_COLUMNS[2]);
        this.col2.setWidth(this.computeCol2Width());
        this.col3 = new TableColumn(this.table, 16384);
        this.col3.setText(OidTableViewLabelProvider.HEADER_COLUMNS[3]);
        this.col3.setWidth(this.computeCol3Width());
        this.col4 = new TableColumn(this.table, 16384);
        this.col4.setText(OidTableViewLabelProvider.HEADER_COLUMNS[4]);
        this.col4.setWidth(this.computeCol4Width());
        this.table.addSelectionListener((SelectionListener)new OidTableListener(this.table));
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                OidTableView.this.setResizedTableColumnWidth();
            }
        });
        this.col0.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol0Direction = OidTableView.this.sortTable(OidTableView.this.table, 0, isCol0Direction);
            }
        });
        this.col1.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol1Direction = OidTableView.this.sortTable(OidTableView.this.table, 1, isCol1Direction);
            }
        });
        this.col2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol2Direction = OidTableView.this.sortTable(OidTableView.this.table, 2, isCol2Direction);
            }
        });
        this.col3.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol3Direction = OidTableView.this.sortTable(OidTableView.this.table, 3, isCol3Direction);
            }
        });
        this.col4.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol4Direction = OidTableView.this.sortTable(OidTableView.this.table, 4, isCol4Direction);
            }
        });
    }

    protected void setResizedTableColumnWidth() {
        if (this.getSite().getPage().isPartVisible(this.getSite().getPart()) && this.getSite().getShell() != null && this.getSite().getShell().getSize() != null) {
            this.col0.setWidth(this.computeCol0Width());
            this.col1.setWidth(this.computeCol1Width());
            this.col2.setWidth(this.computeCol2Width());
            this.col3.setWidth(this.computeCol3Width());
            this.col4.setWidth(this.computeCol4Width());
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.getActionBuilder().actionClearTable());
        manager.add(this.getActionBuilder().actionExportOidInstanceInfo());
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                OidTableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    private void initActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.getActionBuilder().actionClearTable());
        toolBarManager.add(this.getActionBuilder().actionExportOidInstanceInfo());
    }
}

