/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.trap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrapForwardResourceFileParse {
    private static final String XML_FILE_VALUE = "value";
    private static final String ROOT = "root";
    private static final String FORWARD_FLAG = "forward_flag";
    private static final String FORWARD_ADDRESS = "forward_address";
    private static final String FILTER_OID = "filter_oid";
    private static final String ENTERPRISE_OID = "enterprise_oid";
    private String forwardFlag;
    private String forwardAddress;
    private ArrayList<String> enterpriseOidList = new ArrayList();
    private HashMap<String, String> enterpriseOidHashMap = new HashMap();
    private static Logger logger = null;

    public TrapForwardResourceFileParse() {
        logger = Logger.getLogger(this.getClass().getName());
        this.setTrapForwardInfo();
    }

    public void setTrapForwardInfo() {
        Document doc = null;
        doc = this.getResourceFileDocumentPath("resources/trap_forward.xml");
        if (doc == null) {
            logger.severe("Resource File Doc null ");
            return;
        }
        try {
            Element root = doc.getRootElement();
            Element forwardFlagEl = root.getChild(FORWARD_FLAG);
            Element forwardAddressEl = root.getChild(FORWARD_ADDRESS);
            Element filterOidEl = root.getChild(FILTER_OID);
            this.forwardFlag = forwardFlagEl.getAttributeValue(XML_FILE_VALUE);
            this.forwardAddress = forwardAddressEl.getAttributeValue(XML_FILE_VALUE);
            this.enterpriseOidList.clear();
            this.enterpriseOidHashMap.clear();
            List enterpriseOidElList = filterOidEl.getChildren(ENTERPRISE_OID);
            for (Element enterpriseOidEl : enterpriseOidElList) {
                String enterpriseOid = enterpriseOidEl.getAttributeValue(XML_FILE_VALUE);
                this.enterpriseOidList.add(enterpriseOid);
                this.enterpriseOidHashMap.put(enterpriseOid, enterpriseOid);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public BufferedWriter getResourceFileWriter() {
        File f = new File("resources/trap_forward.xml");
        if (f == null) {
            return null;
        }
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fi = new FileWriter("resources/trap_forward.xml");
            bufferedWriter = new BufferedWriter(fi);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return bufferedWriter;
    }

    public Document getResourceFileDocumentPath(String file) {
        Document doc = null;
        File f = new File(file);
        if (f == null) {
            logger.warning("Abort create File : " + f.getAbsolutePath());
            return null;
        }
        BufferedReader d = null;
        try {
            FileReader fi = new FileReader(file);
            d = new BufferedReader(fi);
        }
        catch (FileNotFoundException e1) {
            logger.warning("FileNotFoundException : " + f.getPath() + " : " + e1.getMessage());
            logger.warning("FileNotFoundException : " + f.getAbsolutePath() + " : " + e1.getMessage());
            e1.printStackTrace();
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((Reader)d);
        }
        catch (JDOMException e) {
            logger.warning("JDOMException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.warning("NullPointerException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.warning("IOException : " + e.getMessage());
            e.printStackTrace();
        }
        return doc;
    }

    protected Document getDocument(String file) {
        URL url;
        Document doc;
        block5: {
            doc = null;
            url = null;
            Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
            url = bundle.getEntry(file);
            if (url != null) break block5;
            logger.severe("Resource XML file url : " + url);
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        }
        catch (JDOMException e) {
            logger.severe("JDOMException URL= " + url + " " + e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.severe("NullPointerException URL= " + url + " " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.severe("IOException URL= " + url + " " + e.getMessage());
            e.printStackTrace();
        }
        return doc;
    }

    public Document updateDocument(String forwardFlag, String forwardAddress, ArrayList oidList) {
        logger = Logger.getLogger(this.getClass().getName());
        Element rootElement = new Element(ROOT);
        Document doc = new Document(rootElement);
        Element forwardFlagEl = new Element(FORWARD_FLAG);
        Element forwardAddressEl = new Element(FORWARD_ADDRESS);
        Element filterOidEl = new Element(FILTER_OID);
        rootElement.addContent((Content)forwardFlagEl);
        rootElement.addContent((Content)forwardAddressEl);
        forwardFlagEl.setAttribute(new Attribute(XML_FILE_VALUE, forwardFlag));
        forwardAddressEl.setAttribute(new Attribute(XML_FILE_VALUE, forwardAddress));
        rootElement.addContent((Content)filterOidEl);
        int i = 0;
        while (i < oidList.size()) {
            Element enterpriseOidEl = new Element(ENTERPRISE_OID);
            filterOidEl.addContent((Content)enterpriseOidEl);
            if ((String)oidList.get(i) != null) {
                enterpriseOidEl.setAttribute(new Attribute(XML_FILE_VALUE, (String)oidList.get(i)));
            } else {
                enterpriseOidEl.setAttribute(new Attribute(XML_FILE_VALUE, ""));
            }
            ++i;
        }
        return doc;
    }

    public static TrapForwardResourceFileParse getInstance() {
        return SingletonResource.TRAP_FORWARD_DEFINE;
    }

    public ArrayList<String> getEnterpriseOidList() {
        return this.enterpriseOidList;
    }

    public String getForwardAddress() {
        return this.forwardAddress;
    }

    public String getForwardFlag() {
        return this.forwardFlag;
    }

    public HashMap getEnterpriseOidHashMap() {
        return this.enterpriseOidHashMap;
    }

    private static class SingletonResource {
        static final TrapForwardResourceFileParse TRAP_FORWARD_DEFINE = new TrapForwardResourceFileParse();

        private SingletonResource() {
        }
    }
}

