/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.trap;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmp.snmpv3.UsmSecuritySubsystem;
import netjfwatcher.snmp.snmpv3.UsmUserEntry;
import netjfwatcher.snmp.snmpv3.UsmUserManager;
import netjfwatcher.snmpmanager.SnmpManagerQueue;
import netjfwatcher.snmpmanager.trap.AbstractTrapMessageProcessing;
import netjfwatcher.snmpmanager.trap.ITrapListener;

public class TrapV3ReceiveMP
extends AbstractTrapMessageProcessing {
    private SnmpV3ManagerConfigInfo snmpConfigInformation = null;
    private AbstractSnmpObject msgVersion;
    private AbstractSnmpObject msgID;
    private AbstractSnmpObject msgMaxSixe;
    private AbstractSnmpObject msgFlags;
    private AbstractSnmpObject msgSecurityModel;
    private AbstractSnmpObject msgAuthoritativeEngineID;
    private AbstractSnmpObject msgAuthoritativeBoots;
    private AbstractSnmpObject msgAuthoritativeEngineTime;
    private AbstractSnmpObject msgUserName;
    private AbstractSnmpObject contextEngineID;
    private AbstractSnmpObject contextName;
    private String snmpEngineID = "";
    private int snmpEngineBoots = 0;
    private String userName = "";
    private String authPriv = "";
    private int receiveMsgFlags = 0;
    private int receiveSecurityModel = 0;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void process(String agentAddress, byte[] encodedMessage, List listenerList) throws SnmpV3ConfigurationException, GeneralSecurityException, SnmpBadValueException, SnmpV3DecryptAbortException {
        UsmUserEntry usmUserEntry = null;
        SnmpSequence request = new SnmpSequence();
        SNMPTLV nextTLV2 = request.extractNextTLV(encodedMessage, 0);
        request.setTLV(nextTLV2);
        this.msgVersion = request.getSNMPObjectAt(0);
        if (!(this.msgVersion instanceof SnmpInteger)) {
            this.logger.warning("Version is not INTEGER : " + this.msgVersion.toString());
            throw new SnmpBadValueException("Version is not INTEGER : " + this.msgVersion.toString());
        }
        this.parseHeader(request);
        SnmpSequence securityParamsSequence = this.parseSecurityParams(request);
        this.parseMsgAuthenticationParameters(securityParamsSequence);
        AbstractSnmpObject msgPrivacyParameters = this.parseMsgPrivacyParameters(securityParamsSequence);
        this.snmpEngineID = this.msgAuthoritativeEngineID.toString().substring("0x".length());
        HashMap snmpV3EngineIDList = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3ConfigEngineIDMapList();
        if (snmpV3EngineIDList != null && snmpV3EngineIDList.size() > 0) {
            this.snmpConfigInformation = (SnmpV3ManagerConfigInfo)snmpV3EngineIDList.get(this.snmpEngineID);
        }
        if (this.snmpConfigInformation != null) {
            this.logger.info("Trap agnet IP Address : " + this.snmpConfigInformation.getIpAddress());
            this.logger.info("User Name : " + ((SnmpV3ManagerUserConfigInfo)this.snmpConfigInformation.getUserList().get(0)).getUsername());
        } else {
            this.detectNoRegisterAgent(agentAddress);
        }
        this.userName = ((SnmpV3ManagerUserConfigInfo)this.snmpConfigInformation.getUserList().get(0)).getUsername();
        if (!this.userName.equals(this.msgUserName.toString())) {
            this.logger.warning("Not found UserName : " + this.msgUserName);
        }
        this.authPriv = ((SnmpV3ManagerUserConfigInfo)this.snmpConfigInformation.getUserList().get(0)).getAuthPriv();
        this.logger.info("authPriv : " + this.authPriv);
        this.logger.info("msgFlags : " + this.msgFlags);
        this.logger.info("msgSecurityModel : " + this.msgSecurityModel);
        try {
            this.receiveMsgFlags = Integer.parseInt(this.msgFlags.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.warning("Illegal msgFlags : " + this.receiveMsgFlags);
        }
        this.receiveMsgFlags &= 3;
        if (this.authPriv.equals("NOAUTH")) {
            if (this.receiveMsgFlags != 0) {
                this.logger.warning("Unmuch msgFlags : " + this.receiveMsgFlags);
            }
        } else if (this.authPriv.equals("AUTH")) {
            if (this.receiveMsgFlags != 1) {
                this.logger.warning("Unmuch msgFlags : " + this.receiveMsgFlags);
            }
        } else if (this.authPriv.equals("PRIV") && this.receiveMsgFlags != 3) {
            this.logger.warning("Unmuch msgFlags : " + this.receiveMsgFlags);
        }
        try {
            this.receiveSecurityModel = Integer.parseInt(this.msgSecurityModel.toString());
            if (this.receiveSecurityModel != 3) {
                this.logger.warning("Unmuch msgSecurityModel : " + this.receiveSecurityModel);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.warning("Illegal msgSecurityModel : " + this.receiveSecurityModel);
            throw new SnmpBadValueException("Illegal msgSecurityModel : " + this.receiveSecurityModel);
        }
        if ((this.receiveMsgFlags & 1) == 1) {
            usmUserEntry = this.checkAuth(request, securityParamsSequence);
        }
        SnmpSequence scopedPDUData = null;
        this.snmpEngineBoots = Integer.parseInt(this.msgAuthoritativeBoots.toString());
        if (request.getSNMPObjectAt(3) instanceof SnmpOctetString) {
            if ((this.receiveMsgFlags & 2) == 2) {
                scopedPDUData = this.decryptScopedPDU(request, usmUserEntry, msgPrivacyParameters);
            } else {
                this.logger.warning("Receive scopedPDU Data format error");
            }
        } else {
            scopedPDUData = (SnmpSequence)request.getSNMPObjectAt(3);
        }
        if (scopedPDUData == null) {
            this.logger.warning("Receive ScopedPDU Data nul");
            return;
        }
        this.parseScopedPDUData(scopedPDUData, listenerList);
    }

    private void detectNoRegisterAgent(String agentAddress) throws SnmpV3ConfigurationException {
        this.snmpConfigInformation = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(agentAddress);
        if (this.snmpConfigInformation == null && agentAddress.equals("localhost")) {
            this.snmpConfigInformation = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo("127.0.0.1");
        }
        if (this.snmpConfigInformation == null) {
            this.logger.warning("Not found Agent address : " + agentAddress);
            throw new SnmpV3ConfigurationException("Not found Snmp V3 agent address : " + agentAddress);
        }
        this.snmpConfigInformation.setSnmpEngineID(this.snmpEngineID);
        this.logger.warning("No discovery agent register : " + agentAddress);
        SnmpEngineID registerSnmpEngineID = new SnmpEngineID(this.snmpEngineID);
        this.logger.info("SnmpEngineID : " + this.snmpEngineID);
        try {
            UsmUserManager.getInstance().registList(registerSnmpEngineID, this.snmpConfigInformation);
        }
        catch (SnmpV3ConfigurationException e1) {
            this.logger.warning(e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }
        try {
            MessageDigest.getInstance("MD5");
            MessageDigest.getInstance("SHA-1");
            Mac.getInstance("HmacMD5");
            Mac.getInstance("HmacSHA1");
            Cipher.getInstance("DES");
            SecretKeyFactory.getInstance("DES");
        }
        catch (Throwable e) {
            throw new SnmpV3ConfigurationException(e.toString());
        }
    }

    private UsmUserEntry checkAuth(SnmpSequence request, SnmpSequence securityParamsSequence) throws GeneralSecurityException {
        boolean isCheckAuth = false;
        UsmUserEntry usmUserEntry = UsmUserManager.getInstance().getUsmUserEntry(new SnmpEngineID(this.snmpEngineID), this.userName);
        this.logger.info("SNMP V3 Trap receive SnmpEngineID : " + this.snmpEngineID);
        this.logger.info("SNMP V3 Trap receive UserName : " + this.userName);
        if (usmUserEntry == null) {
            this.logger.warning("SNMP V3 Trap receive not user entry");
            this.logger.warning("SNMP V3 Trap receive  snmpEngineID : " + this.snmpEngineID);
            this.logger.warning("NMP V3 Trap receive userName : " + this.userName);
        } else {
            this.logger.info("usmUserEntry.usmUserSecurityName : " + usmUserEntry.getUsmUserSecurityName());
            this.logger.info("usmUserEntry.usmUserName : " + usmUserEntry.getUsmUserName());
            try {
                isCheckAuth = UsmSecuritySubsystem.getInstance().checkAuth(request, securityParamsSequence, usmUserEntry.getUsmUserAuthKey());
            }
            catch (GeneralSecurityException e4) {
                this.logger.warning(e4.getMessage());
                e4.printStackTrace();
                throw e4;
            }
        }
        if (isCheckAuth) {
            this.logger.info("isCheckAuth true : " + isCheckAuth);
        } else {
            this.logger.warning("Auth check error");
            this.logger.warning("SNMP V3 Trap receive  snmpEngineID : " + this.snmpEngineID);
            this.logger.warning("NMP V3 Trap receive userName : " + this.userName);
        }
        return usmUserEntry;
    }

    private void parseHeader(SnmpSequence request) {
        SnmpSequence header = (SnmpSequence)request.getSNMPObjectAt(1);
        this.msgID = header.getSNMPObjectAt(0);
        this.msgMaxSixe = header.getSNMPObjectAt(1);
        this.msgFlags = header.getSNMPObjectAt(2);
        this.msgSecurityModel = header.getSNMPObjectAt(3);
        this.logger.info("msgVersion : " + this.msgVersion.getValue());
        this.logger.info("msgID : " + this.msgID.getValue());
        this.logger.info("msgMaxSixe : " + this.msgMaxSixe.getValue());
        this.logger.info("msgFlags : " + this.msgFlags);
        this.logger.info("msgSecurityModel : " + this.msgSecurityModel.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("msgVersion : " + this.msgVersion.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("msgID : " + this.msgID.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("msgMaxSixe : " + this.msgMaxSixe.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("msgFlags : " + this.msgFlags);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("msgSecurityModel : " + this.msgSecurityModel.getValue());
    }

    private SnmpSequence parseSecurityParams(SnmpSequence request) throws SnmpBadValueException {
        SnmpOctetString securityParaOctet = (SnmpOctetString)request.getSNMPObjectAt(2);
        SnmpSequence securityPara = null;
        securityPara = new SnmpSequence((byte[])securityParaOctet.getValue());
        SnmpSequence securityParamsSequence = (SnmpSequence)securityPara.getSNMPObjectAt(0);
        this.msgAuthoritativeEngineID = securityParamsSequence.getSNMPObjectAt(0);
        this.msgAuthoritativeBoots = securityParamsSequence.getSNMPObjectAt(1);
        this.msgAuthoritativeEngineTime = securityParamsSequence.getSNMPObjectAt(2);
        this.msgUserName = securityParamsSequence.getSNMPObjectAt(3);
        this.logger.info("msgAuthoritativeEngineID : " + this.msgAuthoritativeEngineID);
        this.logger.info("msgAuthoritativeBoots : " + this.msgAuthoritativeBoots.getValue());
        this.logger.info("msgAuthoritativeEngineTime : " + this.msgAuthoritativeEngineTime.getValue());
        System.out.println("msgUserName : " + this.msgUserName);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("msgAuthoritativeEngineID : " + this.msgAuthoritativeEngineID);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("msgAuthoritativeBoots : " + this.msgAuthoritativeBoots.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("msgAuthoritativeEngineTime : " + this.msgAuthoritativeEngineTime.getValue());
        return securityParamsSequence;
    }

    private AbstractSnmpObject parseMsgAuthenticationParameters(SnmpSequence securityParamsSequence) {
        AbstractSnmpObject msgAuthenticationParameters = securityParamsSequence.getSNMPObjectAt(4);
        try {
            byte[] msgAuthenticationParametersCode = (byte[])msgAuthenticationParameters.getValue();
            this.logger.info("msgAuthenticationParameters : " + this.hexBytetoString(msgAuthenticationParametersCode, msgAuthenticationParametersCode.length));
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue("msgAuthenticationParameters : length = " + msgAuthenticationParametersCode.length);
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(this.hexBytetoString(msgAuthenticationParametersCode, msgAuthenticationParametersCode.length));
        }
        catch (Exception e) {
            this.logger.warning("Logging/Monitor abort : " + e.getMessage());
        }
        return msgAuthenticationParameters;
    }

    private AbstractSnmpObject parseMsgPrivacyParameters(SnmpSequence securityParamsSequence) {
        AbstractSnmpObject msgPrivacyParameters = securityParamsSequence.getSNMPObjectAt(5);
        try {
            this.logger.info("msgPrivacyParameters : " + this.hexBytetoString((byte[])msgPrivacyParameters.getValue(), ((byte[])msgPrivacyParameters.getValue()).length));
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue("msgPrivacyParameters : length = " + ((byte[])msgPrivacyParameters.getValue()).length);
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue(this.hexBytetoString((byte[])msgPrivacyParameters.getValue(), ((byte[])msgPrivacyParameters.getValue()).length));
        }
        catch (Exception e) {
            this.logger.warning("Logging/Monitor abort : " + e.getMessage());
        }
        return msgPrivacyParameters;
    }

    private SnmpSequence decryptScopedPDU(SnmpSequence request, UsmUserEntry usmUserEntry, AbstractSnmpObject msgPrivacyParameters) throws SnmpV3DecryptAbortException, GeneralSecurityException {
        SnmpSequence scopedPDUData = null;
        SnmpOctetString scopedPDUOctet = (SnmpOctetString)request.getSNMPObjectAt(3);
        try {
            System.out.println("usmUserEntry.usmUserSecurityName : " + usmUserEntry.getUsmUserSecurityName());
            System.out.println("usmUserEntry.usmUserName : " + usmUserEntry.getUsmUserName());
            System.out.println("usmUserEntry.usmUserPrivProtocol : " + usmUserEntry.getUsmUserPrivProtocol());
            System.out.println("usmUserEntry.usmUserPrivKey.getAlgorithm : " + usmUserEntry.getUsmUserPrivKey().getAlgorithm());
            SnmpSequence scopedPDUDataWork = UsmSecuritySubsystem.getInstance().decrypt((byte[])scopedPDUOctet.getValue(), (byte[])msgPrivacyParameters.getValue(), usmUserEntry.getUsmUserPrivKey());
            if (scopedPDUDataWork == null) {
                this.logger.warning("Abort decrypt scopedPDU of trap receive");
                throw new SnmpV3DecryptAbortException("Abort decrypt scopedPDU of trap receive");
            }
            scopedPDUData = (SnmpSequence)scopedPDUDataWork.getSNMPObjectAt(0);
        }
        catch (GeneralSecurityException e4) {
            this.logger.warning(e4.getMessage());
            e4.printStackTrace();
            throw e4;
        }
        return scopedPDUData;
    }

    private void parseScopedPDUData(SnmpSequence scopedPDUData, List listenerList) throws SnmpBadValueException {
        this.logger.info("Scoped PDU Data : length = " + scopedPDUData.getBEREncoding().length);
        this.logger.info(this.hexBytetoString(scopedPDUData.getBEREncoding(), scopedPDUData.getBEREncoding().length));
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Scoped PDU Data : length = " + scopedPDUData.getBEREncoding().length);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(this.hexBytetoString(scopedPDUData.getBEREncoding(), scopedPDUData.getBEREncoding().length));
        this.contextEngineID = scopedPDUData.getSNMPObjectAt(0);
        this.contextName = scopedPDUData.getSNMPObjectAt(1);
        AbstractSnmpObject pduData = scopedPDUData.getSNMPObjectAt(2);
        this.logger.info("contextName : " + this.contextName);
        this.logger.info("contextEngineID : " + this.contextEngineID);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("contextName : " + this.contextName);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("contextEngineID : " + this.contextEngineID);
        SnmpTrap2PDU trap2PDU = this.parseSNMPTrap2PDU(pduData);
        int i = 0;
        while (i < listenerList.size()) {
            ITrapListener listener = (ITrapListener)listenerList.get(i);
            listener.processTrapV2(trap2PDU, "SNMPV3", this.snmpConfigInformation.getIpAddress());
            ++i;
        }
    }
}

