/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.socketclient;

import java.util.List;
import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.view.editorpart.alarm.EditorAllNodeAlarm;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.socketclient.ConnectionEngineThread;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;
import netjfwatcher.socketclient.XMLSocketAlarmReceiveMessageQueue;
import netjfwatcher.socketclient.XMLSocketConnectThread;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class XMLSocketConnectTimerProcessor
implements Runnable {
    public static final int TIMER = 1000;
    public static final int TIMER_STOP = -1;
    private TreeViewer engineListTreeViewer;
    private IWorkbenchPartSite engineListViewSite;
    private org.eclipse.swt.widgets.List detinationEngineAddressList;
    private org.eclipse.swt.widgets.List messageList;
    private Display display;
    private IEditorSite editorSite;
    private static int alamCount = 0;

    public void run() {
        if (this.editorSite.getPage().isPartVisible(this.editorSite.getPart())) {
            this.detinationEngineAddressList.removeAll();
            List engineConnectList = XMLSocketConnectThread.getInstance().getEngineConnectList();
            int i = 0;
            while (i < engineConnectList.size()) {
                this.detinationEngineAddressList.add((String)engineConnectList.get(i));
                ++i;
            }
            AlarmCodeInformation alarminfo = (AlarmCodeInformation)XMLSocketAlarmReceiveMessageQueue.getInstance().popXMLAlarmData();
            if (alarminfo != null) {
                String alarmMessage = String.valueOf(Integer.toString(++alamCount)) + "  Engine=" + alarminfo.getEngineAddress() + "  Node=" + alarminfo.getIpaddress() + "  :  " + alarminfo.getMessage();
                this.messageList.add(alarmMessage, 0);
            }
        }
        if (XMLSocketConnectThread.getInstance().isAccess()) {
            List connectThreadList = XMLSocketConnectThread.getInstance().getConnectThreadList();
            int j = 0;
            while (j < connectThreadList.size()) {
                ConnectionEngineThread connectEngine = (ConnectionEngineThread)connectThreadList.get(j);
                if (connectEngine.isAlarm()) {
                    connectEngine.setAlarm(false);
                    this.setAlarmView(connectEngine.getEngineAddress());
                }
                ++j;
            }
        }
        if (this.engineListTreeViewer != null && this.engineListViewSite.getPage().isPartVisible(this.engineListViewSite.getPart())) {
            this.engineListTreeViewer.refresh();
        }
        this.display.timerExec(1000, (Runnable)this);
    }

    private void setAlarmView(String engineAddress) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        if (workbench.getActiveWorkbenchWindow() == null) {
            return;
        }
        ClientEngineInfo.getClientEngineInfoInstance().setEngineAddress(engineAddress);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            activePage.openEditor((IEditorInput)new EditorInputNodeView(" All Alarm View" + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), null, true, true), EditorAllNodeAlarm.class.getName());
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void setEditorSite(IEditorSite editorSite) {
        this.editorSite = editorSite;
    }

    public void setList(org.eclipse.swt.widgets.List detinationEngineAddressList, org.eclipse.swt.widgets.List messageList) {
        this.detinationEngineAddressList = detinationEngineAddressList;
        this.messageList = messageList;
    }

    public static XMLSocketConnectTimerProcessor getInstance() {
        return SingletonResource.RESOURCE;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.display.timerExec(-1, (Runnable)this);
    }

    public void setEngineListTreeViewer(IWorkbenchPartSite engineListViewSite, TreeViewer engineListTreeViewer) {
        this.engineListViewSite = engineListViewSite;
        this.engineListTreeViewer = engineListTreeViewer;
    }

    private static class SingletonResource {
        static final XMLSocketConnectTimerProcessor RESOURCE = new XMLSocketConnectTimerProcessor();

        private SingletonResource() {
        }
    }
}

