/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;

public class LogicalConnection
implements java.sql.Connection {
    private Connection physicalConnection_ = null;
    private ClientPooledConnection pooledConnection_ = null;

    public LogicalConnection(Connection connection, ClientPooledConnection clientPooledConnection) throws SqlException {
        this.physicalConnection_ = connection;
        this.pooledConnection_ = clientPooledConnection;
        this.checkForNullPhysicalConnection();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public synchronized void nullPhysicalConnection() {
        this.physicalConnection_ = null;
    }

    public synchronized void close() throws SqlException {
        if (this.physicalConnection_ == null) {
            return;
        }
        if (this.physicalConnection_.agent_.loggingEnabled()) {
            this.physicalConnection_.agent_.logWriter_.traceEntry(this, "close");
        }
        if (this.physicalConnection_.isClosed()) {
            this.pooledConnection_.trashConnection(new SqlException(null, "Connection is stale."));
        } else {
            this.physicalConnection_.closeForReuse();
            if (!this.physicalConnection_.isGlobalPending_()) {
                this.pooledConnection_.recycleConnection();
            }
        }
        this.physicalConnection_ = null;
        this.pooledConnection_.nullLogicalConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeWithoutRecyclingToPool() throws SqlException {
        if (this.physicalConnection_ == null) {
            return;
        }
        this.physicalConnection_.checkForTransactionInProgress();
        try {
            if (this.physicalConnection_.isClosed()) {
                throw new SqlException(null, "Connection is stale.");
            }
        }
        finally {
            this.physicalConnection_.closeForReuse();
            this.physicalConnection_ = null;
        }
    }

    public boolean isClosed() throws SqlException {
        if (this.physicalConnection_ == null) {
            return true;
        }
        return this.physicalConnection_.isClosed();
    }

    private void checkForNullPhysicalConnection() throws SqlException {
        if (this.physicalConnection_ == null) {
            throw new SqlException(null, " Attempt to use a closed connection. ");
        }
    }

    public synchronized Statement createStatement() throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.createStatement();
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.prepareStatement(string);
    }

    public synchronized PreparedStatement preparePositionedUpdateStatement(String string, Section section) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.preparePositionedUpdateStatement(string, section);
    }

    public synchronized CallableStatement prepareCall(String string) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.prepareCall(string);
    }

    public String nativeSQL(String string) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.nativeSQL(string);
    }

    public synchronized void setAutoCommit(boolean bl) throws SqlException {
        this.checkForNullPhysicalConnection();
        this.physicalConnection_.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.getAutoCommit();
    }

    public synchronized void commit() throws SqlException {
        this.checkForNullPhysicalConnection();
        this.physicalConnection_.commit();
    }

    public synchronized void rollback() throws SqlException {
        this.checkForNullPhysicalConnection();
        this.physicalConnection_.rollback();
    }

    public synchronized void setTransactionIsolation(int n) throws SqlException {
        this.checkForNullPhysicalConnection();
        this.physicalConnection_.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.getWarnings();
    }

    public synchronized void clearWarnings() throws SqlException {
        this.checkForNullPhysicalConnection();
        this.physicalConnection_.clearWarnings();
    }

    public DatabaseMetaData getMetaData() throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.getMetaData();
    }

    public synchronized void setReadOnly(boolean bl) throws SqlException {
        this.checkForNullPhysicalConnection();
        this.physicalConnection_.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.isReadOnly();
    }

    public synchronized void setCatalog(String string) throws SqlException {
        this.checkForNullPhysicalConnection();
        this.physicalConnection_.setCatalog(string);
    }

    public String getCatalog() throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.getCatalog();
    }

    public synchronized Statement createStatement(int n, int n2) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.createStatement(n, n2);
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.prepareStatement(string, n, n2);
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.prepareCall(string, n, n2);
    }

    public Map getTypeMap() throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.getTypeMap();
    }

    public synchronized void setTypeMap(Map map) throws SqlException {
        this.checkForNullPhysicalConnection();
        this.physicalConnection_.setTypeMap(map);
    }

    public Statement createStatement(int n, int n2, int n3) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.createStatement(n, n2, n3);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.prepareCall(string, n, n2, n3);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.prepareStatement(string, n, n2, n3);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.prepareStatement(string, n);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int[] nArray) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.prepareStatement(string, nArray);
    }

    public java.sql.PreparedStatement prepareStatement(String string, String[] stringArray) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.prepareStatement(string, stringArray);
    }

    public void setHoldability(int n) throws SqlException {
        this.checkForNullPhysicalConnection();
        this.physicalConnection_.setHoldability(n);
    }

    public int getHoldability() throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.getHoldability();
    }

    public Savepoint setSavepoint() throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SqlException {
        this.checkForNullPhysicalConnection();
        return this.physicalConnection_.setSavepoint(string);
    }

    public void rollback(Savepoint savepoint) throws SqlException {
        this.checkForNullPhysicalConnection();
        this.physicalConnection_.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SqlException {
        this.checkForNullPhysicalConnection();
        this.physicalConnection_.releaseSavepoint(savepoint);
    }

    public int getServerVersion() {
        if (this.physicalConnection_ == null) {
            return -1;
        }
        return this.physicalConnection_.getServerVersion();
    }
}

