/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import org.apache.lucene.analysis.Analyzer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.DefaultAnalyzer;
import org.eclipse.help.internal.search.SmartAnalyzer;
import org.osgi.framework.Version;

public class AnalyzerDescriptor {
    private Analyzer luceneAnalyzer;
    private String id;
    private String lang;

    public AnalyzerDescriptor(String locale) {
        this.luceneAnalyzer = this.createAnalyzer(locale);
        if (this.luceneAnalyzer == null) {
            String language = null;
            if (locale.length() > 2) {
                language = locale.substring(0, 2);
                this.luceneAnalyzer = this.createAnalyzer(language);
            }
        }
        if (this.luceneAnalyzer == null) {
            this.id = "org.eclipse.help.base#" + HelpBasePlugin.getDefault().getBundle().getHeaders().get("Bundle-Version") + "?locale=" + locale;
            this.luceneAnalyzer = new DefaultAnalyzer(locale);
            this.lang = locale;
        }
    }

    public Analyzer getAnalyzer() {
        return new SmartAnalyzer(this.lang, this.luceneAnalyzer);
    }

    public String getId() {
        return this.id;
    }

    public String getLang() {
        return this.lang;
    }

    private Analyzer createAnalyzer(String locale) {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.help.base", "luceneAnalyzer");
        int i = 0;
        while (i < configElements.length) {
            String analyzerLocale;
            if (configElements[i].getName().equals("analyzer") && (analyzerLocale = configElements[i].getAttribute("locale")) != null && analyzerLocale.equals(locale)) {
                try {
                    Object analyzer = configElements[i].createExecutableExtension("class");
                    if (analyzer instanceof Analyzer) {
                        String pluginId = configElements[i].getContributor().getName();
                        String pluginVersion = (String)Platform.getBundle((String)pluginId).getHeaders().get("Bundle-Version");
                        this.luceneAnalyzer = (Analyzer)analyzer;
                        this.id = String.valueOf(pluginId) + "#" + pluginVersion + "?locale=" + locale;
                        this.lang = locale;
                        if (!"org.eclipse.help.base".equals(pluginId)) {
                            return this.luceneAnalyzer;
                        }
                    }
                }
                catch (CoreException ce) {
                    HelpBasePlugin.logError("Exception occurred creating text analyzer " + configElements[i].getAttribute("class") + " for " + locale + " locale.", ce);
                }
            }
            ++i;
        }
        return this.luceneAnalyzer;
    }

    public boolean isCompatible(String analyzerId) {
        if (this.id.startsWith(analyzerId)) {
            return true;
        }
        String prefix = "org.eclipse.help.base#";
        if (analyzerId.startsWith(prefix) && this.id.startsWith(prefix)) {
            Version aidVersion = this.getVersion(analyzerId);
            Version idVersion = this.getVersion(this.id);
            if (idVersion.getMajor() == 3 && aidVersion.getMajor() == 3 && idVersion.getMinor() >= 1 && aidVersion.getMinor() >= 1) {
                return true;
            }
        }
        return false;
    }

    private Version getVersion(String id) {
        int idStart = id.indexOf(35);
        int idStop = id.indexOf(63);
        String value = idStop == -1 ? id.substring(idStart + 1) : id.substring(idStart + 1, idStop);
        return new Version(value);
    }
}

