/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.set;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ObservableSet;

public class WritableSet
extends ObservableSet {
    static /* synthetic */ Class class$0;

    public WritableSet() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(clazz);
    }

    public WritableSet(Collection c) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(c, (Object)clazz);
    }

    public WritableSet(Collection c, Object elementType) {
        super(new HashSet(c), elementType);
        this.elementType = elementType;
    }

    public WritableSet(Object elementType) {
        super(new HashSet(), elementType);
    }

    public boolean add(Object o) {
        boolean added = this.wrappedSet.add(o);
        if (added) {
            this.fireSetChange(Diffs.createSetDiff(Collections.singleton(o), Collections.EMPTY_SET));
        }
        return added;
    }

    public boolean addAll(Collection c) {
        HashSet adds = new HashSet();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.wrappedSet.add(element)) continue;
            adds.add(element);
        }
        if (adds.size() > 0) {
            this.fireSetChange(Diffs.createSetDiff(adds, Collections.EMPTY_SET));
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        boolean removed = this.wrappedSet.remove(o);
        if (removed) {
            this.fireSetChange(Diffs.createSetDiff(Collections.EMPTY_SET, Collections.singleton(o)));
        }
        return removed;
    }

    public boolean removeAll(Collection c) {
        HashSet removes = new HashSet();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.wrappedSet.remove(element)) continue;
            removes.add(element);
        }
        if (removes.size() > 0) {
            this.fireSetChange(Diffs.createSetDiff(Collections.EMPTY_SET, removes));
            return true;
        }
        return false;
    }

    public boolean retainAll(Collection c) {
        HashSet removes = new HashSet();
        Iterator it = this.wrappedSet.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (c.contains(element)) continue;
            it.remove();
            removes.add(element);
        }
        if (removes.size() > 0) {
            this.fireSetChange(Diffs.createSetDiff(Collections.EMPTY_SET, removes));
            return true;
        }
        return false;
    }

    public void clear() {
        HashSet removes = new HashSet(this.wrappedSet);
        this.wrappedSet.clear();
        this.fireSetChange(Diffs.createSetDiff(Collections.EMPTY_SET, removes));
    }
}

