/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.application;

import netjfwatcher.engine.view.GenericResourceView;
import netjfwatcher.snmpagent.AgentCommunicationMonitorView;
import netjfwatcher.snmpagent.AgentDataEditorView;
import netjfwatcher.snmpagent.AgentInstanceControlOperationView;
import netjfwatcher.snmpagent.AgentOperationView;
import netjfwatcher.snmpagent.AgentTableView;
import netjfwatcher.snmpagent.AgentTrapSendView;
import netjfwatcher.snmpmanager.OidTableView;
import netjfwatcher.snmpmanager.SnmpV1OperationView;
import netjfwatcher.snmpmanager.SnmpV2OperationView;
import netjfwatcher.snmpmanager.SnmpV3OperationView;
import netjfwatcher.snmpmanager.TrapReceiveTableView;

import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;


/**
 * Eclipse RCP AvP[VNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetJFWatcherApplication implements IPlatformRunnable {
    /**
     * GW\[XViewԂ܂B
     *
     * @return GW\[XView
     */
    public static GenericResourceView getGenericResourceView() {
        GenericResourceView view =
            (GenericResourceView) PlatformUI.getWorkbench()
                                            .getActiveWorkbenchWindow()
                                            .getActivePage().findView(
                GenericResourceView.class.getName());

        return view;
    }

    /**
     * SNMP AgentCX^Xf[^ҏWViewԂ܂B
     *
     * @return SNMP AgentCX^Xf[^ҏWView
     */
    public static AgentDataEditorView getAgentDataEditorView() {
        AgentDataEditorView view =
            (AgentDataEditorView) PlatformUI.getWorkbench()
                                            .getActiveWorkbenchWindow()
                                            .getActivePage().findView(
                AgentDataEditorView.class.getName());

        return view;
    }

    /**
     * SNMP AgentViewԂ܂B
     *
     * @return SNMP AgentView
     */
    public static AgentOperationView getAgentOperationView() {
        AgentOperationView view =
            (AgentOperationView) PlatformUI.getWorkbench()
                                           .getActiveWorkbenchWindow()
                                           .getActivePage().findView(
                AgentOperationView.class.getName());

        return view;
    }

    /**
     * SNMP Agent TrapMViewԂ܂B
     *
     * @return SNMP Agent TrapMView
     */
    public static AgentTrapSendView getAgentTrapSendView() {
        AgentTrapSendView view =
            (AgentTrapSendView) PlatformUI.getWorkbench()
                                          .getActiveWorkbenchWindow()
                                          .getActivePage().findView(
                AgentTrapSendView.class.getName());

        return view;
    }

    /**
     * SNMP AgentCX^Xf[^ViewԂ܂B
     *
     * @return SNMP AgentCX^Xf[^View
     */
    public static AgentInstanceControlOperationView getAgentInstanceControlOperationView() {
        AgentInstanceControlOperationView view =
            (AgentInstanceControlOperationView) PlatformUI.getWorkbench()
                                                          .getActiveWorkbenchWindow()
                                                          .getActivePage()
                                                          .findView(
                AgentInstanceControlOperationView.class.getName());

        return view;
    }

    /**
     * SNMp AgentʐMj^[ViewԂ܂B
     *
     *
     * @return SNMP AgentʐMj^[View
     */
    public static AgentCommunicationMonitorView getAgentCommunicationMonitorView() {
        AgentCommunicationMonitorView view =
            (AgentCommunicationMonitorView) PlatformUI.getWorkbench()
                                                      .getActiveWorkbenchWindow()
                                                      .getActivePage().findView(
                AgentCommunicationMonitorView.class.getName());

        return view;
    }

    /**
     * SNMP AgentCX^Xf[^e[uViewԂ܂B
     *
     *
     * @return SNMP AgentCX^Xf[^e[uView
     */
    public static AgentTableView getAgentTableView() {
        AgentTableView view =
            (AgentTableView) PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                                       .getActivePage().findView(
                AgentTableView.class.getName());

        return view;
    }

    /**
     * SNMP manager TrapMe[uViewԂ܂B
     *
     * @return SNMP manager TrapMe[uView
     */
    public static TrapReceiveTableView getTrapTableView() {
        TrapReceiveTableView view =
            (TrapReceiveTableView) PlatformUI.getWorkbench()
                                             .getActiveWorkbenchWindow()
                                             .getActivePage().findView(
                TrapReceiveTableView.class.getName());

        return view;
    }

    /**
     * SNMP ManagerMAgenf[^e[u\ViewԂ܂B
     *
     * @return SNMP ManagerMAgenf[^e[u\View
     */
    public static OidTableView getOidTableView() {
        OidTableView view =
            (OidTableView) PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                                     .getActivePage().findView(
                OidTableView.class.getName());

        return view;
    }

    /**
     * SNMP Manager V1ViewԂ܂B
     *
     * @return SNMP Manager V1View
     */
    public static SnmpV1OperationView getSnmpV1OperationView() {
        SnmpV1OperationView view = null;

        view =
            (SnmpV1OperationView) PlatformUI.getWorkbench()
                                            .getActiveWorkbenchWindow()
                                            .getActivePage().findView(
                SnmpV1OperationView.class.getName());

        return view;
    }

    /**
     * SNMP Manager V2ViewԂ܂B
     *
     * @return SNMP Manager V2View
     */
    public static SnmpV2OperationView getSnmpV2OperationView() {
        SnmpV2OperationView view =
            (SnmpV2OperationView) PlatformUI.getWorkbench()
                                            .getActiveWorkbenchWindow()
                                            .getActivePage().findView(
                SnmpV2OperationView.class.getName());

        return view;
    }

    /**
     * SNMP Manager V3ViewԂ܂B
     *
     * @return SNMP Manager V3View
     */
    public static SnmpV3OperationView getSnmpV3OperationView() {
        SnmpV3OperationView view =
            (SnmpV3OperationView) PlatformUI.getWorkbench()
                                            .getActiveWorkbenchWindow()
                                            .getActivePage().findView(
                SnmpV3OperationView.class.getName());

        return view;
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.core.runtime.IPlatformRunnable#run(java.lang.Object)
     */
    public Object run(Object args) throws Exception {
        WorkbenchAdvisor workbenchAdvisor = new NetJFWatcherAdvisor();
        Display display = PlatformUI.createDisplay();

        try {
            int returnCode =
                PlatformUI.createAndRunWorkbench(display, workbenchAdvisor);

            if (returnCode == PlatformUI.RETURN_RESTART) {
                return IPlatformRunnable.EXIT_RESTART;
            }

            return IPlatformRunnable.EXIT_OK;
        } finally {
            if (display != null) {
                display.dispose();
            }
        }
    }
}
