/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.application.help;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.ui.UpdateManagerUI;


/**
 * Action to invoke the Update install wizard.
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 * @since 1.0
 */
public class InstallWizardAction extends Action
    implements IWorkbenchWindowActionDelegate {
    /*
     * IWorkbenchWindow
     */
    private IWorkbenchWindow window;

    /**
     * WizardAction
     */
    public InstallWizardAction() {
        // do nothing
    }

    /*
     *  ( Javadoc)
     * @see org.eclipse.jface.action.IAction#run()
     */
    public void run() {
        openInstaller(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    /*
     *  ( Javadoc)
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        openInstaller(window);
    }

    /*
     * UpdateManagerUĨCXg[I[v܂B
     *
     */
    private void openInstaller(final IWorkbenchWindow window) {
        BusyIndicator.showWhile(
            window.getShell().getDisplay(),
            new Runnable() {
                public void run() {
                    UpdateManagerUI.openInstaller(window.getShell());
                }
            });
    }

    /*
     *  ( Javadoc)
     * @see org.eclipse.ui.
     * IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     * org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
        // do nothing
    }

    /*
     *  ( Javadoc)
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
     */
    public void dispose() {
        // do nothing
    }

    /*
     *  ( Javadoc)
     * @see org.eclipse.ui.
     * IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
     */
    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}
