/*
 * Created on 2005/04/14
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.common.view;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.webbrowser.preferences.HttpAccessPreference;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;



/**
 * m[hTreeł̃\bhyуo[NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeTree extends AbstractNodeTreeNode {
    /*
     * serialVersionUID
     */
    private static final long serialVersionUID = 1L;
    /* m[hTree */
    private String nodeName;

    /* m[hTreẽACRImage */
    private Image image;

    /* m[hĎ */
    private NodeInformation nodeInfo;

    /* OID */
    private String oid;

    /**
     * m[hTreẽm[h𐶐܂B
     *
     */
    public NodeTree() {
    }

    /**
     * m[hTreẽm[h𐶐܂B
     *
     * @param nodeName m[h
     * @param nodeInfo m[hĎ
     * @param image m[hIcon Image
     */
    public NodeTree(String nodeName, NodeInformation nodeInfo, Image image) {
        this.nodeName = nodeName;
        this.nodeInfo = nodeInfo;
        this.image = image;
    }

    /**
     * qm[hԂ܂B
     *
     * @return qm[h
     */
    public INodeTreeNode[] getChildren() {
        return null;
    }

    /**
     * m[hIcon ImageԂ܂B
     *
     * @return image m[hIocn Image
     */
    public Image getImage() {
        // Display display = Display.getCurrent();
        // Image imageParent = new Image(display, "icons/trap.gif");
        // return PlatformUI.getWorkbench().getSharedImages().
        // getImage(ISharedImages.IMG_OBJ_FILE);
        return image;
    }

    /**
     * m[hԂ܂B
     *
     * @return nodeName m[h
     */
    public String getName() {
        return nodeName;
    }

    /**
     * m[hANZXURLԂ܂B
     *
     * @return nodeUrl m[hURLANZX
     * @throws HttpAccessPreferenceException vtFX[hɎsꍇ
     */
    public String getUrl()  throws HttpAccessPreferenceException {
        Shell shell = new Shell();

        /* URLANZXZbg */
        String paraIpAddress = "?ipaddress=" + nodeInfo.getIpaddress();
        String paraEngineAddress =
            "&engineAddress=" + nodeInfo.getEngineAddress();
        String nodeUrl =
            HttpAccessPreference.getInstance().getNodeViewUrl() + paraIpAddress
            + paraEngineAddress;

        if (
            (HttpAccessPreference.getInstance().getNodeViewUrl() == null)
                || HttpAccessPreference.getInstance().getNodeViewUrl().equals(
                    "") || (nodeInfo.getIpaddress() == null)
                || nodeInfo.getIpaddress().equals("")
                || nodeInfo.getIpaddress().equals("null")
                || (nodeInfo.getEngineAddress() == null)
                || nodeInfo.getEngineAddress().equals("")
                || nodeInfo.getEngineAddress().equals("null")) {
            MessageDialog.openError(
                shell, "Error", "Node View URL error \n" + nodeUrl);
        }

        shell.dispose();

        return nodeUrl;
    }

    /**
     * qm[h݂邩Ԃ܂B
     *
     * @return qm[h݂邩
     */
    public boolean hasChildren() {
        return false;
    }

    /**
     * m[hĎԂ܂B
     *
     * @return nodeInfo m[hĎ
     */
    public NodeInformation getNodeInfo() {
        return nodeInfo;
    }

    /**
     * OIDZbg܂B
     *
     * @param oid OID
     */
    public void setOid(String oid) {
        this.oid = oid;
    }

    /**
     * OIDԂ܂B
     *
     * @return oid OID
     */
    public String getOid() {
        return oid;
    }
}
