/*
 * Created on 2005/04/14
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.common.view;

import org.eclipse.swt.graphics.Image;

import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

import java.util.HashSet;
import java.util.Set;


/**
 * m[hTreeɂm[hO[vƂȂTreem[hNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeTreeGroup extends AbstractNodeTreeNode {
    /*
     * serialVersionUID
     */
    private static final long serialVersionUID = 1L;

    /*
     * m[hTree groupɏm[hTreẽm[hi[HashSet
     */
    private Set<INodeTreeNode> childrenHashSet = new HashSet<INodeTreeNode>();

    /**
     * m[hTreeɂm[hO[vƂȂTreem[hNX
     * CX^X𐶐܂B
     *
     */
    public NodeTreeGroup() {
    }

    /**
     * m[hTreeɂm[hO[vƂȂTreem[hNX
     * CX^XO[vw肵Đ܂B
     *
     * @param name m[hO[v
     */
    public NodeTreeGroup(String name) {
        setName(name);
    }

    /**
     * m[hTree groupɏm[hTreẽm[hzŕԂ܂B
     *
     * @return INodeTreeNode[]
     */
    public INodeTreeNode[] getChildren() {
        return (INodeTreeNode[]) childrenHashSet.toArray(
            new INodeTreeNode[childrenHashSet.size()]);
    }

    /**
     * m[hTree groupIconC[WԂ܂B
     *
     * @return m[hTree groupIconC[W
     */
    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage(
            ISharedImages.IMG_OBJ_FOLDER);
    }

    /**
     * m[hTree groupɃm[hTreẽm[ho^܂B
     *
     * @param toAdd o^m[hTreẽm[h
     */
    public void addChild(INodeTreeNode toAdd) {
        childrenHashSet.add(toAdd);
        toAdd.setParent(this);
    }

    /**
     * Childem[h݂邩Ԃ܂B
     *
     * @return Childem[hݗL
     */
    public boolean hasChildren() {
        return !childrenHashSet.isEmpty();
    }

    /**
     * m[hTree groupɏw̃m[hTreẽm[h
     * 폜܂B
     *
     * @param toRemove 폜m[hTreẽm[h
     */
    public void removeChild(INodeTreeNode toRemove) {
        childrenHashSet.remove(toRemove);
    }

    /**
     * SĂChildem[h폜܂B
     *
     */
    public void removeChildAll() {
        childrenHashSet.clear();
    }
}
