/*
 * Created on 2004/04/27
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.control;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.engine.model.action.DatabaseControl;



/**
 * f[^x[XRlNVv[ɕێAǗNXłB
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DatabaseConnectionPool {
    /* Database Connection */
    private static final int MAXCONNECTION = 10;

    /* Database Coonection擾łȂꍇWiat time(micro sec) */
    private static final int WAIT_TIME = 100;

    /* Logging */
    private static Logger logger = null;

    /*
     * f[^x[XRlNVi[v[
     *
     */
    private final List<Connection> connectionsListPool =
        Collections.synchronizedList(new LinkedList<Connection>());

    /* JDBC Drivaer */
    private String jdbcdriver;

    /* Database URL */
    private String url;

    /* Database user name */
    private String username;

    /* Database password */
    private String password;

    /**
     * f[^x[XRlNVPoolɊi[܂B
     *
     */
    private DatabaseConnectionPool() {
        logger = Logger.getLogger(this.getClass().getName());

        // logger.info("Database connection pool create");
        createConnectionPool();
    }

    /**
     * f[^x[XRlNVPool𐶐܂B
     *
     */
    public void createConnectionPool() {
        /* if (connectionsListPool.size() == MAXCONNECTION) {
            return;
        } */
        connectionsListPool.clear();

        AbstractDataAccessObject dataaccessObject =
            DatabaseAccessControlKind.getInstance().getDataAccessObject();

        // f[^x[X̎ʂɑΉANZXlݒ
        jdbcdriver = dataaccessObject.getDriver();
        url = dataaccessObject.getUrl();
        username = dataaccessObject.getUser();
        password = dataaccessObject.getPassword();
        /*
        logger.info("jdbcdriver : " + jdbcdriver);
        logger.info("url : " + url);
        logger.info("username : " + username);
        logger.info("password : " + password);
        */

        // f[^x[X̐ڑiRlNVj𐶐APoolɊi[
        try {
            // JDBC Driver ̓o^
            Class.forName(jdbcdriver).newInstance();

            for (int i = 0; i < MAXCONNECTION; i++) {
                // f[^x[Xւ̃RlNV𐶐āAPoolɊi[
                Connection con =
                    DriverManager.getConnection(url, username, password);
                connectionsListPool.add(con);
            }
        } catch (InstantiationException e) {
            e.printStackTrace();
            logger.severe(
                "InstantiationException " + e.getMessage() + " url=" + url
                + " username=" + username + " password=" + password);

            // throw e;
        } catch (IllegalAccessException e) {
            e.printStackTrace();
            logger.severe(
                "IllegalAccessException " + e.getMessage() + " url=" + url
                + " username=" + username + " password=" + password);

            // throw e;
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
            logger.severe(
                "ClassNotFoundException " + e.getMessage() + " url=" + url
                + " username=" + username + " password=" + password);

            // throw e;
        } catch (SQLException e) {
            e.printStackTrace();
            logger.severe(
                "SQLException " + e.getMessage() + " url=" + url + " username="
                + username + " password=" + password);

            // throw e;
        } catch (Exception e) {
            e.printStackTrace();
            logger.severe(
                "Exception " + e.getMessage() + " url=" + url + " username="
                + username + " password=" + password);
        }
    }

    /**
     * RlNV擾܂B
     * 擾łȂꍇ͈ŗ^ꂽ񐔂100msɃgC܂B
     * ł擾łȂꍇɂnullԂ܂B
     *
     * @param count c̎s
     * @return conn f[^x[XConnection
     * @throws DatabaseConnectionException f[^x[XConnectionȂꍇ
     */
    public synchronized Connection getConnection(final int count)
        throws DatabaseConnectionException {
        // logger.info("getConnection : size=" + connectionsListPool.size());
        if (count < 1) {
            logger.warning(
                "Database connection pool is nothing. " + "jdbcdriver="
                + jdbcdriver + " url=" + url + " username=" + username
                + " password=" + password);

            return null;
        }

        // Connection pool size > 0
        if (connectionsListPool.size() > 0) {
            Connection conn = (Connection) connectionsListPool.get(0);
            connectionsListPool.remove(0);

            return conn;
        }

        // ConnectionȂꍇɂWaitāAēxAConnection擾݂
        try {
            if (!DatabaseControl.getInstance().isDatabaseStart()) {
                logger.warning(
                    "Inactive Database : "
                    + DatabaseAccessControlKind.getInstance().getDatabaseName());
                throw new DatabaseConnectionException(
                    "Inactive Database : "
                    + DatabaseAccessControlKind.getInstance().getDatabaseName());
            }

            logger.info("Database connection wait");
            wait(WAIT_TIME);
        } catch (InterruptedException e) {
            logger.warning(e.getMessage());
            throw new DatabaseConnectionException(e.getMessage());
        }

        // ċACall
        return getConnection(count - 1);
    }

    /**
     * RlNVԋp܂B
     *
     * @param conn ԋpRlNV
     */
    public synchronized void releaseConnection(final Connection conn) {
        connectionsListPool.add(conn);

        /*
         * logger.info("releaseConnection : size="
         * + connectionsListPool.size());
         */
    }

    /**
     * f[^x[XRlNVN[Y܂B
     *
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        for (int i = 0; i < connectionsListPool.size(); i++) {
            Connection conn = (Connection) connectionsListPool.get(i);
            conn.close();
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static DatabaseConnectionPool getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final DatabaseConnectionPool DBPOOL =
            new DatabaseConnectionPool();
    }
}
