/*
 * Created on 2004/06/06
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseConnectionException;



/**
 * f[^x[XANZX{NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DBTableBase {
    /** m[hIPAhXe[uHeader */
    public static final String IP = "IP";

    /* MO */
    private static Logger logger;

    /**
     *
     *
     */
    public DBTableBase() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * w̃V[PXe[u폜܂B
     *
     * @param databaseAccess f[^x[XANZXCX^X
     * @param tableSequence V[PXe[u
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     */
    public void dropSequence(
        final DatabaseAccess databaseAccess, final String tableSequence)
        throws DatabaseConnectionException {
        if (
            DatabaseAccessControlKind.getInstance().getDatabaseName().equals(
                    AbstractDataAccessObject.POSTGRESQL)) {
            try {
                databaseAccess.executeUpdate(tableSequence);
            } catch (SQLException e) {
                logger.info(
                    DatabaseAccessControlKind.getInstance().getDatabaseName()
                    + " : " + e.getMessage());
            }
        }
    }

    /**
     * w̃e[u폜܂B
     *
     * @param databaseAccess f[^x[XANZXCX^X
     * @param deleteTableName 폜e[u
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void deleteTable(
        final DatabaseAccess databaseAccess, final String deleteTableName)
        throws DatabaseConnectionException, SQLException {
        if (
            DatabaseAccessControlKind.getInstance().getDatabaseName().equals(
                    AbstractDataAccessObject.POSTGRESQL)) {
            try {
                databaseAccess.executeUpdate("DROP TABLE " + deleteTableName);
            } catch (SQLException e) {
                /* PostgreSQL̏ꍇŃe[u݂Ȃꍇ */
                logger.info(
                    DatabaseAccessControlKind.getInstance().getDatabaseName()
                    + " : " + e.getMessage());
            }
        } else if (
            DatabaseAccessControlKind.getInstance().getDatabaseName().equals(
                    AbstractDataAccessObject.DERBY)
                || DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                .equals(
                    AbstractDataAccessObject.EMBEDDED_DERBY)) {
            try {
                databaseAccess.executeUpdate("DROP TABLE " + deleteTableName);
            } catch (SQLException e) {
                /* Apache Derby̏ꍇŃe[u݂Ȃꍇ */
                logger.info(
                    DatabaseAccessControlKind.getInstance().getDatabaseName()
                    + " : " + e.getMessage());
            }
        } else {
            databaseAccess.executeUpdate(
                "DROP TABLE IF EXISTS " + deleteTableName);
        }
    }
}
