/*
 * Created on 2006/12/28
 *
 *
 *@Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.engine.socket.info.PrintMibInfo;



public final class DBTablePrintMIB extends DBTableBase {

    public static final String SNMP_PRINT_TABLE_NAME = "_print";

    public static final String HR_DEVICE_INDEX = "hrDeciceIndex";

    public static final String HR_DEVICE_TYPE = "hrDeviceType";

    public static final String HR_DEVICE_DESC = "hrDeviceDescr";

    public static final String HR_DEVICE_ID = "hrDeviceID";

    public static final String HR_DEVICE_STATUS = "hrDeviceStatus";

    public static final String HR_DEVICE_ERRORS = "hrDeviceErrors";

    public static final String HR_PRINTER_STATUS = "hrPrinterStatus";

    public static final String HR_PRINTER_DETECTED_ERROR_STATE = "hrPrinterDetectedErrorState";


    public static final String HR_CURDATE = "curdate";

    /* MIBi[e[ũJʒu */
    private static final int COLUMN_HR_DEVICE_INDEX_NO = 0;
    private static final int COLUMN_HR_DEVICE_TYPE_NO = 1;
    private static final int COLUMN_HR_DEVICE_DESC_NO = 2;
    private static final int COLUMN_HR_DEVICE_ID_NO = 3;
    private static final int COLUMN_HR_DEVICE_STATUS_NO = 4;
    private static final int COLUMN_HR_DEVICE_ERRORS_NO = 5;
    private static final int COLUMN_HR_PRINTER_STATUS_NO = 6;
    private static final int COLUMN_HR_PRINTER_DETECTED_ERROR_STATE_NO = 7;

    /* MO */
    private static Logger logger = null;


    /*
     * PrintPrintMIBe[uɃJǉ邽߂
     * SQL
     */
    private static final String SNMP_PRINT_TABLE_ITEM =
        " (" + HR_DEVICE_INDEX + " " + AbstractDataAccessObject.BIGINT + " , "
        + HR_DEVICE_TYPE + " VARCHAR(255), " + HR_DEVICE_DESC + "  VARCHAR(255)," + HR_DEVICE_ID
        + " VARCHAR(255)," + HR_DEVICE_STATUS + " VARCHAR(10)," + HR_DEVICE_ERRORS
        + " VARCHAR(10)," + HR_PRINTER_STATUS + " VARCHAR(10)," + HR_PRINTER_DETECTED_ERROR_STATE
        + " VARCHAR(10) ," + HR_CURDATE + " " + AbstractDataAccessObject.TIMESTAMP + " )";


    private final DateFormat simpleDateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * PrintMIBe[u𑀍삷VOgNX
     * CX^X𐶐܂B
     *
     */
    private DBTablePrintMIB() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMP PrintMIB e[u𐶐܂B
     *
     * @param targetIpAddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void createTable(final String targetIpAddress)
        throws DatabaseConnectionException, SQLException {

        String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            this.deleteTable(databaseAccess, ipaddress + SNMP_PRINT_TABLE_NAME);

            // f[^x[XEe[u쐬
            databaseAccess.executeUpdate(
                "CREATE TABLE " + ipaddress + SNMP_PRINT_TABLE_NAME
                + SNMP_PRINT_TABLE_ITEM);


            DBTableManagement tableManagement = new DBTableManagement();
            tableManagement.put(
                targetIpAddress, ipaddress + SNMP_PRINT_TABLE_NAME,
                DBTableManagement.LIMIT_NO);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * SNMP Print MIB e[u폜
     *
     * @param targetIpAddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void dropTable(final String targetIpAddress)
        throws DatabaseConnectionException, SQLException {
        // IPAhXe[uɕϊ
        String ipaddress = DBTableBase.IP + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            this.deleteTable(databaseAccess, ipaddress + SNMP_PRINT_TABLE_NAME);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * wm[hIP AddressPrint MIB񃊃XgԂ܂B
     *
     * @param tragetIpAddress m[hIPAhX
     * @return nodeIfList Interface MIB񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized ArrayList findSNMPPrint(
        final String tragetIpAddress)
        throws SQLException, DatabaseConnectionException {
        String convipaddress =
            DBTableBase.IP + tragetIpAddress.replace('.', '_');
        convipaddress = convipaddress.replace('-', '_');

        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        ArrayList<PrintMibInfo> nodeSNMPPrintList = new ArrayList<PrintMibInfo>();

        try {
            //sql̍쐬
            String sql =
                "SELECT * from " + convipaddress + SNMP_PRINT_TABLE_NAME
                + " order by " + HR_DEVICE_INDEX + " asc";

            // SQLXe[ggIuWFNg̍쐬
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            while (rs.next()) {
            	PrintMibInfo nodePrintMib = new PrintMibInfo();
                nodePrintMib.setHrDeciceIndex(rs.getObject(HR_DEVICE_INDEX).toString());
                nodePrintMib.setHrDeviceType(rs.getObject(HR_DEVICE_TYPE).toString());
                nodePrintMib.setHrDeviceDescr(rs.getObject(HR_DEVICE_DESC).toString());
                nodePrintMib.setHrDeviceID(rs.getObject(HR_DEVICE_ID).toString());
                nodePrintMib.setHrDeviceStatus(
                    rs.getObject(HR_DEVICE_STATUS).toString());
                nodePrintMib.setHrDeviceErrors(
                        rs.getObject(HR_DEVICE_ERRORS).toString());
                nodePrintMib.setHrPrinterStatus(
                    rs.getObject(HR_PRINTER_STATUS).toString());
                nodePrintMib.setHrPrinterDetectedErrorState(
                        rs.getObject(HR_PRINTER_DETECTED_ERROR_STATE).toString());





                nodeSNMPPrintList.add(nodePrintMib);
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }
        }

        return nodeSNMPPrintList;
    }

    /**
     * Print MIBCfbNXɃf[^x[XɊi[܂B
     *
     * @param tragetIpAddress IPAhX
     * @param interfacesList PrintMIBi[Xgzň
     * ziXgjOIDɑΉAXgɂ̓CfbNX̒li[
     * Ă
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾
     * oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void putSNMPPrint(
        final String tragetIpAddress, final ArrayList[] interfacesList)
        throws DatabaseConnectionException, SQLException {
        String ipaddressTableName =
            DBTableBase.IP + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');

        Date date = Calendar.getInstance().getTime();

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        String sql = "";
        try {

            // CfbNXɃf[^x[XɊi[
            for (int i = 0; i < interfacesList[COLUMN_HR_DEVICE_INDEX_NO].size();
                    i++) {
            	                            
                if (
                    DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                 .equals(
                            AbstractDataAccessObject.DERBY)
                        || DatabaseAccessControlKind.getInstance()
                                                        .getDatabaseName()
                                                        .equals(
                            AbstractDataAccessObject.EMBEDDED_DERBY)) {
                	sql = "insert into " + ipaddressTableName
                    + SNMP_PRINT_TABLE_NAME + "( " + HR_DEVICE_INDEX + ", " + HR_DEVICE_TYPE
                    + ", " + HR_DEVICE_DESC + ", " + HR_DEVICE_ID + ", " + HR_DEVICE_STATUS
                    + ", " + HR_DEVICE_ERRORS + ", " + HR_PRINTER_STATUS + ", "+ HR_PRINTER_DETECTED_ERROR_STATE + ", "
                    + HR_CURDATE + " )"
                    + " VALUES( "
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_INDEX_NO].get(i)))
                    .getMibValue() + "," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_TYPE_NO].get(i)))
                    .getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_DESC_NO].get(i)))
                    .getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_ID_NO].get(i)))
                    .getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_STATUS_NO].get(i)))
                    .getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_ERRORS_NO]
                    .get(i))).getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_PRINTER_STATUS_NO]
                    .get(i))).getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_PRINTER_DETECTED_ERROR_STATE_NO]
                    .get(i))).getMibValue() + "'," + "'"
                    + simpleDateformat.format(date) + "'" + ")";
                    databaseAccess.executeUpdate(sql);
                } else {
                	sql = "insert into " + ipaddressTableName
                    + SNMP_PRINT_TABLE_NAME + "( " + HR_DEVICE_INDEX + ", " + HR_DEVICE_TYPE
                    + ", " + HR_DEVICE_DESC + ", " + HR_DEVICE_ID + ", " + HR_DEVICE_STATUS
                    + ", " + HR_DEVICE_ERRORS + ", " + HR_PRINTER_STATUS + ", " + HR_PRINTER_DETECTED_ERROR_STATE + ", "
                    +  HR_CURDATE + " )"
                    + " VALUES( " + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_INDEX_NO].get(i)))
                    .getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_TYPE_NO].get(i)))
                    .getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_DESC_NO].get(i)))
                    .getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_ID_NO].get(i)))
                    .getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_STATUS_NO].get(i)))
                    .getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_DEVICE_ERRORS_NO]
                    .get(i))).getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_PRINTER_STATUS_NO]
                    .get(i))).getMibValue() + "'," + "'"
                    + ((MibValue) (interfacesList[COLUMN_HR_PRINTER_DETECTED_ERROR_STATE_NO]
                    .get(i))).getMibValue() + "'," + "'"
                    + simpleDateformat.format(date) + "'" + ")";
                    databaseAccess.executeUpdate(sql);
                }

                // databaseAccess.executeUpdate(AbstractDataAccessObject.COMMIT);
            }
        } catch (SQLException ex) {
            logger.warning(ex.getMessage() + " IP=" + tragetIpAddress + " SQL=" + sql);
            throw ex;
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage() + " IP=" + tragetIpAddress + " SQL=" + sql);
            throw e;
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * Print MIBXV܂B
     * Print MIB񂪕ωꍇɂ́AA[ʒm܂B
     *
     * @param tragetIpAddress IPAhX
     * @param interfacesArrayList Listz̈OIDɑΉAz񖈂
     * IndexɑΉPrintMIB񂪓
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void updateSNMPPrint(
        final String tragetIpAddress, final ArrayList[] interfacesArrayList)
        throws DatabaseConnectionException, SQLException {
        /*
         * PrintMIBωĎ
         */
        checkPrintMib(tragetIpAddress, interfacesArrayList);

        String ipaddressTablename =
            DBTableBase.IP + tragetIpAddress.replace('.', '_');
        ipaddressTablename = ipaddressTablename.replace('-', '_');

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {

            updatePrintTabel(
                databaseAccess, interfacesArrayList, ipaddressTablename);
        } catch (SQLException ex) {
            logger.warning(ex.getMessage() + " IP=" + tragetIpAddress);
            ex.printStackTrace();
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
            e.printStackTrace();
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * Print MIB̕ωĎ܂B
     * Print MIB񂪕ωꍇɂ́AA[ʒm܂B
     *
     * @param tragetIpAddress m[hIPAhX
     * @param interfacesArrayList PrintMIBi[Xg
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    private void checkPrintMib(
        final String tragetIpAddress, final ArrayList[] interfacesArrayList)
        throws DatabaseConnectionException, SQLException {
        /*
         * f[^x[XɊi[ĂIndexPrintMIB擾
         * ÃG[WFg̎擾Ƃ̕ω`FbN
         */
        ArrayList preOidList = this.findSNMPPrint(tragetIpAddress);

        /*
         * VIndexrPrintύXĎ
         */
        if (interfacesArrayList[COLUMN_HR_DEVICE_INDEX_NO].size() != preOidList.size()) {
            /* Indexωꍇɂ̓A[ʒm */
            String message =
                "(" + preOidList.size() + "-->"
                + interfacesArrayList[COLUMN_HR_DEVICE_INDEX_NO].size() + ")";
            setAlaram(
                tragetIpAddress, message, interfacesArrayList, preOidList);

            logger.info(
                "interfacesList[COLUMN_HR_DEVICE_INDEX_NO].size() : "
                + interfacesArrayList[COLUMN_HR_DEVICE_INDEX_NO].size());
            logger.info("preOidList.size() : " + preOidList.size());


            for (int i = 0; i < interfacesArrayList.length; i++) {
                ArrayList ifList = interfacesArrayList[i];

                for (int j = 0; j < ifList.size(); j++) {
                    logger.info(
                        "now i=" + i + " j=" + j + " value="
                        + (String) ifList.get(j));
                }
            }

            /*
             * Printe[ȗSĂPrintf[^
             * 폜āAēxPrintf[^e[uɑ}
             */
            this.deleteIfIndex(tragetIpAddress, preOidList);
            this.putSNMPPrint(tragetIpAddress, interfacesArrayList);

            return;
        }

        for (
            int oidCount = 0;
                oidCount < interfacesArrayList[COLUMN_HR_DEVICE_INDEX_NO].size();
                oidCount++) {
            String hrDeciceIndex =
                ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_INDEX_NO].get(
                    oidCount))).getMibValue();

            String hrDeviceType =
                ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_TYPE_NO].get(
                    oidCount))).getMibValue();

            String hrDeviceDescr =
                ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_DESC_NO].get(
                    oidCount))).getMibValue();



            /* VifIndexv܂Ō */
            boolean isFoundIfIndex = false;
            PrintMibInfo printMibInfo = null;

            for (int j = 0; j < preOidList.size(); j++) {
                printMibInfo = (PrintMibInfo) preOidList.get(j);

                String hrDeciceIndexOld = printMibInfo.getHrDeciceIndex();

                if (hrDeciceIndexOld.equals(hrDeciceIndex)) {
                    isFoundIfIndex = true;

                    break;
                }
            }

            /* ifIndexȂ(VifIndexvȂ)ꍇPrintύX */
            if (!isFoundIfIndex) {
                logger.warning(
                    "Not Found hrDeciceIndex " + printMibInfo.getHrDeciceIndex());
                logger.warning(
                    "(Detect new hrDeciceIndex=" + hrDeciceIndex + " hrDeviceDescr=" + hrDeviceDescr
                    + "(" + hrDeviceDescr + "))");

                String message =
                    "(Detect new hrDeciceIndex=" + hrDeciceIndex + " hrDeviceDescr=" + hrDeviceDescr
                    + "(" + hrDeviceDescr + "))";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);

                /* Printe[ȗSĂPrint
                 * f[^폜āAēxPrintf[^
                 * e[uɑ}
                 */
                this.deleteIfIndex(tragetIpAddress, preOidList);
                this.putSNMPPrint(tragetIpAddress, interfacesArrayList);

                return;
            }

            String hrDeviceDescrOld = printMibInfo.getHrDeviceDescr();

            if (!hrDeviceDescrOld.equals(hrDeviceDescr)) {
                if (!checkInterfaceMIBDataString(hrDeviceDescr, hrDeviceDescrOld)) {
                    logger.warning(
                        "Old hrDeviceDescr=" + hrDeviceDescrOld + " New hrDeviceDescr=" + hrDeviceDescr);

                    String message =
                        "(hrDeciceIndex=" + hrDeciceIndex + " " +hrDeviceDescr
                        + " hrDeviceDescr : " + hrDeviceDescrOld + "-->" + hrDeviceDescr + ")";
                    setAlaram(
                        tragetIpAddress, message, interfacesArrayList,
                        preOidList);
                }
            }

            String hrDeviceTypeOld = printMibInfo.getHrDeviceType();

            if (!hrDeviceTypeOld.equals(hrDeviceType)) {
                logger.warning(
                    "Old hrDeviceType=" + hrDeviceTypeOld + " New hrDeviceType=" + hrDeviceType);

                String message =
                    "(ifIndex=" + hrDeciceIndex + " " + hrDeviceDescr + " hrDeviceType : "
                    + hrDeviceTypeOld + "-->" + hrDeviceType + ")";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);
            }

            String hrDeviceIDOld = printMibInfo.getHrDeviceID();
            String hrDeviceID =
                ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_ID_NO].get(oidCount)))
                .getMibValue();

            if (!hrDeviceIDOld.equals(hrDeviceID)) {
                logger.warning("Old hrDeviceStatus=" + hrDeviceIDOld + " New hrDeviceStatus=" + hrDeviceID);

                String message =
                    "(hrDeciceIndex=" + hrDeciceIndex + " " +hrDeviceDescr + " hrDeviceDescr : "
                    + hrDeviceIDOld + "-->" + hrDeviceID + ")";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);
            }

            String hrDeviceStatusOld = printMibInfo.getHrDeviceStatus();
            String hrDeviceStatus =
                ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_STATUS_NO].get(
                    oidCount))).getMibValue();

            if (!hrDeviceStatusOld.equals(hrDeviceStatus)) {
                logger.warning(
                    "Old hrDeviceStatus=" + hrDeviceStatusOld + " New hrDeviceStatus=" + hrDeviceStatus);

                String message =
                    "(hrDeciceIndex=" + hrDeciceIndex + " " + hrDeviceDescr
                    + " hrDeviceStatus : " + hrDeviceStatusOld + "-->" + hrDeviceStatus + ")";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);
            }

            String hrDeviceErrorsOld = printMibInfo.getHrDeviceErrors();
            String hrDeviceErrors =
                ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_ERRORS_NO].get(
                    oidCount))).getMibValue();

            if (!hrDeviceErrorsOld.equals(hrDeviceErrors)) {
                logger.info(
                    "Old hrDeviceErrors=" + hrDeviceErrorsOld
                    + " New hrDeviceErrors=" + hrDeviceErrors);

                String message =
                    "(hrDeciceIndex=" + hrDeciceIndex + " " + hrDeviceDescr
                    + " hrDeviceErrors : " + hrDeviceErrorsOld + "-->"
                    + hrDeviceErrors + ")";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);
            }


            String hrPrinterStatusOld = printMibInfo.getHrPrinterStatus();
            String hrPrinterStatus =
                ((MibValue) (interfacesArrayList[COLUMN_HR_PRINTER_STATUS_NO].get(
                    oidCount))).getMibValue();
            
            
            
            String hrPrinterDetectedErrorStateOld = printMibInfo.getHrPrinterDetectedErrorState();
            String hrPrinterDetectedErrorState =
                ((MibValue) (interfacesArrayList[COLUMN_HR_PRINTER_DETECTED_ERROR_STATE_NO].get(
                    oidCount))).getMibValue();

            if (
                !hrPrinterStatusOld.equals(hrPrinterStatus)
                    || !hrPrinterDetectedErrorStateOld.equals(hrPrinterDetectedErrorState)) {

                logger.info(
                    "(hrDeciceIndex=" + hrDeciceIndex + " " + hrDeviceDescr + " "
                    + " (hrPrinterStatus : "
                    + hrPrinterStatusOld + "-->" + hrPrinterStatus
                    + " , hrPrinterDetectedErrorState : " + hrPrinterDetectedErrorStateOld + "-->"
                    + hrPrinterDetectedErrorState + "))");

                String message =
                    "(hrDeciceIndex=" + hrDeciceIndex + " " + hrDeviceDescr + " "
                    + " (hrPrinterStatus : "
                    + hrPrinterStatusOld + "-->" + hrPrinterStatus
                    + " , hrPrinterDetectedErrorState : " + hrPrinterDetectedErrorStateOld + "-->"
                    + hrPrinterDetectedErrorState + "))";
                setAlaram(
                    tragetIpAddress, message, interfacesArrayList, preOidList);
            }
        }
    }

    /*
     * PrintMIB̕ωoꍇɌĂ΂A[Zbg܂B
     *
     * @param targetIpAddress@m[hIPAhX
     * @param message A[bZ[W
     */
    private void setAlaram(
        String targetIpAddress, String message,
        final ArrayList[] interfacesArrayList, ArrayList preOidList) {
        AlarmMessageMake alarm = AlarmMessageMake.getInstance();
        alarm.setCahngePrintStatus(targetIpAddress, message);

        /*
         * PrintMIBω̍̎f[^O
         */
        /* for (
            int oidCount = 0;
                oidCount < interfacesArrayList[COLUMN_IFINDEX_NO].size();
                oidCount++) {
            String ifIndex =
                ((MibValue) (interfacesArrayList[COLUMN_IFINDEX_NO].get(
                    oidCount))).getMibValue();

            String ifType =
                ((MibValue) (interfacesArrayList[COLUMN_IFTYPE_NO].get(
                    oidCount))).getMibValue();

            String ifDesc =
                ((MibValue) (interfacesArrayList[COLUMN_IFDESC_NO].get(
                    oidCount))).getMibValue();

            String ifTypeName = ifTypeMibDisplay.getIfTypeString(ifType);

            String interfaceDescription =
                "(" + ifTypeName + " : " + ifDesc + ")";
            String ifMtu =
                ((MibValue) (interfacesArrayList[COLUMN_IFMTU_NO].get(oidCount)))
                .getMibValue();
            String ifSpeed =
                ((MibValue) (interfacesArrayList[COLUMN_IFSPEED_NO].get(
                    oidCount))).getMibValue();
            String ifPhysAddress =
                ((MibValue) (interfacesArrayList[COLUMN_IFPHYSADDRESS_NO].get(
                    oidCount))).getMibValue();

            String ifAdminStatus =
                ((MibValue) (interfacesArrayList[COLUMN_IFADMINSTATUS_NO].get(
                    oidCount))).getMibValue();

            String ifOperStatus =
                ((MibValue) (interfacesArrayList[COLUMN_IFOPERSTATUS_NO].get(
                    oidCount))).getMibValue();

            logger.info("ifIndex       " + oidCount + " : " + ifIndex);
            logger.info("ifType        " + oidCount + " : " + ifType);
            logger.info("ifDesc        " + oidCount + " : " + ifDesc);
            logger.info("ifTypeName    " + oidCount + " : " + ifTypeName);
            logger.info(
                "interfaceDescription  " + oidCount + " : "
                + interfaceDescription);
            logger.info("ifMtu         " + oidCount + " : " + ifMtu);
            logger.info("ifSpeed       " + oidCount + " : " + ifSpeed);
            logger.info("ifPhysAddress " + oidCount + " : " + ifPhysAddress);
            logger.info("ifAdminStatus " + oidCount + " : " + ifAdminStatus);
            logger.info("ifOperStatus  " + oidCount + " : " + ifOperStatus);
        }
        */
        /* InterfaceMib interfaceMibInfo = null;

        for (int j = 0; j < preOidList.size(); j++) {
            interfaceMibInfo = (InterfaceMib) preOidList.get(j);

            String ifIndexOld = interfaceMibInfo.getIfIndex();
            String ifDescOld = interfaceMibInfo.getIfDesc();
            String ifTypeOld = interfaceMibInfo.getIfType();
            String ifMtuOld = interfaceMibInfo.getIfMtu();
            String ifSpeedOld = interfaceMibInfo.getIfSpeed();
            String ifPhysAddressOld = interfaceMibInfo.getIfPhysAddress();
            String ifAdminStatusOld = interfaceMibInfo.getIfAdminStatus();
            String ifOperStatusOld = interfaceMibInfo.getIfOperStatus();

            logger.info("ifIndexOld       " + j + " : " + ifIndexOld);
            logger.info("ifDescOld        " + j + " : " + ifDescOld);
            logger.info("ifTypeOld        " + j + " : " + ifTypeOld);
            logger.info("ifIndexOld       " + j + " : " + ifIndexOld);
            logger.info("ifMtuOld         " + j + " : " + ifMtuOld);
            logger.info("ifSpeedOld       " + j + " : " + ifSpeedOld);
            logger.info("ifPhysAddressOld " + j + " : " + ifPhysAddressOld);
            logger.info("ifAdminStatusOld " + j + " : " + ifAdminStatusOld);
            logger.info("ifOperStatusOld  " + j + " : " + ifOperStatusOld);
        }
        */
    }

    /**
     * PrintMIBe[uXV܂B
     *
     * @param databaseAccess f[^x[XANZXIuWFNg
     * @param interfacesArrayList PrintMIBi[Xg
     * @param ipaddressTablename e[u
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    private void updatePrintTabel(
        DatabaseAccess databaseAccess, final ArrayList[] interfacesArrayList,
        String ipaddressTablename)
        throws DatabaseConnectionException, SQLException {
        Date date = Calendar.getInstance().getTime();

        for (int i = 0; i < interfacesArrayList[1].size(); i++) {
            if (
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                                             .equals(
                        AbstractDataAccessObject.DERBY)
                    || DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                    .equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                databaseAccess.executeUpdate(
                    "UPDATE " + ipaddressTablename + SNMP_PRINT_TABLE_NAME
                    + " set "
                    
                    + HR_DEVICE_INDEX + "= "
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_INDEX_NO].get(
                        i))).getMibValue() + ", " + HR_DEVICE_TYPE + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_TYPE_NO].get(i)))
                    .getMibValue() + "', " + HR_DEVICE_DESC + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_DESC_NO].get(i)))
                    .getMibValue() + "', " + HR_DEVICE_ID + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_ID_NO].get(i)))
                    .getMibValue() + "', " + HR_DEVICE_STATUS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_STATUS_NO].get(
                        i))).getMibValue() + "', " + HR_DEVICE_ERRORS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_ERRORS_NO]
                    .get(i))).getMibValue() + "', "
                    
                    
                    + HR_PRINTER_STATUS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_PRINTER_STATUS_NO]
                    .get(i))).getMibValue() + "', "
                    + HR_PRINTER_DETECTED_ERROR_STATE + "='"                 
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_PRINTER_DETECTED_ERROR_STATE_NO]
                    .get(i))).getMibValue() + "', "
                    + HR_CURDATE + "='"
                    + simpleDateformat.format(date) + "'" + " where "
                    + HR_DEVICE_INDEX + "= "
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_INDEX_NO].get(i))).getMibValue()
                    + " ");
            } else {
                databaseAccess.executeUpdate(
                    "UPDATE " + ipaddressTablename + SNMP_PRINT_TABLE_NAME
                    + " set " + HR_DEVICE_INDEX + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_INDEX_NO].get(
                        i))).getMibValue() + "', " + HR_DEVICE_TYPE + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_TYPE_NO].get(i)))
                    .getMibValue() + "', " + HR_DEVICE_DESC + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_DESC_NO].get(i)))
                    .getMibValue() + "', " + HR_DEVICE_ID + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_ID_NO].get(i)))
                    .getMibValue() + "', " + HR_DEVICE_STATUS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_STATUS_NO].get(
                        i))).getMibValue() + "', " + HR_DEVICE_ERRORS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_ERRORS_NO]
                    .get(i))).getMibValue() + "', "
                    + HR_PRINTER_STATUS + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_PRINTER_STATUS_NO]
                    .get(i))).getMibValue() + "', "
                    + HR_PRINTER_DETECTED_ERROR_STATE + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_PRINTER_DETECTED_ERROR_STATE_NO]
                    .get(i))).getMibValue() + "', "
                    + HR_CURDATE + "='"
                    + simpleDateformat.format(date) + "'" + " where "
                    + HR_DEVICE_INDEX + "='"
                    + ((MibValue) (interfacesArrayList[COLUMN_HR_DEVICE_INDEX_NO].get(i))).getMibValue()
                    + "';");
            }
        }
    }

    /**
     * Printe[ȗSĂIndex폜܂B
     * ́APrint܂́AIndexԍωꍇŁA
     * e[uXVoȂ̂ňUAe[u폜čēxA
     * e[u邽߂ɌĂ΂܂B
     *
     *
     * @param tragetIpAddress m[hIPAhX
     * @param preOidList O̎悵OIDCX^XXg
     * @return
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void deleteIfIndex(
        final String tragetIpAddress, final ArrayList preOidList)
        throws DatabaseConnectionException, SQLException {
        String ipaddressTableName =
            DBTableBase.IP + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // DatabaseAccess databaseAccess = new DatabaseAccess();
            for (int i = 0; i < preOidList.size(); i++) {
            	PrintMibInfo nodeview = (PrintMibInfo) preOidList.get(i);

                String ifIndex = nodeview.getHrDeciceIndex();

                String sql = "";

                //sql̍쐬
                sql = "DELETE from " + ipaddressTableName + SNMP_PRINT_TABLE_NAME
                    + " where " + HR_DEVICE_INDEX + "=" + "'" + ifIndex + "'";

                databaseAccess.executeUpdate(sql);
            }
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /*
     * f[^x[XւASCIIȊO̊i[s̏ꍇɊi[ꂽf[^
     * of[^̐擪ASCIÎݔrs܂B
     *
     * @param newDataString ̎f[^
     * @param oldDataString O̎f[^
     * @return i[sł܂ł̕riωĎj
     * true  : v
     * false : sv
     */
    private boolean checkInterfaceMIBDataString(
        final String newDataString, final String oldDataString) {
        SystemResourceFileParse resourceset =
            (SystemResourceConfig.getInstance()).getResourceFileParse();
        String databaseKind = resourceset.getResourceInfo().getDatabaseName();

        char checkCode = '?';

        if (databaseKind.equals(AbstractDataAccessObject.MYSQL)) {
            checkCode = '?';
        }

        boolean isMuch = false;

        /* i[sł܂ł̈ʒu擾 */
        int checkPos = oldDataString.indexOf(checkCode);

        if (checkPos > 0) {
            /* i[sł܂ł̕擾 */
            String checkIfDesc = oldDataString.substring(0, checkPos);

            /*
             * i[sł܂ł̕񂪁AV̎悵
             * MIBf[^Ɋ܂܂邩`FbN
             */
            int check2 = newDataString.indexOf(checkIfDesc);

            if (check2 >= 0) {
                /*
                 * i[sł܂ł̕񂪁AV̎悵
                 * MIBf[^Ɋ܂܂ꍇɂ͐Vf[^v
                 * Ɣf
                 */
                isMuch = true;
            }
        }

        return isMuch;
    }



    /**
     * VOgNXCX^XԂ܂B
     *
     * @return VOgNXCX^X
     */
    public static DBTablePrintMIB getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DBTablePrintMIB RESOURCE = new DBTablePrintMIB();
    }
}
