/*
 * Created on 2004/04/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.alarm;

import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;


/**
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DialogMessageResource {
    /** WindowN[YConfirmbZ[WID */
    public static final String EXIT = "0";

    /** MIB̎掸sAlertbZ[WID */
    public static final String MIBGETERROR = "0";

    /** MIBZbgsAlertbZ[WID */
    public static final String MIBSETERROR = "1";

    /** SNMP V3 \`G[AlertbZ[WID */
    public static final String SNMPV3CONFIGERROR = "2";

    /** T[oƂ̒ʐMQAlertbZ[WID */
    public static final String SERVERCOMERR = "3";

    /** f[^x[XɏQAlertbZ[WID */
    public static final String DBERR = "4";

    /** AvP[VɏQAlertbZ[WID */
    public static final String APPLICATIONERR = "5";

    /** \񎸔sAlertbZ[WID */
    public static final String ABORTRESERVE = "6";

    /** ҏWsAlertbZ[WID */
    public static final String ABORTEDIT = "7";

    /** ǉsAlertbZ[WID */
    public static final String ABORTADD = "8";

    /** tCgւIĂȂAlertbZ[WID */
    public static final String NOTARGET = "9";

    /** fBNg܂̓t@CɃANZXłȂꍇAlert
     * bZ[WID */
    public static final String FILE_ACCESS_DENIED = "10";

    /** eLXg͗Ƀf[^͂ĂȂꍇAlertb
     * Z[WID */
    public static final String INPUT_DATA_NULL = "11";

    /** f[^x[XғĂȂꍇAlertbZ[WID */
    public static final String DATABASE_NULL = "12";

    /** CSVt@C̉͂ɎsꍇAlertbZ[WID */
    public static final String CSVFILE_PARSE_ERR = "13";

    /** FileȂꍇAlertbZ[WID */
    public static final String FILE_NOTFOUND = "14";

    /** f[^x[X̍쐬ɎsꍇAlertbZ[WID */
    public static final String DB_CREATE_ERR = "15";

    /** t@C݂̏ɎsꍇAlertbZ[WID */
    public static final String FILE_WRITE_ERR = "16";

    /** XMLt@C̉͂ɎsꍇAlertbZ[WID */
    public static final String XMLFILE_PARSE_ERR = "17";

    /** XMLt@C̉͂ɎsꍇAlertbZ[WID */
    public static final String XML_CREATE_ERR = "18";

    /** f[^t@CIĂȂꍇAlertbZ[WID */
    public static final String DATA_FILE_NO_SELECTED = "19";

    /** RMIWXgT[o͂ĂȂꍇAlertb
     * Z[WID */
    public static final String RMI_REGISTRY_SERVER_ERR = "20";

    /** RMIWXg|[gԍ͂ĂȂꍇAlert
     * bZ[WID */
    public static final String RMI_REGISTRY_PORT_ERR = "21";

    /** RMI ڑđ҂|[gԍ͂ĂȂꍇ
     * AlertbZ[WID */
    public static final String RMI_INCOMING_PORT_ERR = "22";

    /** hLgȂꍇAlertbZ[WID */
    public static final String DOCUMENT_NOT_FOUND = "23";

    /** hLg̕\ɎsꍇAlertbZ[WID */
    public static final String DOCUMENT_OPEN_ERR = "24";

    /* Alert/Confirm_CAO bZ[Wp\[Xt@C
     * ʒu */
    private static final String MESSAGE_XML_FILE = "resources/message.xml";

    /* bZ[Wp\[XXMLt@CConfirm^O */
    private static final String CONFIRM_MESSAGE_TAG = "confirm";

    /* bZ[Wp\[XXMLt@CAlert^O */
    private static final String ALERT_MESSAGE_TAG = "alert";

    /* bZ[Wp\[XXMLt@CAlert/Confirm^Ȏ */
    private static final String MESSAGE_TAG_ATTRIBUTE = "ID";

    /* Y郁bZ[W݂ȂꍇɕԂbZ[W */
    private static final String MESSAGE_ID_NOTFOUND = "Application Error";

    /* AlertbZ[Wi[Map */
    private static HashMap alertMessageMap = new HashMap();

    /* ConfirmbZ[Wi[Map */
    private static HashMap confirmMessageMap = new HashMap();

    /* Logging */
    private static Logger logger = null;

    private DialogMessageResource() {
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNgԂ
     * ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static DialogMessageResource getInstance() {
        return SingletonMessage.MESSAGE;
    }

    /**
     * Confirm_CAOEBhEɕ\郁bZ[W
     * Ԃ܂B<BR>
     *
     * @param keyId ConfirmbZ[WID
     * @return ConfirmbZ[W
     */
    public static String getConfirmMessage(final String keyId) {
        if (confirmMessageMap.containsKey(keyId)) {
            return (String) confirmMessageMap.get(keyId);
        }

        return MESSAGE_ID_NOTFOUND;
    }

    /**
     * Alert_CAOEBhEɕ\郁bZ[W
     * Ԃ܂B<BR>
     *
     * @param keyId AlertbZ[WID
     * @return AlertbZ[W
     */
    public static String getAlertMessage(final String keyId) {
        if (alertMessageMap.containsKey(keyId)) {
            return (String) alertMessageMap.get(keyId);
        }

        return MESSAGE_ID_NOTFOUND;
    }

    /**
     * bZ[WXMLt@C͂āAbZ[WIDɑΉ
     * bZ[Wi[Map𐶐܂B<BR>
     *
     */
    public void parseMessageXMLFile() {
        Document dom = null;
        DocumentBuilderFactory dbfactory = null;
        DocumentBuilder builder = null;
        logger = Logger.getLogger(DialogMessageResource.class.getName());

        /* bZ[W\[Xt@C */
        ClassLoader loader = DialogMessageResource.class.getClassLoader();
        URL url = loader.getResource(MESSAGE_XML_FILE);

        if (url == null) {
            /* bZ[W\[Xt@CȂꍇMO̎ */
            logger.severe(
                "Alert/Confirm Dialog Window Message XML file url : " + url);
        }

        try {
            /* XMLt@ĆADOMp[Tpt@Ng̐ */
            dbfactory = DocumentBuilderFactory.newInstance();

            /* Ó؂s */
            dbfactory.setValidating(true);

            /* DOM DocumentCX^Xpt@Ng̐ */
            builder = dbfactory.newDocumentBuilder();

            /* G[nh̓o^ */
            builder.setErrorHandler(new DocumentParseErrorHandler());
            dom = builder.parse(url.openStream());
        } catch (Exception e) {
            /* ȉ̗Ocatch
             * EDocumentBuilderŗOiParserConfigurationExceptionj
             * EXMLt@C͂ō\̓G[iSAXExceptionj
             * EXMLt@C͂œo̓G[iIOExceptionj
             */
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

        /* Confirm_CAObZ[Wmapɐݒ */
        Element root = dom.getDocumentElement();
        Node firstFlightInfoNode = root.getFirstChild();
        setMessageMap(
            confirmMessageMap, firstFlightInfoNode, CONFIRM_MESSAGE_TAG,
            MESSAGE_TAG_ATTRIBUTE);

        /* Alert_CAObZ[Wmapɐݒ */
        firstFlightInfoNode = root.getFirstChild();
        setMessageMap(
            alertMessageMap, firstFlightInfoNode, ALERT_MESSAGE_TAG,
            MESSAGE_TAG_ATTRIBUTE);
    }

    /**
     * w肵^OyёɑΉlw肵MapɊi[܂B
     * <BR>
     *
     * @param messageMap olL[Ƃă^OɑΉ
     * li[Map
     * @param firstFlightInfoNode ͂m[h
     * @param tagName o^O
     * @param tagAttribute o^Ȏ
     */
    private static void setMessageMap(
        final HashMap messageMap, Node rootNode, final String tagName,
        final String tagAttribute) {
        Node targetNode = rootNode;

        while (targetNode != null) {
            if (targetNode.getNodeType() == Node.ELEMENT_NODE) {
                if (targetNode.getNodeName().equals(tagName)) {
                    break;
                }
            }

            targetNode = targetNode.getNextSibling();
        }

        if (targetNode != null) {
            Node nodeLeaf = targetNode.getFirstChild();

            while (nodeLeaf != null) {
                if (nodeLeaf.getNodeType() == Node.ELEMENT_NODE) {
                    NamedNodeMap map = nodeLeaf.getAttributes();
                    String messageId = null;

                    for (int j = 0; j < map.getLength(); j++) {
                        Node node = map.item(j);

                        if (node.getNodeName().equals(tagAttribute)) {
                            messageId = node.getNodeValue();
                        }
                    }

                    /* oIDIDɑΉ郁bZ[WMapɊi[ */
                    messageMap.put(
                        messageId, nodeLeaf.getFirstChild().getNodeValue());
                }

                nodeLeaf = nodeLeaf.getNextSibling();
            }
        }
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonMessage {
        static final DialogMessageResource MESSAGE =
            new DialogMessageResource();
    }
}
