/*
 * Created on 2004/12/16
 *
 *
 *
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.socket.CommandInfo;


/**
 * C^tF[XMIBf[^擾܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandInterfaceData extends TemplateCommandImpl {

    private static Logger logger;

    /**
     * C^tF[XMIBf[^擾܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        DBTableStatisticsMIBControl interfaceDBtable =
            DBTableStatisticsMIBControl.getInstance();
        ArrayList interfaceMibDataList = null;

        try {
            interfaceMibDataList =
                interfaceDBtable.getInterfaceDataList(
                    com.getIpaddress(), com.getInterfaceControl().getOid(),
                    com.getInterfaceControl().getMode());
        } catch (SQLException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } catch (Exception e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }

        sendResponse(interfaceMibDataList, ois, oos);
    }
}
