/*
 * Created on 2004/07/07
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.snmpmanager.process.ManagerDispatcher;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.MibGetResponse;
import netjfwatcher.engine.socket.info.MibGetResponseList;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpMappingTableController;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;


/**
 * Web̗vɂAgentMIBݒs郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandMibSet extends TemplateCommandImpl {
    /* MO */
    private static Logger logger;
    private static final int MIB_NAME_POS = 0;
    private static final int MIB_OID_POS = 1;
    private static final int MIB_VALUE_POS = 2;
    private static final int MIB_TYPE_POS = 3;
    private static final int MIB_ACCESS_POS = 4;
    private static final int MIB_ARRAY_LENGTH = 5;

    /* MIB`CX^X */
    private ManagerMibTree mibtree;

    /* |[gOID Description */
    private String reportOidDescription = "";

    /**
     * MIB̎sʂWebɕԂ܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        String mibSetResult = "OK";
        String ipaddress = com.getIpaddress();
        String community = com.getMibInfo().getRwCommunity();
        String setRequestOID = com.getMibInfo().getRequestMibOid();
        String valueString = com.getMibInfo().getOidSetValue();
        String valueTypeString = com.getMibInfo().getOidType();
        int version = com.getMibInfo().getVersion();

        logger.info("Set OID : " + setRequestOID);
        logger.info("Set Value : " + valueString);
        logger.info("value Type : " + valueTypeString);

        mibtree = ManagerMibTree.getInstance();

        /*
         * AgentSet RequestSNMP Object𐶐
         */
        AbstractSnmpObject setSnmpObjectInstance = null;

        try {
            setSnmpObjectInstance =
                createSetSnmpObject(
                    setRequestOID, valueTypeString, valueString);
        } catch (SnmpSetException e) {
            mibSetResult = e.getMessage();

            /*
             * Set Requestُ팟o
             */
            MibGetResponseList mibGetResListInstance = new MibGetResponseList();
            mibGetResListInstance.setResultCode(mibSetResult);

            MibGetResponse mibgetresponse = new MibGetResponse();
            mibGetResListInstance.listadd(mibgetresponse);
            sendResponse(mibGetResListInstance, ois, oos);

            return;
        }

        if (version == SnmpPreference.SNMPV3) {
            /*
             * SNMP V3wɂMIBZbg^[QbgSNMP V3o^
             * ꍇG[ʂʒm
             */
            if (
                SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                       .getSnmpV3AgentInfo(com.getIpaddress()) == null) {
                mibSetResult =
                    "Not found SNMP V3 Agent Address = " + com.getIpaddress();
                logger.warning(mibSetResult);

                MibGetResponseList list = new MibGetResponseList();
                list.setResultCode(mibSetResult);

                MibGetResponse mibgetresponse = new MibGetResponse();
                list.listadd(mibgetresponse);

                sendResponse(mibSetResult, ois, oos);

                return;
            }
        }

        logger.info(
            "IP=" + ipaddress + " version=" + version + " Community="
            + community);

        setrequest(
            com, ois, oos, setRequestOID, setSnmpObjectInstance, mibSetResult);
    }

    /*
     * AgentSetRequest𔭍s܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     * @param setRequestOID OID
     * @param setSnmpObjectInstance SetSNMPIuWFNg
     * @param mibSetResult SetRequestʕ
     */
    private void setrequest(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos,
        String setRequestOID, AbstractSnmpObject setSnmpObjectInstance,
        String mibSetResult) {
        String ipaddress = com.getIpaddress();
        String community = com.getMibInfo().getRwCommunity();
        int version = com.getMibInfo().getVersion();
        String[] mibPropertyArray = new String[MIB_ARRAY_LENGTH];
        ManagerDispatcher dispacher = null;

        try {
            dispacher = new ManagerDispatcher();
            dispacher.setManagerDispatcher(ipaddress, community, version);

            SnmpVarBindList newVars =
                dispacher.dispathSetMessage(
                    version, SnmpBERCodec.SNMPSETREQUEST, setRequestOID,
                    setSnmpObjectInstance);

            SnmpSequence responsePair =
                (SnmpSequence) (newVars.getSNMPObjectAt(0));
            SnmpObjectIdentifier responseOID =
                (SnmpObjectIdentifier) responsePair.getSNMPObjectAt(0);
            AbstractSnmpObject responseValue = null;
            /* OIDMIB񌟍 */
            MibInfo miboid = searchOID(responseOID);

            if (miboid == null) {
                /*
                 * MIBMIB`㌩Ȃꍇ
                 * 'nosuchname'Ԃ
                 */
                logger.warning("OID " + setRequestOID + " nosuchname.");
                mibSetResult = "OID " + setRequestOID + " nosuchname.";

                MibGetResponseList mibGetResListInstance =
                    new MibGetResponseList();
                mibGetResListInstance.setResultCode(mibSetResult);

                MibGetResponse mibgetresponse = new MibGetResponse();
                mibGetResListInstance.listadd(mibgetresponse);
                sendResponse(mibGetResListInstance, ois, oos);

                return;
            }

            if (!this.checkOID(responseOID.toString())) {
                /*
                     * |[gOIDłȂꍇ́ASet Request̐퉞
                     * MIBf[^Zbg
                     */
                responseValue = responsePair.getSNMPObjectAt(1);
                mibPropertyArray[MIB_NAME_POS] = miboid.getDescrip();
                mibPropertyArray[MIB_OID_POS] = responseOID.toString();
                mibPropertyArray[MIB_VALUE_POS] = responseValue.toString();
                mibPropertyArray[MIB_TYPE_POS] = miboid.getSyntax();
                mibPropertyArray[MIB_ACCESS_POS] = miboid.getAccess();
            } else {
                /* MIB|[gOID̏ꍇ */
                responsePair = (SnmpSequence) (newVars.getSNMPObjectAt(0));
                responseOID =
                    (SnmpObjectIdentifier) responsePair.getSNMPObjectAt(0);
                responseValue = responsePair.getSNMPObjectAt(1);
                mibPropertyArray[MIB_NAME_POS] = reportOidDescription;
                mibPropertyArray[MIB_OID_POS] = responseOID.toString();
                mibPropertyArray[MIB_VALUE_POS] = responseValue.toString();
                mibPropertyArray[MIB_TYPE_POS] = "";
                mibPropertyArray[MIB_ACCESS_POS] = "";
            }
        } catch (SnmpUnmuchRequestIDException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (SnmpUnmuchRequestMsgIDException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (GeneralSecurityException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (SnmpV3AuthAbortException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (SnmpV3DecryptAbortException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (SocketException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (SnmpConfigurationException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (SnmpV3ConfigurationException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (SnmpErrorStatusException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (SnmpMIBGetException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (SnmpSetException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            mibSetResult = e1.getMessage();
        } finally {
            dispacher.closeConnection();
        }

        /*
         * Set Requestɑ΂鉞CX^X
         */
        MibGetResponseList mibGetResListInstance = new MibGetResponseList();
        mibGetResListInstance.setResultCode(mibSetResult);

        MibGetResponse mibgetresponse = new MibGetResponse();
        mibgetresponse.setMibName(mibPropertyArray[MIB_NAME_POS]);
        mibgetresponse.setMibOid(mibPropertyArray[MIB_OID_POS]);
        mibgetresponse.setMibValue(mibPropertyArray[MIB_VALUE_POS]);
        mibgetresponse.setMibType(mibPropertyArray[MIB_TYPE_POS]);
        mibgetresponse.setMibAccess(mibPropertyArray[MIB_ACCESS_POS]);
        mibGetResListInstance.listadd(mibgetresponse);

        sendResponse(mibGetResListInstance, ois, oos);
    }

    /*
     * OIDɑΉMIBĕԂ܂B
     *
     * @param responseOID OID
     * @return miboid MIB
     */
    private MibInfo searchOID(SnmpObjectIdentifier responseOID) {
        MibInfo miboid = null;

        /* CX^XČpOID쐬 */
        int oidWorkPos = responseOID.toString().lastIndexOf(".");
        String searchOid = responseOID.toString().substring(0, oidWorkPos);

        /*
         * OIDkeyƂMIB`HashMap
         * key݂Ȃ΁Aoid̒ZčēxAkey݃`FbN
         * key݂܂oid̒ZĂ
         * key݂΂ɂHashMap MIB Nameget
         */
        for (int i = 0; i < responseOID.toString().length(); i++) {
            if (mibtree.getOidHashMap().containsKey(searchOid)) {
                /* MIB`ɑ݂OIDo */
                miboid = (MibInfo) mibtree.getOidHashMap().get(searchOid);

                break;
            }

            int checkOidPos = searchOid.lastIndexOf(".");

            if (checkOidPos >= 0) {
                searchOid = searchOid.substring(0, checkOidPos);
            } else {
                break;
            }
        }

        return miboid;
    }

    /**
     * OIDReport OID`FbN܂B
     * Report OID̏ꍇ́AtrueԂ܂B
     * Report OIDłȂꍇ́AfalseԂ܂B
     *
     * @param checkOID Report OID`FbNOID
     * @return@Report OID̏ꍇtrueAOIDłȂꍇfalse
     */
    public boolean checkOID(String checkOID) {
        // OIDReport OIDۂtO(Report OIDłȂꍇfalse)
        boolean isCheckReportOID = false;

        if (checkOID.equals(SnmpPreference.UNSUPPORTED_SECURITY_LEVEL)) {
            reportOidDescription =
                SnmpPreference.UNSUPPORTED_SECURITY_LEVEL_DESCRIPTION;
            isCheckReportOID = true;
        } else if (checkOID.equals(SnmpPreference.NOT_IN_TIME_PACKET)) {
            reportOidDescription =
                SnmpPreference.NOT_IN_TIME_PACKET_DESCRIPTION;
            isCheckReportOID = true;
        } else if (checkOID.equals(SnmpPreference.UNKNOWN_USER_NAME)) {
            reportOidDescription = SnmpPreference.UNKNOWN_USER_NAME_DESCRIPTION;
            isCheckReportOID = true;
        } else if (checkOID.equals(SnmpPreference.UNKNOWN_ENGINE_ID)) {
            reportOidDescription = SnmpPreference.UNKNOWN_ENGINE_ID_DESCRIPTION;
            isCheckReportOID = true;
        } else if (checkOID.equals(SnmpPreference.WRONG_DIGEST)) {
            reportOidDescription = SnmpPreference.WRONG_DIGEST_DESCRIPTION;
            isCheckReportOID = true;
        } else if (checkOID.equals(SnmpPreference.DECRYPTION_ERROR)) {
            reportOidDescription = SnmpPreference.DECRYPTION_ERROR_DESCRIPTION;
            isCheckReportOID = true;
        }

        return isCheckReportOID;
    }

    /*
     * AgentSet RequestSNMP Object𐶐ĕԂ܂B
     *
     * @param setRequestOID OID
     * @param createValueTypeString SnmpIuWFNgType
     * @param valueString SnmpIuWFNgf[^
     * @return setSnmpObjectInstance SnmpIuWFNg
     * @throw SNMPSetException SnmpIuWFNgɎsꍇ
     */
    private AbstractSnmpObject createSetSnmpObject(
        String setRequestOID, String createValueTypeString, String valueString)
        throws SnmpSetException {
        /* CX^XČpOID𐶐 */
        int oidWorkPos = setRequestOID.lastIndexOf(".");
        String searchOid = setRequestOID.substring(0, oidWorkPos);

        /*
         * oidkeyƂHashMap
         * key݂Ȃ΁Aoid̒ZčēxAkey݃`FbN
         * key݂܂oid̒ZĂ
         * key݂΂ɂHashMap MIB Nameget
         *
         */
        MibInfo miboid = null;

        for (int i = 0; i < setRequestOID.length(); i++) {
            if (mibtree.getOidHashMap().containsKey(searchOid)) {
                miboid = (MibInfo) mibtree.getOidHashMap().get(searchOid);

                break;
            }

            int checkOidPos = searchOid.lastIndexOf(".");

            if (checkOidPos >= 0) {
                searchOid = searchOid.substring(0, checkOidPos);
            } else {
                break;
            }
        }

        String valueTypeString = null;

        if (miboid != null) {
            /*  */
            if (createValueTypeString.equals("Auto")) {
                String oidType = miboid.getSyntax();

                if (oidType.equals(ManagerMibTree.INTEGER)) {
                    valueTypeString = SnmpBERCodec.SNMPINTEGER;
                } else if (oidType.equals(ManagerMibTree.COUNTER32)) {
                    valueTypeString = SnmpBERCodec.SNMPCOUNTER32;
                } else if (oidType.equals(ManagerMibTree.COUNTER64)) {
                    valueTypeString = SnmpBERCodec.SNMPCOUNTER64;
                } else if (oidType.equals(ManagerMibTree.GAUGE32)) {
                    valueTypeString = SnmpBERCodec.SNMPGAUGE32;
                } else if (oidType.equals(ManagerMibTree.OCTETSTRING)) {
                    valueTypeString = SnmpBERCodec.SNMPOCTETSTRING;
                } else if (oidType.equals(ManagerMibTree.IPADDRESS)) {
                    valueTypeString = SnmpBERCodec.SNMPIPADDRESS;
                } else if (oidType.equals(ManagerMibTree.OBJECTID)) {
                    valueTypeString = SnmpBERCodec.SNMPOBJECTIDENTIFIER;
                } else if (oidType.equals(ManagerMibTree.TIMETICKS)) {
                    valueTypeString = SnmpBERCodec.SNMPTIMETICKS;
                } else if (oidType.equals(ManagerMibTree.UINTEGER32)) {
                    valueTypeString = SnmpBERCodec.SNMPUINTEGER32;
                } else if (oidType.equals(ManagerMibTree.BITS)) {
                    valueTypeString = SnmpBERCodec.SNMPBITSTRING;
                } else if (oidType.equals(ManagerMibTree.OPAQUE)) {
                    valueTypeString = SnmpBERCodec.SNMPOPAQUE;
                } else if (oidType.equals(ManagerMibTree.DISPLAYSTRING)) {
                    valueTypeString = SnmpBERCodec.SNMPOCTETSTRING;
                } else {
                    logger.warning("Error type " + miboid.getSyntax());
                    throw new SnmpSetException("noAccess OID " + setRequestOID);
                }
            } else {
                valueTypeString = createValueTypeString;
            }
        } else {
            if (createValueTypeString.equals("Auto")) {
                /*
                 * Set Request OIDMIB`Ō炸ASNMP Object Type
                 * 'Auto'̏ꍇ́ATypeFs̂ExceptionƂ
                 */
                throw new SnmpSetException(
                    "Bad value supplied for OID " + setRequestOID + ".");
            }

            valueTypeString = createValueTypeString;
        }

        /*
         * SNMP TypeɑΉSNMPIuWFNg擾AIuWFNg
         * ɒlZbgB
         * lZbgSNMPIuWFNgSNMP VarBindList𐶐
         * AgentSet Request𔭍sB
         */
        AbstractSnmpObject setSnmpObjectInstance =
            SnmpMappingTableController.getInstance().getSnmpObjectInstance(
                valueTypeString);

        if (setSnmpObjectInstance != null) {
            try {
                setSnmpObjectInstance.setValue(valueString);
            } catch (SnmpBadValueException e2) {
                logger.warning(e2.getMessage());
                e2.printStackTrace();
                throw new SnmpSetException(
                    "Bad value supplied for OID " + setRequestOID + ".");
            }
        } else {
            /* SNMP Object Typȅُꍇ */
            throw new SnmpSetException(
                "Illegal SNMP Object Type " + valueTypeString + ".");
        }

        return setSnmpObjectInstance;
    }
}
