/*
 * Created on 2004/05/18
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.MailProperty;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.jdom.Document;
import org.jdom.output.XMLOutputter;


/**
 * M\[Xt@CɃCgƂƂɁAXVԂ
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandResourceSet extends TemplateCommandImpl {
    // MO
    private static Logger logger;

    /**
     * \[XXV܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        // Document
        Document dom = null;

        // t@Co̓obt@
        BufferedWriter bufWriter = null;

        // VXe\[X
        ResourceInfo updateResourceInfo = com.getResourceInfo();

        // SNMPV3\`XV
        dom = this.updateSNMPV3Resource(updateResourceInfo);
        bufWriter =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getResourceFileWriter();

        // XMLt@Co
        this.outputXMLFile(bufWriter, dom);

        // VXe\[XXV
        dom = this.updateSystemResource(updateResourceInfo);
        bufWriter =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceFileWriter();

        // XMLt@Co
        this.outputXMLFile(bufWriter, dom);

        // FileɃCgɃCX^XXV
        SnmpV3ManagerConfig.getInstance().updateResourceset();
        SystemResourceConfig.getInstance().updateResourceset();

        // XV\[XǂݍŉƂĕԂ
        ResourceInfo resourceInfo =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();

        sendResponse(resourceInfo, ois, oos);
    }

    /*
     * SNMP V3Ǘ\[XXV܂B
     *
     * @param updateResourceInfo \[XXV
     * @return dom Document
     */
    private Document updateSNMPV3Resource(ResourceInfo updateResourceInfo) {
        Document dom =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .updateDocument(updateResourceInfo);

        return dom;
    }

    /*
     * VXe\[XXV܂B
     *
     * @param updateResourceInfo \[XXV
     * @return dom Document
     */
    private Document updateSystemResource(ResourceInfo updateResourceInfo) {
        MailProperty[] mailPoro = updateResourceInfo.getMailPropertyList();
        System.out.println("mailPoro.length : " + mailPoro.length);

        for (int i = 0; i < mailPoro.length; i++) {
            System.out.println("getSmtp_Host : " + mailPoro[i].getSmtpHost());
            System.out.println(
                "getMail_SendFlag : " + mailPoro[i].getMailSendFlag());
            System.out.println("getFrom : " + mailPoro[i].getFrom());

            String[] to = mailPoro[i].getTo();

            for (int j = 0; j < to.length; j++) {
                System.out.println("Mail to : " + to[j]);
            }
        }

        Document dom =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .updateDocument(updateResourceInfo);

        return dom;
    }

    /*
     * wBufferedWriterɎwDocumento͂܂B
     *
     * @param bufWriter BufferedWriter
     * @param dom Document
     */
    private void outputXMLFile(BufferedWriter bufWriter, Document dom) {
        /*
         * qGgeGg2wAGgԂ̉sw͂Ȃ
         * iXMLt@CŌXsĂ邽߁j
         * XMLOutputter outputter = new XMLOutputter("  ", true);
         */
        XMLOutputter outputter =
            XMLOutputterFormat.getInstance().getXMLOutputterFormat();

        FileWriter writer = null;

        try {
            outputter.output(dom, System.out);
            outputter.output(dom, bufWriter);
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }
}
