/*
 * Created on 2004/07/04
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.server.taskschedule.TaskScheduleControl;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;


/**
 * ^XNXPW[LZNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandTaskScheduleCancel extends TemplateCommandImpl {
    // MO
    private static Logger logger;

    /**
     * ^XNXPW[LZ܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        String taskId = com.getTaskScheduleInfo().getTaskID();
        Map scheduleMap = TaskScheduleControl.getInstance().getTaskSchedule();
        TaskScheduleInfo taskInfo = (TaskScheduleInfo) scheduleMap.get(taskId);
        taskInfo.setTaskID(taskId);
        logger.info("Cancel Task Id : " + taskInfo.getTaskID());

        // Timer Cancel
        if ((taskInfo != null) && (taskInfo.getTaskTimer() != null)) {
            TaskScheduleControl.getInstance().cancelTaskSchedule(taskInfo);
        } else {
            logger.warning("Not found Task ID : " + taskId);
        }

        sendResponse(CommandMappingTableResource.ACK_RESPONSE, ois, oos);
    }
}
