/*
 * Created on 2004/05/12
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.common.model;

/**
 * oCgf[^\ɕϊ郁\bhNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DataStringDisplay {
	private final static boolean ISHIDDEN = false;

	/** HEX當ϊl */
	public static final int HEX_TO_STRING = 16;

	/** HEX當ϊオ萔l */
	public static final int HEX_TO_STRING_POS = 256;

	/**
	 * oCgzf[^\pɕϊĕԂ܂B
	 * 
	 * @param byteData
	 *            oCgz
	 * @return \p
	 */
	public static String bytetoString(byte[] byteData) {
		StringBuffer returnString = new StringBuffer("");

		if (ISHIDDEN) {
			return returnString.toString();
		}

		for (int i = 0; i < byteData.length; i++) {
			returnString.append(Byte.toString(byteData[i]));
		}

		return returnString.toString();
	}

	/**
	 * MoCgf[^\p̕ɕϊ܂B
	 * 
	 * @param byteData
	 *            oCgf[^z
	 * @return 
	 */
	public static String bytetoChar(byte[] byteData) {
		StringBuffer returnString = new StringBuffer("");

		if (ISHIDDEN) {
			return returnString.toString();
		}

		for (int i = 0; i < byteData.length; i++) {
			returnString.append((char) byteData[i]);
		}

		return returnString.toString();
	}

	/**
	 * MoCgf[^\p̕ɕϊ܂B
	 * 
	 * @param byteData
	 *            oCgf[^z
	 * @return 
	 */
	public static String bytetoChar(byte[] byteData, int len) {
		StringBuffer returnString = new StringBuffer("");

		if (ISHIDDEN) {
			return returnString.toString();
		}

		for (int i = 0; i < byteData.length && i < len; i++) {

			returnString.append((char) byteData[i]);

		}

		return returnString.toString();
	}

	/**
	 * MoCgf[^\p̕ɕϊ܂B
	 * 
	 * @param byteData
	 *            ϊoCgf[^
	 * @param receiveLength
	 *            Mf[^
	 * @return ϊ
	 */
	public String hexBytetoString(byte[] byteData, int receiveLength) {
		StringBuffer returnString = new StringBuffer(System
				.getProperty("line.separator"));

		if (ISHIDDEN) {
			return returnString.toString();
		}

		for (int i = 0; (byteData.length > i) && (receiveLength > i); i++) {
			if (i != 0) {
				if ((i % HEX_TO_STRING) == 0) {
					returnString.append(System.getProperty("line.separator"));
				}
			}

			int pos = byteData[i];

			if (pos < 0) {
				pos += HEX_TO_STRING_POS;
			}

			returnString.append(Integer.toHexString(pos / HEX_TO_STRING));
			returnString
					.append((Integer.toHexString(pos % HEX_TO_STRING) + " "));
		}

		return returnString.toString();
	}

	/**
	 * oCgf[^𕶎ɕϊĕԂ܂B
	 * 
	 * @param byteData
	 *            ɕϊoCgR[h
	 * @return ϊ
	 */
	public String hexByte(byte byteData) {
		StringBuffer returnString = new StringBuffer();

		if (ISHIDDEN) {
			return returnString.toString();
		}

		int pos = byteData;

		if (pos < 0) {
			pos += HEX_TO_STRING_POS;
		}

		returnString.append(Integer.toHexString(pos / HEX_TO_STRING));
		returnString.append(Integer.toHexString(pos % HEX_TO_STRING));

		return returnString.toString();
	}
}
