/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionAlarmInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.alarm.EditorAllNodeAlarm;
import netjfwatcher.engine.view.editorpart.alarm.EditorNodeAlarm;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;


/**
 * A[ɊւANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderAlarmList {
    /* MO */
    private static Logger logger;

    /* m[hA[Xge[u\ANV */
    private IAction editorAlarm = new ActionOpenEditorPartPersonalNodeAlarm();

    /* Sm[hA[Xge[u\ANV */
    private IAction showAllNodeAlarmListTableAction =
        new ActionOpenEditorPartAllNodeAlarm();

    /* lbg[NoRł̃m[hA[Xge[u\ANV */
    private IAction editorAlarmSocket =
        new ActionOpenEditorPartPersonalNodeAlarmSocket();

    /* lbg[NoRSm[hA[Xge[u\ANV */
    private IAction showAllNodeAlarmListTableActionSocket =
        new ActionOpenEditorPartAllNodeAlarmSocket();

    /* m[hA[Xge[u\ANV */
    private IAction showNodeAlarmListTableAction =
        new ActionShowNodeAlarmListTable();

    /* Sm[hA[mFANV */
    private IAction confirmAllAlarmAction = new ActionConfirmAllAlarm();

    /* lbg[NoRSm[hA[mFANV */
    private IAction confirmAllAlarmActionSocket =
        new ActionConfirmAllAlarmSocket();

    /* m[hʃA[mFANV */
    private IAction confirmAlarmAction = new ActionConfirmAlarm();

    /* lbg[NoRm[hʃA[mFANV */
    private IAction confirmAlarmActionSocket = new ActionConfirmAlarmSocket();

    /* ʃA[ExportANV */
    private IAction exportAlarmAction = new ActionExportAlarmInfo();

    /* lbg[NoRʃA[ExportANV */
    private IAction exportAlarmActionSocket = new ActionExportAlarmInfoSocket();

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /**
     * AlarmXge[uViewɊւANVNX
     * CX^X𐶐܂B
     *
     */
    public ActionBuilderAlarmList() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Alarm Liste[u\ANVԂ܂B
     *
     * @return showAlarmListTableAction Alarm Liste[u\ANV
     */
    public IAction getActionShowAllNodeAlarmListTable() {
        return showAllNodeAlarmListTableAction;
    }

    /**
     * Sm[hAlarm Liste[u\ANVԂ܂B
     *
     * @return showAllNodeAlarmListTableActionSocket Sm[h
     * A[Liste[u\ANV
     */
    public IAction getActionShowAllNodeAlarmListTableSocket() {
        return showAllNodeAlarmListTableActionSocket;
    }

    /**
     * A[\ANVԂ܂B
     *
     * @return editorAlarm A[\ANV
     */
    public IAction getActionOpenEditorPartPersonalNodeAlarm() {
        return editorAlarm;
    }

    /**
     * lbg[NoRł̃A[\ANVԂ܂B
     *
     * @return editorAlarmSocket lbg[NoRł̃A[\
     * ANV
     */
    public IAction getActionOpenEditorPartPersonalNodeAlarmSocket() {
        return editorAlarmSocket;
    }

    /**
     * m[hAlarm Liste[u\ANVNX
     * CX^XԂ܂B
     *
     * @return showNodeAlarmListTableAction m[hAlarm List
     * e[u\ANVNXCX^X
     */
    public IAction getActionShowNodeAlarmListTable() {
        return showNodeAlarmListTableAction;
    }

    /**
     * wA[mFANVNXCX^X
     * Ԃ܂B
     *
     * @return confirmAllAlarmAction wAlarmmF
     * ANVNXCX^X
     */
    public IAction getActionConfirmAllAlarm() {
        return confirmAllAlarmAction;
    }

    /**
     * lbg[NoRSA[mFANVԂ܂B
     *
     * @return confirmAllAlarmActionSocket lbg[NoR
     * SA[mFANV
     */
    public IAction getActionConfirmAllAlarmSocket() {
        return confirmAllAlarmActionSocket;
    }

    /**
     * SA[mFANVԂ܂B
     *
     * @return confirmAlarmAction SAlarmmFANVNX
     * CX^X
     */
    public IAction getActionConfirmAlarm() {
        return confirmAlarmAction;
    }

    /**
     * lbg[NoRʃm[hA[mFANVԂ܂B
     *
     * @return confirmAlarmActionSocket lbg[NoR
     * m[hA[mFANV
     */
    public IAction getActionConfirmAlarmSocket() {
        return confirmAlarmActionSocket;
    }

    /**
     * A[o̓ANVԂ܂B
     *
     * @return exportAlarmAction A[o̓ANV
     */
    public IAction getActionExportAlarm() {
        return exportAlarmAction;
    }

    /**
     * lbg[NoRł̃A[o̓ANVԂ܂B
     *
     * @return exportAlarmActionSocket lbg[NoRł
     * A[o̓ANV
     */
    public IAction getActionExportAlarmSocket() {
        return exportAlarmActionSocket;
    }

    /**
     * A[e[uXV܂B
     *
     */
    protected void refreshNodeAlarmTable() {
    }

    /**
     * AlarmwFileExport܂B
     *
     * @param ipAddress m[hIPAhX
     * @param csvFile export file
     * @param isSocket lbg[NoRŃA[擾邩
     * ۂtO
     */
    public void writeCSVFile(
        String ipAddress, final String csvFile, boolean isSocket) {
        FileOutputStream fo = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;

        try {
            /* f[^x[XAlarm擾 */
            ArrayList alarmInfoList =
                getAlarmList(ipAddress, null, null, isSocket);

            if (alarmInfoList != null) {
                fo = new FileOutputStream(csvFile);
                osw = new OutputStreamWriter(fo);
                bw = new BufferedWriter(osw);

                for (int j = 0; j < alarmInfoList.size(); j++) {
                    AlarmInformation alarmInfo =
                        (AlarmInformation) alarmInfoList.get(j);

                    bw.write(
                        alarmInfo.getAlarmDate() + ","
                        + alarmInfo.getNodename() + ","
                        + alarmInfo.getIpaddress() + ","
                        + alarmInfo.getAlarmMessage() + ",");
                    bw.newLine();
                    bw.flush();
                }
            }
        } catch (SQLException e) {
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Alarm List import error", e.getMessage());
            logger.warning("Alarm List import error " + e.getMessage());
            e.printStackTrace();
        } catch (DatabaseConnectionException e) {
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Alarm List import error", e.getMessage());
            logger.warning("Alarm List import error " + e.getMessage());
            e.printStackTrace();
        } catch (FileNotFoundException e) {
            /* t@CȂ */
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
            /* t@Co͂Ɏs */
            logger.warning(e.getMessage());
            e.printStackTrace();

            return;
        } finally {
            // CSVGNX|[gš㏈
            if (bw != null) {
                try {
                    bw.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();

                    return;
                }
            }

            if (osw != null) {
                try {
                    osw.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();

                    return;
                }
            }

            if (fo != null) {
                try {
                    fo.close();
                } catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();

                    return;
                }
            }
        }
    }

    /**
     * f[^x[XAlarm擾܂B
     *
     * @param ipAddress m[hIPAhX
     * @param sortColumn \[gJ
     * @param sortDirection \[g
     * @param isSocket lbg[NoRf[^擾tO
     * @return alarmInfoList Alarm񃊃Xg
     * @throws DatabaseConnectionException f[^x[XANZXňُ킪ꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public ArrayList getAlarmList(
        String ipAddress, String sortColumn, String sortDirection,
        boolean isSocket) throws DatabaseConnectionException, SQLException {
        /* A[񃊃Xg */
        ArrayList alarmInfoList = null;

        if (!isSocket) {
            DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();

            /* A[擾 */
            alarmInfoList =
                alarmDBTable.findAllAlarm(
                    0, ipAddress, sortColumn, sortDirection);
        } else {
            String engineAddress =
                ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();

            ConnectionAlarmInformation connectAlarmInfo =
                new ConnectionAlarmInformation(engineAddress);

            try {
                alarmInfoList =
                    connectAlarmInfo.getAlarmInformationList(
                        0, ipAddress, null, null);
            } catch (EngineConnectException e) {
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Node List import error", e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            } catch (IOException e) {
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Node List import error", e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
        }

        return alarmInfoList;
    }

    /**
     * AlarmɊւANV`钊ۃNXłB
     *
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private abstract class AbstractAlarmListAction extends Action {
        public final void run() {
            doTask();
        }

        protected abstract void doTask();
    }

    /**
     * Sm[hAlarm\ Editor part\ANVNXłB
     *
     */
    protected class ActionOpenEditorPartAllNodeAlarm
        extends AbstractAlarmListAction {
        /**
         * Sm[hAlarm\Xge[uXVANV
         * ImageDescriptorԂ܂B
         *
         * @return Sm[hAlarm\Xge[uXVANV
         * ̃ACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.ALL_NODE_ALARM_VIEW_IMAGE_FILE));
        }

        /**
         * AlarmXge[uXVANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.ALL_NODE_ALARM_VIEW;
        }

        /**
         * AlarmXge[uXVANVToolTipTextԂ܂B
         *
         * @return@ToolTipText
         *
         */
        public String getToolTipText() {
            return MenuPreference.ALL_NODE_ALARM_VIEW_TOOL_TIP;
        }

        /**
         * Sm[hAlarm\Xge[uXV܂B
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            try {
                /*
                * EditorɃuEUI[v
                * EditorID̓uEŨNX
                */
                activePage.openEditor(
                    new EditorInputNodeView(
                        EditorAllNodeAlarm.TITLE_SUFFIX, null, false),
                    EditorAllNodeAlarm.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * lbg[NoRł̑Sm[hA[\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    protected class ActionOpenEditorPartAllNodeAlarmSocket
        extends ActionOpenEditorPartAllNodeAlarm {
        /**
         * Sm[hAlarm\Xge[uXV܂B
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            try {
                /*
                * EditorɃuEUI[v
                * EditorID̓uEŨNX
                */
                activePage.openEditor(
                    new EditorInputNodeView(
                        EditorAllNodeAlarm.TITLE_SUFFIX
                        + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(),
                        null, true), EditorAllNodeAlarm.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * m[h̃A[View\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionOpenEditorPartPersonalNodeAlarm
        extends AbstractAlarmListAction {
        /** m[hĎ */
        protected NodeInformation nodeInfo;

        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.NODE_ALARM_VIEW_IMAGE_FILE));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.NODE_ALARM_VIEW;
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.NODE_ALARM_VIEW_TOOL_TIP;
        }

        /**
         * Node Alarm View\^XNłB
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            try {
                /*
                 * IꂽGg̃m[hĎ񂩂EditorɃI[v
                 */
                activePage.openEditor(
                    new EditorInputNodeView(
                        nodeName + EditorNodeAlarm.TITLE_SUFFIX, nodeInfo, false),
                    EditorNodeAlarm.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /**
         * m[hĎZbg܂B
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    /**
     * ʃm[hA[\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public final class ActionOpenEditorPartPersonalNodeAlarmSocket
        extends ActionOpenEditorPartPersonalNodeAlarm {
        /**
         * Node Alarm View\^XNłB
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            try {
                /*
                 * IꂽGg̃m[hĎ񂩂EditorɃI[v
                 */
                activePage.openEditor(
                    new EditorInputNodeView(
                        nodeName + EditorNodeAlarm.TITLE_SUFFIX
                        + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(),
                        nodeInfo, true), EditorNodeAlarm.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * m[hAlarmXge[uXVANVNXłB
     * XVe[úAANVNXpNXŃI[o[
     * ChĎw肵܂B
     *
     */
    protected class ActionShowNodeAlarmListTable extends AbstractAlarmListAction {
        /**
         * AlarmXge[uXVANVImageDescriptorԂ܂B
         *
         * @return AlarmXge[uXVANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.NODE_ALARM_VIEW_IMAGE_FILE));
        }

        /**
         * m[hAlarmXge[uXVANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.NODE_ALARM_VIEW;
        }

        /**
         * AlarmXge[uXVANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.NODE_ALARM_VIEW_TOOL_TIP;
        }

        /**
         * m[hAlarmXge[uXV܂B
         *
         */
        protected void doTask() {
            refreshNodeAlarmTable();
        }
    }

    /**
     * AlarmmFANVNXłB
     *
     * @author Yoshimasa matsumoto
     *
     */
    public class ActionConfirmAlarm extends AbstractAlarmListAction {
        /* mFς݂ƂAlarm ID */
        protected String confirmAlarmID;

        /* mFς݂Ƃm[hIPAhX */
        protected String confirmIPAddress;

        /**
         * Alarm IDZbg܂B
         *
         * @param alarmID Alarm ID
         * @param confirmIPAddress mFm[hIPAhX
         */
        public void setConfirmAlarm(String alarmID, String confirmIPAddress) {
            this.confirmAlarmID = alarmID;
            this.confirmIPAddress = confirmIPAddress;
        }

        /**
         * AlarmmFANṼACRImageDescriptorԂ܂B
         *
         * @return AlarmmFANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.ALARM_CONFIRM_IMAGE_FILE));
        }

        /**
         * AlarmmFsANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.ALARM_CONFIRM;
        }

        /**
         * AlarmmFsANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.ALARM_CONFIRM_TOOL_TIP;
        }

        /**
         * AlarmmF܂B
         *
         */
        protected void doTask() {
            if ((confirmAlarmID != null) && (confirmIPAddress != null)) {
                logger.info("Confirm Alarm ID = " + confirmAlarmID);

                DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();

                try {
                    /* wA[IDmFς݂Ƃ */
                    alarmDBTable.updateAlarmIDConfirm(
                        confirmIPAddress, confirmAlarmID);

                    refreshNodeAlarmTable();
                } catch (SQLException e) {
                    logger.warning(
                        "Alarm table access error : " + e.getMessage());
                    e.printStackTrace();

                    Shell shell = new Shell();
                    MessageDialog.openError(shell, "Error", e.getMessage());
                    shell.dispose();
                } catch (DatabaseConnectionException e) {
                    logger.warning(
                        "Alarm table access error : " + e.getMessage());
                    e.printStackTrace();

                    Shell shell = new Shell();
                    MessageDialog.openError(shell, "Error", e.getMessage());
                    shell.dispose();
                }

                confirmAlarmID = null;
                confirmIPAddress = null;
            }
        }
    }

    /**
     * lbg[NoRł̃A[mFANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionConfirmAlarmSocket extends ActionConfirmAlarm {
        /**
         * AlarmmF܂B
         *
         */
        protected void doTask() {
            if ((confirmAlarmID != null) && (confirmIPAddress != null)) {
                logger.info("Confirm Alarm ID = " + confirmAlarmID);

                String engineAddress =
                    ClientEngineInfo.getClientEngineInfoInstance()
                                    .getEngineAddress();

                try {
                    ConnectionAlarmInformation connection =
                        new ConnectionAlarmInformation(engineAddress);
                    connection.confirmAlarmId(confirmIPAddress, confirmAlarmID);
                } catch (EngineConnectException e) {
                    logger.warning(
                        "Alarm table access error : " + e.getMessage());
                    e.printStackTrace();

                    Shell shell = new Shell();
                    MessageDialog.openError(shell, "Error", e.getMessage());
                    shell.dispose();
                } catch (IOException e) {
                    logger.warning(
                        "Alarm table access error : " + e.getMessage());
                    e.printStackTrace();

                    Shell shell = new Shell();
                    MessageDialog.openError(shell, "Error", e.getMessage());
                    shell.dispose();
                } catch (Exception e) {
                    logger.warning(
                        "Alarm table access error : " + e.getMessage());
                    e.printStackTrace();

                    Shell shell = new Shell();
                    MessageDialog.openError(shell, "Error", e.getMessage());
                    shell.dispose();
                }

                confirmAlarmID = null;
                confirmIPAddress = null;
            }
        }
    }

    /**
     * Sm[hAlarm܂́Awm[h̑SAlarmmFANV
     * NXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionConfirmAllAlarm extends AbstractAlarmListAction {
        /** AlarmmFm[hIP Address(Sm[h̏ꍇ'all') */
        protected String confirmIPAddress;

        /**
         * AlarmmFm[hIP Addressݒ肵܂B
         * Sm[h̏ꍇɂallwŁAm[hʂ̏ꍇɂ̓m[hIP
         * AddressƂȂ܂B
         *
         * @param confirmIPAddress AlarmmFm[hIP Address
         */
        public void setAlarmIPAddress(String confirmIPAddress) {
            this.confirmIPAddress = confirmIPAddress;
        }

        /**
         * AlarmmFANṼACRImageDescriptorԂ܂B
         *
         * @return AlarmmFANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.ALL_ALARM_CONFIRM_IMAGE_FILE));
        }

        /**
         * AlarmmFsANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.ALL_ALARM_CONFIRM;
        }

        /**
         * AlarmmFsANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.ALL_ALARM_CONFIRM_TOOL_TIP;
        }

        /**
         * SĂAlarmmF܂B
         *
         */
        protected void doTask() {
            Shell shell = new Shell();

            try {
                if (
                    MessageDialog.openQuestion(
                            shell, "Confirm", "All alarm confirm ?")) {
                    if (confirmIPAddress != null) {
                        DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();

                        try {
                            /* SA[mFς݂Ƃ */
                            alarmDBTable.updateAllAlarmIDConfirm(
                                confirmIPAddress);

                            refreshNodeAlarmTable();
                        } catch (SQLException e) {
                            logger.warning(
                                "Alarm table access error : " + e.getMessage());
                            e.printStackTrace();
                            MessageDialog.openError(
                                shell, "Error", e.getMessage());
                        } catch (DatabaseConnectionException e) {
                            logger.warning(
                                "Alarm table access error : " + e.getMessage());
                            e.printStackTrace();
                            MessageDialog.openError(
                                shell, "Error", e.getMessage());
                        }

                        confirmIPAddress = null;
                    }
                }
            } finally {
                shell.dispose();
            }
        }
    }

    /**
     * lbg[NoRSA[mFANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionConfirmAllAlarmSocket extends ActionConfirmAllAlarm {
        /**
         * SĂAlarmmF܂B
         *
         */
        protected void doTask() {
            Shell shell = new Shell();

            try {
                if (
                    MessageDialog.openQuestion(
                            shell, "Confirm", "All alarm confirm ?")) {
                    if (confirmIPAddress != null) {
                        System.out.println("Alarm confirm Socket");

                        String engineAddress =
                            ClientEngineInfo.getClientEngineInfoInstance()
                                            .getEngineAddress();
                        System.out.println("EngineAddress : " + engineAddress);

                        try {
                            ConnectionAlarmInformation connection =
                                new ConnectionAlarmInformation(engineAddress);
                            connection.confirmAllAlarmt(confirmIPAddress);
                        } catch (EngineConnectException e) {
                            logger.warning(
                                "Alarm table access error : " + e.getMessage());
                            e.printStackTrace();
                            MessageDialog.openError(
                                shell, "Error", e.getMessage());
                        } catch (IOException e) {
                            logger.warning(
                                "Alarm table access error : " + e.getMessage());
                            e.printStackTrace();
                            MessageDialog.openError(
                                shell, "Error", e.getMessage());
                        } catch (Exception e) {
                            logger.warning(
                                "Alarm table access error : " + e.getMessage());
                            e.printStackTrace();
                            MessageDialog.openError(
                                shell, "Error", e.getMessage());
                        }

                        refreshNodeAlarmTable();
                    }

                    confirmIPAddress = null;
                }
            } finally {
                shell.dispose();
            }
        }
    }

    /**
     * AlarmCSVo͂ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionExportAlarmInfo extends AbstractAlarmListAction {
        /** m[hIPAhX */
        protected String ipAddress;

        /**
         * AlarmCSVo͂ANṼACRImageDescriptorԂ܂B
         *
         * @return AlarmmFANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.ALARM_EXPORT_IMAGE_FILE));
        }

        /**
         * AlarmCSVo͂ANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.ALARM_EXPORT;
        }

        /**
         * AlarmCSVo͂ANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.ALARM_EXPORT_TOOL_TIP;
        }

        /**
         * AlarmCSVo͂܂B
         *
         */
        protected void doTask() {
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, SWT.SAVE);
            String csvFile = openDialog.open();
            logger.info(
                "Alarm traget IP Address : " + ipAddress
                + " ,Open file name : " + csvFile);

            if (csvFile == null) {
                return;
            }

            writeCSVFile(ipAddress, csvFile, false);
        }

        /**
         * AlarmExportm[hIPAhXZbg܂B
         *
         * @param ipAddress m[hIPAhX
         */
        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }
    }

    /**
     * lbg[NoRA[o̓ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionExportAlarmInfoSocket extends ActionExportAlarmInfo {
        /**
         * AlarmCSVo͂܂B
         *
         */
        protected void doTask() {
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, SWT.SAVE);
            String csvFile = openDialog.open();

            logger.info(
                "Alarm traget IP Address : " + ipAddress
                + ", Open file name : " + csvFile);

            if (csvFile == null) {
                return;
            }

            writeCSVFile(ipAddress, csvFile, true);
        }
    }
}
