/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.ping.EditorNodePingResponseData;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmpStatisticsData;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;



/**
 * f[^Table\ANVNXNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderNodeDataTable {
    /* MO */
    private static Logger logger;

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /* m[hViewō\\EditorPartEditorPart
     * JxɁAUEditorPartCloseĂOpen
     */
    private IEditorPart editorNodeConfigView;

    /* m[hPingf[^\ANV */
    private IAction showPingData = new ActionShowPingResponseData();

    /* lbg[NoRł̃m[hPingf[^\ANV */
    private IAction showPingDataSocket = new ActionShowPingResponseDataSocket();

    /**
     * f[^Table\ANVNXNXCX^X
     * 𐶐܂B
     */
    public ActionBuilderNodeDataTable() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
    * m[hPingf[^f[^e[u\ANVԂ܂B
    *
    * @return showPingData m[hPingf[^e[u\ANV
    */
    public IAction actionShowPingDataView() {
        return showPingData;
    }

    /**
     * lbg[NoRł̃m[hPingf[^e[u\ANV
     * Ԃ܂B
     *
     * @return showPingDataSocket lbg[NoRł̃m[hPingf[^
     * e[u\ANV
     */
    public IAction actionShowPingDataViewSocket() {
        return showPingDataSocket;
    }

    /**
     * m[hSNMPvf[^e[u\ANVԂ܂B
     *
     * @return m[hSNMPvf[^e[u\ANV
     */
    public IAction actionShowStatisticsData() {
        return new ActionShowStatisticsData();
    }

    /**
     * lbg[NoRł̃m[hSNMPvf[^e[u\ANVԂ܂B
     *
     * @return lbg[NoRł̃m[hSNMPvf[^e[u\ANV
     */
    public IAction actionShowStatisticsDataSocket() {
        return new ActionShowStatisticsDataSocket();
    }

    /**
     * m[h̒ǉA폜ɊւANV̒ۊNXB 
     * ܂؂ދȏĂB
     * <p>
     * {@link #doTask(FeedGroup, Node)}ΊȒPɃANVI
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    protected abstract class AbstractDataTableAction extends Action {
        /**
             * ANV܂B
             */
        public final void run() {
            doTask();
        }

        /**
         * ANV^XNłB
         */
        protected abstract void doTask();
    }

    /**
     * m[hSNMPv\ANVNXłB
     *
     * @author Yoshimasa matsumoto
     * @version 1.0
     */
    public final class ActionShowStatisticsData extends AbstractDataTableAction {
        /* m[hĎ */
        private NodeInformation nodeInfo;

        /* SNMPv\OID */
        private String oid;

        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/table.gif"));
        }

        /**
         * Node Snmp View\^XNłB
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                            nodeName
                            + EditorNodeSnmpStatisticsData.TITLE_SUFFIX
                            + " OID=" + oid, nodeInfo, false, oid),
                        EditorNodeSnmpStatisticsData.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /**
         * m[h̓v\sOIDݒ肵܂B
         *
         * @param oid v\sOID
         */
        public void setOid(String oid) {
            this.oid = oid;
        }

        /**
         * m[hĎZbg܂B
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    /**
     * lbg[NoRł̃m[hSNMPv\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public final class ActionShowStatisticsDataSocket
        extends AbstractDataTableAction {
        /* m[hĎ */
        private NodeInformation nodeInfo;

        /* SNMPv\OID */
        private String oid;

        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/table.gif"));
        }

        /**
         * Node Snmp View\^XNłB
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            /*  */
            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                            nodeName
                            + EditorNodeSnmpStatisticsData.TITLE_SUFFIX
                            + " OID=" + oid
                            + NetworkClientNodeTreeView
                            .getTitleSuffixEngineAddress(), nodeInfo, true, oid),
                        EditorNodeSnmpStatisticsData.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /**
         * m[h̓v\sOIDݒ肵܂B
         *
         * @param oid v\sOID
         */
        public void setOid(String oid) {
            this.oid = oid;
        }

        /**
         * m[hĎZbg܂B
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    /**
     * Pingf[^\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public final class ActionShowPingResponseData
        extends AbstractDataTableAction {
        /* m[hĎ */
        private NodeInformation nodeInfo;

        /**
        * ImageDescriptorԂ܂B
        *
        * @return ImageDescriptor
        */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/table.gif"));
        }

        /**
         * Pingf[^\ANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Ping response";
        }

        /**
         * Pingf[^\ANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "Ping response";
        }

        /**
         * Node Pingf[^View\^XNłB
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            /* m[h */
            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                            nodeName + EditorNodePingResponseData.TITLE_SUFFIX,
                            nodeInfo, false),
                        EditorNodePingResponseData.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /**
         * m[hĎZbg܂B
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    /**
     * lbg[NoRPingf[^\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public final class ActionShowPingResponseDataSocket
        extends AbstractDataTableAction {
        /* m[hĎ  */
        private NodeInformation nodeInfo;

        /**
        * ImageDescriptorԂ܂B
        *
        * @return ImageDescriptor
        */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/table.gif"));
        }

        /**
         * Pingf[^\ANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Ping response";
        }

        /**
         * Pingf[^\ANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "Ping response";
        }

        /**
         * Node Pingf[^View\^XNłB
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            /* m[h */
            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                            nodeName + EditorNodePingResponseData.TITLE_SUFFIX
                            + NetworkClientNodeTreeView
                            .getTitleSuffixEngineAddress(), nodeInfo, true),
                        EditorNodePingResponseData.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /**
         * m[hĎZbg
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }
}
