/*
 * Created on 2004/06/10
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodecontrol;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.noderegister.snmp.NodeSnmpRegisterInitializeThread;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;
import netjfwatcher.engine.server.protocol.control.AbstractQueueForProtocolCheck;
import netjfwatcher.engine.server.protocol.control.ListQueueDatabaseWatchControl;
import netjfwatcher.engine.server.protocol.control.ListQueueDefaultSnmpMibControl;
import netjfwatcher.engine.server.protocol.control.ListQueueHTTPControl;
import netjfwatcher.engine.server.protocol.control.ListQueuePingControl;
import netjfwatcher.engine.server.protocol.control.ListQueuePopControl;
import netjfwatcher.engine.server.protocol.control.ListQueueSmtpControl;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.server.protocol.snmp.NetSnmpOid;
import netjfwatcher.engine.server.protocol.snmp.SnmpIfOctet;
import netjfwatcher.engine.snmpmanager.statistics.ThreadStatisticsMibGetControl;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.snmp.preference.SnmpPreference;

/**
 * m[hĎXV郁\bhNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class NodeEdit {
	/* MO */
	private static Logger logger = null;

	/* m[hĎ */
	private NodeWatchInfo nodewatchinfo;

	/*
	 * m[hĎXV郁\bhNXCX^X ܂B
	 */
	private NodeEdit() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * m[hĎҏWEXV܂B
	 * 
	 * @param com
	 *            R}h
	 */
	public void editNodeInfo(CommandInfo com) {
		NodeInformation editNewNodeInfo = com.getNodeInformation();

		try {
			editNodeInfo(editNewNodeInfo);
		} catch (SQLException e1) {
			logger.warning("SQLException " + e1.getMessage());

			return;
		} catch (DatabaseConnectionException e1) {
			logger.warning("DatabaseConnectionException " + e1.getMessage());

			return;
		}
	}

	/**
	 * m[hĎҏWEXV܂B
	 * 
	 * @param editNewNodeInfo
	 *            m[hĎ
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public void editNodeInfo(NodeInformation editNewNodeInfo)
			throws DatabaseConnectionException, SQLException {
		/* PingĎύXɂPingĎThreadċNtO */
		boolean isRestartPingThread = false;

		/* SNMPĎύXɂSNMPĎThreadċNtO */
		boolean isRestartSNMPThread = false;

		NodeInformation updateNodeInfo = null;
		NodeInformation workNodeInfo = null;
		String ipaddress = editNewNodeInfo.getIpaddress();

		// f[^x[Xm[hĎe[uXV擾
		DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
				.getInstance();

		try {
			ArrayList list = nodeRegisterDBTable.findTarget(ipaddress);
			workNodeInfo = (NodeInformation) list.get(0);

			// m[hǗXV
			nodeRegisterDBTable.updateNode(editNewNodeInfo);

			list = nodeRegisterDBTable.findTarget(ipaddress);

			updateNodeInfo = (NodeInformation) list.get(0);
		} catch (SQLException e1) {
			logger.warning("SQLException " + e1.getMessage());
			throw e1;
		} catch (DatabaseConnectionException e1) {
			logger.warning("DatabaseConnectionException " + e1.getMessage());
			throw e1;
		}

		String nowSnmpPerid = workNodeInfo.getSnmpPeriod();
		String newSnmpPerid = editNewNodeInfo.getSnmpPeriod();
		String nowSnmpLevel = workNodeInfo.getSnmpLevel();
		String newSnmpLevel = editNewNodeInfo.getSnmpLevel();
		String nowSnmpVersion = workNodeInfo.getSnmpVersion();
		String newSnmpVersion = editNewNodeInfo.getSnmpVersion();
		String nowSnmpCommunity = workNodeInfo.getRoCommunity();
		String newSnmpCommunity = editNewNodeInfo.getRoCommunity();

		if (!nowSnmpPerid.equals(newSnmpPerid)
				|| !nowSnmpLevel.equals(newSnmpLevel)
				|| !nowSnmpVersion.equals(newSnmpVersion)
				|| !nowSnmpCommunity.equals(newSnmpCommunity)) {
			/* SNMPĎύXɂSNMPĎThreadċNtOZbg */
			isRestartSNMPThread = true;
		}

		String nowPingPerid = workNodeInfo.getPingPeriod();
		String newPingPerid = editNewNodeInfo.getPingPeriod();
		String nowPingThreshold = workNodeInfo.getPingThreshold();
		String newPingThreshold = editNewNodeInfo.getPingThreshold();

		if (!nowPingPerid.equals(newPingPerid)
				|| !nowPingThreshold.equals(newPingThreshold)) {
			/* PingĎύXɂPingĎThreadċNtOZbg */
			isRestartPingThread = true;
		}

		nodewatchinfo = new NodeWatchInfo();

		String snmpVersion = updateNodeInfo.getSnmpVersion();

		if (snmpVersion.equals(SnmpPreference.SNMPV1_DESCRIPTION)) {
			nodewatchinfo.setSnmpVersion(SnmpPreference.SNMP_VERSION_1);
		} else if (snmpVersion.equals(SnmpPreference.SNMPV2_DESCRIPTION)) {
			nodewatchinfo.setSnmpVersion(SnmpPreference.SNMPV2C);
		} else if (snmpVersion.equals(SnmpPreference.SNMPV3_DESCRIPTION)) {
			nodewatchinfo.setSnmpVersion(SnmpPreference.SNMPV3);
		} else {
			logger.warning("Bad snmp version : " + snmpVersion);
		}

		nodewatchinfo.setIpaddress(updateNodeInfo.getIpaddress());
		nodewatchinfo.setNodename(updateNodeInfo.getNodename());

		/* PingĎ */
		nodewatchinfo.setPingPeriod(updateNodeInfo.getPingPeriod());
		nodewatchinfo.setPingThreshold(updateNodeInfo.getPingThreshold());

		/* SNMPĎ */
		nodewatchinfo.setSnmpPeriod(updateNodeInfo.getSnmpPeriod());
		nodewatchinfo.setSnmpLevel(updateNodeInfo.getSnmpLevel());
		nodewatchinfo.setSnmpROCommunity(updateNodeInfo.getRoCommunity());
		nodewatchinfo.setSnmpRWCommunity(updateNodeInfo.getRwCommunity());

		/* HTTPĎ */
		nodewatchinfo.setHttpUrl(updateNodeInfo.getHttpUrl());
		nodewatchinfo.setHttpPeriod(updateNodeInfo.getHttpPeriod());
		nodewatchinfo.setHttpTimeout(updateNodeInfo.getHttpTimeout());

		/* PopĎ */
		nodewatchinfo.setPopPeriod(updateNodeInfo.getPopPeriod());
		nodewatchinfo.setPopUser(updateNodeInfo.getPopUser());
		nodewatchinfo.setPopPassword(updateNodeInfo.getPopPassword());
		nodewatchinfo.setPopPort(updateNodeInfo.getPopPort());
		nodewatchinfo.setPopTimeout(updateNodeInfo.getPopTimeout());

		/* SMTPĎ */
		nodewatchinfo.setSmtpPeriod(updateNodeInfo.getSmtpPeriod());
		nodewatchinfo.setSmtpPort(updateNodeInfo.getSmtpPort());
		nodewatchinfo.setSmtpTimeout(updateNodeInfo.getSmtpTimeout());
		nodewatchinfo.setSmtpTestAddress(updateNodeInfo.getSmtpSendAddress());
		nodewatchinfo.setSmtpCheckPop3Host(updateNodeInfo.getSmtpCheckHost());
		nodewatchinfo.setSmtpCheckPop3User(updateNodeInfo.getSmtpCheckUser());
		nodewatchinfo.setSmtpCheckPop3Password(updateNodeInfo
				.getSmtpCheckPassword());
		nodewatchinfo.setSmtpCheckPop3Port(updateNodeInfo.getSmtpCheckPort());
		nodewatchinfo.setSmtpCheckPop3Timeout(updateNodeInfo
				.getSmtpCheckTimeout());

		/*
		 * f[^x[XĎZbg
		 */
		nodewatchinfo.setDatabaseWatcherInfo(updateNodeInfo
				.getDatabaseWatcherInfo());

		// ThreadXgXV
		this.setThreadList(nodewatchinfo, isRestartPingThread,
				isRestartSNMPThread);
	}

	/*
	 * m[hĎXbh̊ĎXV܂B
	 * 
	 * @param nodewatchinfo m[hĎ @param isRestartPingThread
	 * PingĎύXɂPingĎThreadċNtO @param isRestartSNMPThread
	 * SNMPĎύXɂSNMPĎThreadċNtO
	 */
	private void setThreadList(NodeWatchInfo nodewatchinfo,
			boolean isRestartPingThread, boolean isRestartSNMPThread) {
		int pingPeriod = 0;
		int snmpLevel = 0;
		int snmpPeriod = 0;

		int httpPeriod = 0;
		int pop3Period = 0;
		int smtpPeriod = 0;

		String ipaddress = nodewatchinfo.getIpaddress();
		int version = nodewatchinfo.getSnmpVersion();
		String roCommunity = nodewatchinfo.getSnmpROCommunity();

		String threshHold = nodewatchinfo.getPingThreshold();

		try {
			if (!nodewatchinfo.getPingPeriod().equals("--")) {
				pingPeriod = Integer.parseInt(nodewatchinfo.getPingPeriod());
			}
		} catch (NumberFormatException e) {
			logger.warning(e.getMessage());
		}

		try {
			if (!nodewatchinfo.getHttpPeriod().equals("--")) {
				httpPeriod = Integer.parseInt(nodewatchinfo.getHttpPeriod());
			}
		} catch (NumberFormatException e) {
			logger.warning(e.getMessage());
		}

		try {
			snmpLevel = Integer.parseInt(nodewatchinfo.getSnmpLevel());
		} catch (NumberFormatException e) {
			logger.warning(e.getMessage());
		}

		try {
			if (!nodewatchinfo.getSnmpPeriod().equals("--")) {
				snmpPeriod = Integer.parseInt(nodewatchinfo.getSnmpPeriod());
			}
		} catch (NumberFormatException e) {
			logger.warning(e.getMessage());
		}

		try {
			if (!nodewatchinfo.getPopPeriod().equals("--")) {
				pop3Period = Integer.parseInt(nodewatchinfo.getPopPeriod());
			}
		} catch (NumberFormatException e) {
			logger.warning(e.getMessage());
		}

		try {
			if (!nodewatchinfo.getSmtpPeriod().equals("--")) {
				smtpPeriod = Integer.parseInt(nodewatchinfo.getSmtpPeriod());
			}
		} catch (NumberFormatException e) {
			logger.warning(e.getMessage());
		}

		if (isRestartPingThread) {
			logger.info("SNMP Thread Restart");

			/*
			 * PingLłpingZbg iɃZbgς݂łΏ㏑j
			 */
			if (pingPeriod > 0) {
				// PingsList Zbg
				NodeWatchInfo info = new NodeWatchInfo();
				info.setPingPeriod(Integer.toString(pingPeriod));
				info.setSnmpROCommunity(roCommunity);
				info.setPingThreshold(threshHold);
				info.setIpaddress(ipaddress);
				info.setNodename(nodewatchinfo.getNodename());
				ListQueuePingControl.getInstance().setPingNode(ipaddress, info);
			} else {
				ListQueuePingControl.getInstance().removePingNode(ipaddress);
			}
		}

		/*
		 * HTTPLłHTTPZbg iɃZbgς݂łΏ㏑j
		 */
		if (httpPeriod > 0) {
			// HTTPsList Zbg
			NodeWatchInfo info = new NodeWatchInfo();
			info.setHttpPeriod(Integer.toString(httpPeriod));
			info.setHttpUrl(nodewatchinfo.getHttpUrl());
			info.setHttpTimeout(nodewatchinfo.getHttpTimeout());
			info.setIpaddress(ipaddress);
			info.setNodename(nodewatchinfo.getNodename());
			ListQueueHTTPControl.getInstance().setHTTPNode(ipaddress, info);
		} else {
			ListQueueHTTPControl.getInstance().removeHTTPNode(ipaddress);
		}

		/*
		 * Pop3ĎLłPop3ĎZbg iɃZbgς݂łΏ㏑j
		 */
		if (pop3Period > 0) {
			NodeWatchInfo info = new NodeWatchInfo();
			info.setPopPeriod(Integer.toString(pop3Period));
			info.setPopUser(nodewatchinfo.getPopUser());
			info.setPopPassword(nodewatchinfo.getPopPassword());
			info.setPopPort(nodewatchinfo.getPopPort());
			info.setPopTimeout(nodewatchinfo.getPopTimeout());
			info.setIpaddress(ipaddress);
			info.setNodename(nodewatchinfo.getNodename());
			ListQueuePopControl.getInstance().setPop3Node(ipaddress, info);
		} else {
			ListQueuePopControl.getInstance().removePopNode(ipaddress);
		}

		/*
		 * SMTPĎLłSMTPĎZbg iɃZbgς݂łΏ㏑j
		 */
		if (smtpPeriod > 0) {
			NodeWatchInfo info = new NodeWatchInfo();
			info.setSmtpPeriod(Integer.toString(smtpPeriod));
			info.setSmtpPort(nodewatchinfo.getSmtpPort());
			info.setSmtpTimeout(nodewatchinfo.getSmtpTimeout());
			info.setSmtpTestAddress(nodewatchinfo.getSmtpTestAddress());
			info.setSmtpCheckPop3Host(nodewatchinfo.getSmtpCheckPop3Host());
			info.setSmtpCheckPop3User(nodewatchinfo.getSmtpCheckPop3User());
			info.setSmtpCheckPop3Password(nodewatchinfo
					.getSmtpCheckPop3Password());
			info.setSmtpCheckPop3Port(nodewatchinfo.getSmtpCheckPop3Port());
			info.setSmtpCheckPop3Timeout(nodewatchinfo
					.getSmtpCheckPop3Timeout());
			info.setIpaddress(ipaddress);
			info.setNodename(nodewatchinfo.getNodename());
			ListQueueSmtpControl.getInstance().setSmtpNode(ipaddress, info);
		} else {
			ListQueueSmtpControl.getInstance().removeSmtpNode(ipaddress);
		}


		DatabaseWatcherInfo databaseWatcherInfo = nodewatchinfo
				.getDatabaseWatcherInfo();
		if (databaseWatcherInfo != null) {
			String databaseInfoPeriod = databaseWatcherInfo.getWatcherPeriod();
			int databaseInfoPeriodData = 0;
			if (databaseInfoPeriod == null || !databaseInfoPeriod.equals("--")) {
				try {
					databaseInfoPeriodData = Integer
							.parseInt(databaseInfoPeriod);
				} catch (NumberFormatException e3) {
					logger.warning("database watch period : "
							+ databaseInfoPeriod);
				}
			}
			
			// DatabaseĎThreadAX^[g
			if (databaseInfoPeriodData > 0) {
				
				
				// DatabasesList Zbg
				NodeWatchInfo info = new NodeWatchInfo();
				info.setIpaddress(ipaddress);
				info.setNodename(nodewatchinfo.getNodename());
				info.setDatabaseWatcherInfo(nodewatchinfo
						.getDatabaseWatcherInfo());
				ListQueueDatabaseWatchControl.getInstance().setDatabaseNode(
						ipaddress, info);
			} else {
				ListQueueDatabaseWatchControl.getInstance().removeDatabaseNode(
						ipaddress);
			}
		}

		if (isRestartSNMPThread) {
			setSNMPThread(ipaddress, snmpLevel, version, snmpPeriod,
					roCommunity);
		}
	}

	/**
	 * SNMP ̎ThreadZbg܂B
	 * 
	 * @param ipaddress
	 *            m[hIP Address
	 * @param snmpLevel
	 *            SNMPĎx
	 * @param version
	 *            SNMPo[W
	 * @param snmpPeriod
	 *            SNMP̎
	 * @param roCommunity
	 *            SNMP ReadR~jeB
	 */
	private void setSNMPThread(String ipaddress, int snmpLevel, int version,
			int snmpPeriod, String roCommunity) {

		NodeWatchInfo nodeInfo = BaseNodeWatchInfoList.getInstance()
				.getNodeWatchInfo(ipaddress);

		if (nodeInfo != null) {
			String systemMibStatus = nodeInfo.getSystemMIBStatus();
			String statisticsMibStatus = nodeInfo.getStatisticsMIBStatus();
			String interfaceMibStatus = nodeInfo.getInterfaceMIBStatus();
			String printMibStatus = nodeInfo.getPrintMIBStatus();
			if (snmpPeriod != 0) {

				if (systemMibStatus.equals(NodeWatchInfo.SYSTEM_MIB_PENDING)
						&& interfaceMibStatus
								.equals(NodeWatchInfo.INTERFACE_MIB_PENDING)) {

					if (!nodewatchinfo.getNodeKind().equals(NodeKind.PRINTER)
							|| !printMibStatus
									.equals(NodeWatchInfo.PRINT_MIB_PENDING)) {

						if (snmpLevel > SnmpPreference.SNMP_LEVEL0) {
							/*
							 * SNMP Thread(System MIByInterfaces MIB̎) AX^[g
							 */
							Thread t = new Thread(
									new NodeSnmpRegisterInitializeThread(
											ipaddress, version, snmpPeriod,
											roCommunity, snmpLevel,
											nodewatchinfo.getNodeKind()));
							t.setDaemon(true);
							t.setName("SNMPInitThread:" + ipaddress + " : ");
							t.start();
						}
					}
				}
			}
			/* UASNMP System/Interface MIB̎惊Xg폜 */
			ListQueueDefaultSnmpMibControl.getInstance().removeDefaultSnmpNode(
					ipaddress);

			/* UASNMPv̎惊Xg폜 */
			ListQueueStatisticsMibControl.getInstance()
					.removeStatisticsMibGetNode(ipaddress);

			if (snmpPeriod == 0) {
				return;
			}
			if (snmpLevel > SnmpPreference.SNMP_LEVEL0) {
				/*
				 * SNMP̎惌x1ȏłSystem/Interface MIB̎
				 */
				NodeWatchInfo info2 = new NodeWatchInfo();
				info2.setSnmpPeriod(nodewatchinfo.getSnmpPeriod());
				info2.setSnmpROCommunity(roCommunity);
				info2.setIpaddress(ipaddress);
				info2.setNodeKind(nodewatchinfo.getNodeKind());
				// Listɓo^
				ListQueueDefaultSnmpMibControl.getInstance()
						.setDefaultSnmpNode(ipaddress, info2);
			}

			if (snmpLevel == SnmpPreference.SNMP_LEVEL2) {
				if (statisticsMibStatus
						.equals(AbstractQueueForProtocolCheck.PENDING_STATUS)) {
					// MINebg Database e[u쐬
					ThreadStatisticsMibGetControl ifoctet = new ThreadStatisticsMibGetControl();

					/* ifInOctets̎Zbg */
					ifoctet.editNodeSnmpInfo(nodewatchinfo.getIpaddress(),
							nodewatchinfo.getSnmpVersion(), nodewatchinfo
									.getSnmpROCommunity(), nodewatchinfo
									.getSnmpPeriod(), SnmpIfOctet.IF_IN_OCTETS);

					/* ifOutOctets̎Zbg */
					ifoctet
							.editNodeSnmpInfo(nodewatchinfo.getIpaddress(),
									nodewatchinfo.getSnmpVersion(),
									nodewatchinfo.getSnmpROCommunity(),
									nodewatchinfo.getSnmpPeriod(),
									SnmpIfOctet.IF_OUT_OCTETS);
				}

				// SNMPv̎Threado^
				StatisticsMibInfo mibInfo = StatisticsMibInfo
						.getInstance(ipaddress);
				mibInfo.setNodeName(nodewatchinfo.getNodename());
				mibInfo.setVersion(version);
				mibInfo.setCommunity(roCommunity);
				mibInfo.setOidList(SnmpIfOctet.IF_IN_OCTETS, nodewatchinfo
						.getSnmpPeriod(), "0", "");

				// Listɓo^
				ListQueueStatisticsMibControl.getInstance()
						.setStatisticsMibGetNode(ipaddress, mibInfo);

				mibInfo = StatisticsMibInfo.getInstance(ipaddress);
				mibInfo.setCommunity(roCommunity);
				mibInfo.setOidList(SnmpIfOctet.IF_OUT_OCTETS, nodewatchinfo
						.getSnmpPeriod(), "0", "");

				// Listɓo^
				ListQueueStatisticsMibControl.getInstance()
						.setStatisticsMibGetNode(ipaddress, mibInfo);
			}

			if (snmpLevel == SnmpPreference.SNMP_LEVEL3) {
				// net-snmp CPU MIB̎Threado^
				StatisticsMibInfo mibInfo = StatisticsMibInfo
						.getInstance(ipaddress);
				mibInfo.setNodeName(nodeInfo.getNodename());
				mibInfo.setVersion(version);
				mibInfo.setCommunity(roCommunity);

				mibInfo.setOidList(NetSnmpOid.LALOAD, nodewatchinfo
						.getSnmpPeriod(), "0", "");

				ListQueueStatisticsMibControl.getInstance()
						.setStatisticsMibGetNode(ipaddress, mibInfo);
			}

			if (snmpLevel == SnmpPreference.SNMP_LEVEL4) {
				// net-snmp Disk MIB̎Threado^
				StatisticsMibInfo mibInfo = StatisticsMibInfo
						.getInstance(ipaddress);
				mibInfo.setNodeName(nodeInfo.getNodename());
				mibInfo.setVersion(version);

				mibInfo.setCommunity(roCommunity);
				mibInfo.setOidList(NetSnmpOid.DSK_TOTAL, nodewatchinfo
						.getSnmpPeriod(), "0", "");
				ListQueueStatisticsMibControl.getInstance()
						.setStatisticsMibGetNode(ipaddress, mibInfo);
				mibInfo = StatisticsMibInfo.getInstance(ipaddress);
				mibInfo.setCommunity(roCommunity);
				mibInfo.setOidList(NetSnmpOid.DSK_AVAIL, nodewatchinfo
						.getSnmpPeriod(), "0", "");
				ListQueueStatisticsMibControl.getInstance()
						.setStatisticsMibGetNode(ipaddress, mibInfo);
				mibInfo = StatisticsMibInfo.getInstance(ipaddress);
				mibInfo.setCommunity(roCommunity);
				mibInfo.setOidList(NetSnmpOid.DSK_USED, nodewatchinfo
						.getSnmpPeriod(), "0", "");
				ListQueueStatisticsMibControl.getInstance()
						.setStatisticsMibGetNode(ipaddress, mibInfo);
			}
		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static NodeEdit getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final NodeEdit RESOURCE = new NodeEdit();
	}
}
