/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodemaneger.map;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableMapLink;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.nodecontrol.NodeEdit;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import netjfwatcher.engine.view.editorpart.ping.NodePingMenu;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;


/**
 * m[hMap ViewCanvasPopUpj[NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapViewPopUpMenu {
    /** Loadj[ */
    protected static String LOAD_MENU = "Load";

    /** Savej[ */
    protected static String SAVE_MENU = "Save";

    /** Linkj[ */
    protected static String LINK_MENU = "Link";

    /* MO */
    private static Logger logger;

    /** Display */
    protected Display display;

    /** m[hMap Canvas */
    protected Canvas canvas;

    /** PopUpj[ */
    protected Menu popUpMenu;

    /** PopUpj[ m[hViewj[Item */
    protected MenuItem nodeViewMenuItem;

    /** PopUpj[ m[hAlarmj[Item */
    protected MenuItem nodeAlarmMenuItem;

    /** PopUpj[ m[hSNMPj[Item */
    protected MenuItem nodeSnmpMenuItem;

    /** PopUpj[ m[hSNMPvj[Item */
    protected MenuItem nodeSnmpStatisticsSetMenuItem;

    /** m[hMap View Draw */
    protected NodeMapViewDraw mapDraw;

    /** m[hMap񃊃Xg */
    protected ArrayList<NodeMapInfo> nodeMapNodeInfoList = new ArrayList<NodeMapInfo>();

    /** m[hMap Link񃊃Xg */
    protected NodeMapLinkInformation nodMapLinkInformationList;

    /** 摜肷邽߂PluginResource bundle */
    protected Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /** m[hʂɑΉm[hIcon Imagei[Map */
    protected HashMap nodeIconImageMap = new HashMap();

    /** \[X񂩂琶m[hIcon Imagei[z */
    protected Image[] nodeImage = null;

    /** Xe[^XC}l[W */
    protected SubStatusLineManager statusLineManager;

    /** m[hMap View}EXXi[ */
    protected NodeMapViewMouseListener mouseListener;

    /**
     * m[hMap ViewCanvasPopUpj[NXCX^X
     * ܂A
     *
     * @param display Display
     * @param canvas Canvas
     * @param mapDraw m[hMap`NXCX^X
     * @param mouseListener }EXXi[NXCX^X
     * @param statusLineManager Xe[^XC}l[W
     */
    public NodeMapViewPopUpMenu(
        Display display, Canvas canvas, NodeMapViewDraw mapDraw,
        NodeMapViewMouseListener mouseListener,
        SubStatusLineManager statusLineManager) {
        logger = Logger.getLogger(this.getClass().getName());
        this.display = display;
        this.canvas = canvas;
        this.mapDraw = mapDraw;
        this.statusLineManager = statusLineManager;
        this.mouseListener = mouseListener;
    }

    /**
     * PopUpj[Zbg܂B
     *
     * @param parent Composite
     */
    public void setPopUpMenu(Composite parent) {
        /* popUpj[Zbg */
        popUpMenu = new Menu(parent.getShell(), SWT.POP_UP);
        canvas.setMenu(popUpMenu);

        /* Load */
        MenuItem menuItemLoad = new MenuItem(popUpMenu, SWT.PUSH);
        menuItemLoad.setText(LOAD_MENU);
        menuItemLoad.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    loadNodeMap();
                }
            });

        /*
         * m[hMap Save
         */
        MenuItem menuItemSave = new MenuItem(popUpMenu, SWT.PUSH);
        menuItemSave.setText(SAVE_MENU);

        /*
         * m[hMap popupj[łSaveI
         */
        menuItemSave.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    saveNodeMap();
                }
            });

        /*
         * Linkj[
         */
        MenuItem menuItemLink = new MenuItem(popUpMenu, SWT.CHECK);
        menuItemLink.setText(LINK_MENU);

        if (mouseListener.isLineSelected()) {
            menuItemLink.setSelection(true);
        } else {
            menuItemLink.setSelection(false);
        }

        /*
         * Linkj[I
         */
        menuItemLink.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    /*
                            * LinktO(Link`惂[hm[hIconړ
                            * [h)𔽓]
                            */
                    if (mouseListener.isLineSelected()) {
                        mouseListener.setLineSelected(false);
                    } else {
                        mouseListener.setLineSelected(true);
                    }
                }
            });
    }

    /**
     * m[hMap View[hĕ`悵܂B
     *
     */
    public void loadNodeMap() {
        getNodeMapLink(true);

        ArrayList nodeList = getNodeInfoListMapView(true);
        createNodeMapInfo(nodeList);

        mapDraw.redraw(nodeMapNodeInfoList, nodMapLinkInformationList);

        setStatusLine();
    }

    /*
     * m[hMap ViewZ[u܂B
     *
     */
    private void saveNodeMap() {
        for (int i = 0; i < nodeMapNodeInfoList.size(); i++) {
            NodeMapInfo nodeMapInfo = (NodeMapInfo) nodeMapNodeInfoList.get(i);
            NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();

            NodeEdit editNodeInstance = NodeEdit.getInstance();

            try {
                editNodeInstance.editNodeInfo(nodeInfo);
            } catch (DatabaseConnectionException e1) {
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Abort Node Map save error", e1.getMessage());
                logger.warning("Abort Node Map save error " + e1.getMessage());
                shell.dispose();

                return;
            } catch (SQLException e1) {
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Node List import error", e1.getMessage());
                logger.warning("Node List import error " + e1.getMessage());
                shell.dispose();

                return;
            }
        }

        if (nodMapLinkInformationList == null) {
            return;
        }

        DBTableMapLink nodeMapLinkDBTable = new DBTableMapLink();

        try {
            nodeMapLinkDBTable.updateNodeMapLink(
                nodMapLinkInformationList, true);
        } catch (SQLException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } catch (DatabaseConnectionException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
    }

    /**
     * m[hĎ񃊃Xgm[hIcon imageAIconTCYA
     * m[hWZbg܂B
     *
     * @param nodeList m[hĎ񃊃Xg
     */
    protected void createNodeMapInfo(ArrayList nodeList) {
        nodeImage = new Image[nodeList.size()];

        nodeMapNodeInfoList.clear();

        for (int i = 0; i < nodeList.size(); i++) {
            NodeInformation nodeInfo = (NodeInformation) nodeList.get(i);
            nodeImage[i] = createNodeIconImage(nodeInfo.getNodeKind());

            /* m[hMap`ɂm[h */
            NodeMapInfo nodeMapinfo = new NodeMapInfo();
            int x = 0;
            int y = 0;
            x = (int) Float.parseFloat(nodeInfo.getNodeX());
            y = (int) Float.parseFloat(nodeInfo.getNodeY());
            nodeMapinfo.setNodeIconImage(nodeImage[i]);
            nodeMapinfo.setX(x);
            nodeMapinfo.setY(y);
            nodeMapinfo.setNodeInfo(nodeInfo);
            nodeMapinfo.setHeight(nodeImage[i].getBounds().height);
            nodeMapinfo.setWidth(nodeImage[i].getBounds().width);

            /* m[hMap`ɂm[hXgɊi[ */
            nodeMapNodeInfoList.add(nodeMapinfo);
        }
    }

    /**
     * m[hʂm[hIcon image𐶐ĕԂ܂B
     *
     * @param nodeKind m[h
     * @return nodeIconImage m[hIcon image
     */
    protected Image createNodeIconImage(String nodeKind) {
        /* m[hʂɑΉm[hIconC[Wt@C
         * LqXMLt@CList𐶐Am[hIcon
         * C[Wt@C擾
         */
        String nodeIconFileName =
            MediaResource.getInstance().getNodeIconFullFileName(nodeKind);
        Image nodeIconImage = null;

        if (!nodeIconImageMap.containsKey(nodeIconFileName)) {
            URL url = null;
            url = bundle.getEntry(nodeIconFileName);

            if (url == null) {
                /* Icon\[Xt@CȂꍇMO̎ */
                logger.severe("Not found icon file : " + nodeIconFileName);
            } else {
                try {
                    /* m[hIconC[W */
                    nodeIconImage = new Image(display, url.openStream());

                    /* m[hIconC[WMapɊi[ */
                    nodeIconImageMap.put(nodeIconFileName, nodeIconImage);
                } catch (IOException e) {
                    logger.warning(
                        "Abort create image " + e.getMessage() + " for "
                        + nodeIconFileName);
                    e.printStackTrace();
                }
            }
        } else {
            nodeIconImage = (Image) nodeIconImageMap.get(nodeIconFileName);
        }

        return nodeIconImage;
    }

    /**
     * m[hʃj[ƂāAm[hIPopUpj[
     * m[hIj[ǉ܂B
     *
     * @param nodeI m[hĎ
     */
    protected void setNodeMenu(final NodeInformation nodeI) {
        /* m[h\`\j[ */
        nodeViewMenuItem = new MenuItem(popUpMenu, SWT.PUSH);
        nodeViewMenuItem.setText(MenuPreference.NODE_CONFIG_VIEW);

        NodeMapMenuNodeConfig nodeConfig =
            new NodeMapMenuNodeConfig(nodeI, false);
        nodeViewMenuItem.addSelectionListener(nodeConfig);

        /* m[hAlarm\j[ */
        nodeAlarmMenuItem = new MenuItem(popUpMenu, SWT.PUSH);
        nodeAlarmMenuItem.setText(MenuPreference.NODE_ALARM_VIEW);

        NodeMapMenuNodeAlarm nodeAlarm = new NodeMapMenuNodeAlarm(nodeI, false);
        nodeAlarmMenuItem.addSelectionListener(nodeAlarm);

        /* m[hSNMP\j[ */
        nodeSnmpMenuItem = new MenuItem(popUpMenu, SWT.PUSH);
        nodeSnmpMenuItem.setText(MenuPreference.NODE_SNMP_VIEW);

        NodeMapMenuNodeSnmp nodeSnmp = new NodeMapMenuNodeSnmp(nodeI, false);
        nodeSnmpMenuItem.addSelectionListener(nodeSnmp);

        /* m[hPingf[^\j[ */
        NodePingMenu menuPing = new NodePingMenu();
        menuPing.createPingMenu(popUpMenu, nodeI, false);

        NodeSnmpStatisticsMenu menuSnmpStatistics =
            new NodeSnmpStatisticsMenu();
        menuSnmpStatistics.createSnmpStatisticsMenu(popUpMenu, nodeI, false);

        /* m[hSNMPv̎ݒ胁j[ */
        nodeSnmpStatisticsSetMenuItem = new MenuItem(popUpMenu, SWT.PUSH);
        nodeSnmpStatisticsSetMenuItem.setText(
            MenuPreference.NODE_SNMP_STATISTICS_SET);

        NodeMapMenuNodeSnmpStatisticsSet nodeSnmpStatisticsSet =
            new NodeMapMenuNodeSnmpStatisticsSet(nodeI, false);
        nodeSnmpStatisticsSetMenuItem.addSelectionListener(
            nodeSnmpStatisticsSet);
        
        /* m[h\`j[ */
        nodeViewMenuItem = new MenuItem(popUpMenu, SWT.PUSH);
        nodeViewMenuItem.setText(MenuPreference.NODE_OPERATION_VIEW);

        NodeMapMenuNodeOperation nodeOperaqtion =
            new NodeMapMenuNodeOperation(nodeI, false);
        nodeViewMenuItem.addSelectionListener(nodeOperaqtion);
    }

    /**
     * m[hĎ񃊃Xgf[^x[X擾ĕԂ܂B
     *
     * @param isNodeInfo f[^x[Xm[hĎ񃊃Xg
     * 擾邩ۂtO
     * @return m[hĎ񃊃Xg
     */
    protected ArrayList getNodeInfoListMapView(boolean isNodeInfo) {
        if (!isNodeInfo) {
            return new ArrayList();
        }

        DBTableNodeRegister nodeRegisterDBTable =
            DBTableNodeRegister.getInstance();
        ArrayList nodeList = null;

        try {
            nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
        } catch (SQLException e1) {
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Node List import error", e1.getMessage());
            logger.warning("Node List import error" + e1.getMessage());
            shell.dispose();
            e1.printStackTrace();

            return null;
        } catch (Exception e1) {
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Node List import error", e1.getMessage());
            logger.warning("Node List import error" + e1.getMessage());
            shell.dispose();
            e1.printStackTrace();

            return null;
        } finally {
            nodeRegisterDBTable = null;
        }

        return nodeList;
    }

    /*
     * m[hMap Linkf[^x[X擾܂B
     *
     * @param isGetDatabase f[^x[Xm[hMap Link擾邩ۂ
     * tO
     */
    private void getNodeMapLink(boolean isGetDatabase) {
        if (isGetDatabase) {
            DBTableMapLink nodeMapLinkDBTable = new DBTableMapLink();

            try {
                nodMapLinkInformationList = nodeMapLinkDBTable.findAll();
            } catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (DatabaseConnectionException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * Xe[^XC\Zbg܂B
     *
     */
    protected void setStatusLine() {
        if (nodeMapNodeInfoList != null) {
            statusLineManager.setVisible(true);
            statusLineManager.setMessage(
                "Node Map View Node count = " + nodeMapNodeInfoList.size());
        } else {
            statusLineManager.setVisible(false);
        }
    }

    /**
     * m[hMap񃊃XgԂ܂B
     *
     * @return nodeMapNodeInfoList m[hMap񃊃Xg
     */
    public ArrayList getNodeMapNodeInfoList() {
        return nodeMapNodeInfoList;
    }

    /**
     * m[hMap Link񃊃XgԂ܂B
     *
     * @return nodMapLinkInformationList m[hMap Link񃊃Xg
     */
    public NodeMapLinkInformation getNodMapLinkInformationList() {
        return nodMapLinkInformationList;
    }

    /*
     *  (non-Javadoc)
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        /* m[hIcon imagej */
        Map list = nodeIconImageMap;
        Iterator it = null;

        for (it = list.keySet().iterator(); it.hasNext();) {
            String key = (String) it.next();
            Image nodeIconImage = (Image) list.get(key);

            if (nodeIconImage != null) {
                nodeIconImage.dispose();
            }
        }

        if (popUpMenu != null) {
            popUpMenu.dispose();
        }

        if (nodeImage != null) {
            for (int i = 0; i < nodeImage.length; i++) {
                if (nodeImage[i] != null) {
                    nodeImage[i].dispose();
                }
            }
        }
    }
}
