/*
 * Created on 2007/01/30
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.trap.AlarmTrapResourceFileParse;
import netjfwatcher.snmpmanager.preferences.AbstractSnmpPreferencePage;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.jdom.Document;

public class AlarmSnmpTrapPreferencePage extends AbstractSnmpPreferencePage {

	public static final String TRAP_FLAG_TRUE = "true";

	public static final String TRAP_FLAG_FALSE = "false";

	private static final int TEXT_WIDTH = 200;

	/* Combo */
	private static final int COMBO_WIDTH = 120;

	private static final int HORIZONTAL_SPAN2 = 2;

	private static final int HORIZONTAL_SPAN3 = 3;

	private Button alarmTrapButton;

	private Text destinationAddressText;

	private Combo alarmLevelCombo;

	/* MO */
	private static Logger logger;

	public void init(IWorkbench workbench) {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * Rec𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 * @return Control
	 */
	protected Control createContents(Composite parent) {
		/* TextwiFZbg */
		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);

		/*
		 * eCompositezueLayout ieCompositec1ɔzuj
		 */
		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);

		GridData gridData = null;

		Composite composite0 = new Composite(parent, SWT.NONE);

		/* ep[c3Ŕzu */
		GridLayout gridLayoutV3AgentProp = new GridLayout(3, false);
		composite0.setLayout(gridLayoutV3AgentProp);
		composite0.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));

		alarmTrapButton = new Button(composite0, SWT.CHECK);
		alarmTrapButton.setText("Alarm Trap");

		Label label = new Label(composite0, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("Trap Server Address");
		label.setLayoutData(new GridData());
		destinationAddressText = new Text(composite0, SWT.BORDER);
		destinationAddressText.setText("");

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		destinationAddressText.setBackground(textBackColor);
		destinationAddressText.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite0, SWT.NONE);
		label.setText("Alarm level filter");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmLevelCombo = new Combo(composite0, SWT.BORDER | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COMBO_WIDTH;
		alarmLevelCombo.setLayoutData(gridData);
		alarmLevelCombo.add(AlarmFilterPreferencePage.ALARM_LEVEL_INFO);
		alarmLevelCombo.add(AlarmFilterPreferencePage.ALARM_LEVEL_WARNING);
		alarmLevelCombo.add(AlarmFilterPreferencePage.ALARM_LEVEL_ERROR);

		alarmLevelCombo.select(0);

		label = new Label(composite0, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		Composite entryTable = new Composite(parent, SWT.NULL);
		entryTable.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		setSelectionListener();

		setText();

		return entryTable;
	}

	private void setText() {
		String forwardFlag = AlarmTrapResourceFileParse.getInstance()
				.getAlarmTrapFlag();
		if (forwardFlag.equals(TRAP_FLAG_TRUE)) {
			alarmTrapButton.setSelection(true);
		} else {
			alarmTrapButton.setSelection(false);
		}
		String forwardAddress = AlarmTrapResourceFileParse.getInstance()
				.getServerAddress();
		destinationAddressText.setText(forwardAddress);

		if (alarmTrapButton.getSelection()) {
			destinationAddressText.setEnabled(true);

		} else {
			destinationAddressText.setEnabled(false);

		}

	}

	private void setSelectionListener() {

		alarmTrapButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				if (alarmTrapButton.getSelection()) {
					destinationAddressText.setEnabled(true);

				} else {
					destinationAddressText.setEnabled(false);

				}

			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	protected void performDefaults() {
		setText();
	}

	public boolean performOk() {

		String trapFlag = TRAP_FLAG_TRUE;
		if (!alarmTrapButton.getSelection()) {
			trapFlag = TRAP_FLAG_FALSE;
		}
		String trapAddress = "";

		if (trapFlag.equals(TRAP_FLAG_TRUE)) {
			trapAddress = destinationAddressText.getText();
			String localHostAddress = "";
			try {
				InetAddress host = InetAddress.getByName(trapAddress);
				trapAddress = host.getHostAddress();
				localHostAddress = InetAddress.getLocalHost().getHostAddress();
			} catch (UnknownHostException e2) {
				MessageDialog
						.openError(getShell(), "Error", "UnknownHostException"
								+ " IP Address = " + trapAddress);
				destinationAddressText.setFocus();

				return false;
			}

			if ((trapAddress == null) || trapAddress.equals("")
					|| trapAddress.equals("127.0.0.1")
					|| trapAddress.equals(localHostAddress)) {
				MessageDialog.openError(getShell().getShell(), "Error",
						"Server IP Address deny localhost and 127.0.0.1.");
				destinationAddressText.setFocus();

				return false;
			}
		}
		String trapLevel = alarmLevelCombo.getText();
		saveAlarmTrapInfo(trapFlag, trapAddress, trapLevel);
		return super.performOk();
	}

	private void saveAlarmTrapInfo(String trapFlag, String trapAddress,
			String trapLevel) {
		// Document
		Document dom = null;

		// t@Co̓obt@
		BufferedWriter bufWriter = null;

		dom = this.updateAlarmTrapResource(trapFlag, trapAddress, trapLevel);

		if (dom == null) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error",
					"Abort save Alarm Trap config");
			shell.dispose();

			return;
		}

		bufWriter = AlarmTrapResourceFileParse.getInstance()
				.getResourceFileWriter();

		// XMLt@Co
		this.outputXMLFile(bufWriter, dom);

		if (bufWriter != null) {
			try {
				bufWriter.close();
			} catch (IOException e) {
				logger
						.warning("Abort close BufferedWriter for Alarm Trap resource : "
								+ e.getMessage());
				e.printStackTrace();
			}
		}

		// FileɃCgɃCX^XXV
		AlarmTrapResourceFileParse.getInstance().setTrapForwardInfo();
	}

	private Document updateAlarmTrapResource(String trapFlag,
			String trapAddress, String trapLevel) {

		Document dom = AlarmTrapResourceFileParse.getInstance().updateDocument(
				trapFlag, trapAddress, trapLevel);

		return dom;
	}
}
