/*
 * Created on 2004/06/05
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.resource;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

import netjfwatcher.engine.filepreference.FilePreference;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;



/**
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class CommandPlatform {
    /*  */
    private static Logger logger = null;

    /*  */
    private String pingCommand;

    /*  */
    private String pingResponce;

    // RXgN^privateɂĕspӂɒڃRXgN^Ăяoh~
    private CommandPlatform() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static CommandPlatform getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     *
     *
     */
    public void parseCommandXML() {
        String osName = System.getProperty("os.name");

        String[] lowerOSName = osName.toLowerCase().split(" ");
        Document doc = getDocument();

        try {
            // rootvfo
            Element root = doc.getRootElement();

            // ̃^Ovfꍇ
            Element pingEl = root.getChild("ping");

            if ((lowerOSName.length > 1) && (lowerOSName[0] == "windows")) {
                pingCommand =
                    (pingEl.getChild(lowerOSName[0])).getChild("command")
                     .getAttributeValue("value");
                pingResponce =
                    (pingEl.getChild(lowerOSName[0])).getChild("responce")
                     .getAttributeValue("value");
            } else {
                pingCommand =
                    (pingEl.getChild("linux")).getChild("command")
                     .getAttributeValue("value");
                pingResponce =
                    (pingEl.getChild("linux")).getChild("responce")
                     .getAttributeValue("value");
            }
        } catch (NullPointerException e) {
            e.printStackTrace();
        }

        System.out.println("OS Name : " + lowerOSName[0]);
        System.out.println("ping_command : " + pingCommand);
        System.out.println("ping_responce : " + pingResponce);
    }

    /**
     * DocumentԂ܂B
     *
     * @return doc Document
     */
    private Document getDocument() {
        Document doc = null;

        try {
            /* bZ[W\[Xt@C */
            ClassLoader loader = SystemResourceFileParse.class.getClassLoader();
            URL url = loader.getResource(FilePreference.COMMAND_XML_FILE);

            if (url == null) {
                /* bZ[W\[Xt@CȂꍇMO̎ */
                logger.severe(
                    "Command XML file : " + FilePreference.COMMAND_XML_FILE);

                return null;
            }

            SAXBuilder builder = new SAXBuilder();

            if (builder != null) {
                doc = builder.build(url.openStream());
            }
        } catch (JDOMException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (NullPointerException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

        return doc;
    }

    /**
     *
     *
     * @return getPingCommand
     */
    public String getPingCommand() {
        return pingCommand;
    }

    /**
     *
     *
     * @return pingResponce
     */
    public String getPingResponce() {
        return pingResponce;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final CommandPlatform RESOURCE = new CommandPlatform();
    }
}
