/*
 * Created on 2004/10/18
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.resource;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.logging.Logger;

import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;

import netjfwatcher.engine.filepreference.FilePreference;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.UsmLocalizeKey;
import netjfwatcher.snmp.snmpv3.UsmUserAgentManager;
import netjfwatcher.snmp.snmpv3.UsmUserManager;

import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;



/**
 * SNMP V3 Agent\`XMLt@Cǂݍ݉͂NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpV3AgentConfigFileParse {
    // Tag

    /** Conf ^O */
    public static final String CONF = "conf";

    /** ڑzXg ^O */
    public static final String ALLOW_HOST = "allow-host";

    /** SNMP ReadR~jeB ^O */
    public static final String READ_COMMUNITY = "read-Community";

    /** SNMP WriteR~jeB ^O */
    public static final String WRITE_COMMUNITY = "write-Community";

    /** SNMP V3 ^O */
    public static final String SNMPV3 = "snmpV3";

    /** SNMP EngineID ^O */
    public static final String SNMP_ENGINE_ID = "snmpEngineID";

    /** SNMP EngineBoots ^O */
    public static final String SNMP_ENGINE_BOOTS = "snmpEngineBoots";

    /** [U ^O */
    public static final String USER_NAME = "userName";

    /** AuthPriv ^O */
    public static final String AUTH_PRIV = "authPriv";

    /** AuthPassPhrase ^O */
    public static final String AUTH_PROTOCOL = "authProtocol";

    /** ^O */
    public static final String AUTH_PASSPHRSE = "authPassPhrase";

    /** PrivProtocol ^O */
    public static final String PRIV_PROTOCOL = "privProtocol";

    /** PrivPassPhrase ^O */
    public static final String PRIV_PASSPHRSE = "privPassPhrase";

    /** Context ^O */
    public static final String CONTEXT_NAME = "contextName";

    /** \[XXML l^O */
    public static final String XML_FILE_VALUE = "value";

    /* Logging */
    private static Logger logger = null;

    /* SNMP V3 Agent\` */
    private SnmpV3AgentConfigInfo snmpV3AgentConfigInfo;

    /* SNMP Agnet\` */
    private SnmpAgentConfigInfo snmpAgentInfo;

    /**
     *
     * ŏɎwfBNgt@C͂邩GW
     * \[X擾܂B
     * wfBNg擾łȂꍇ́AGW
     * \[X擾܂B
     *
     * @throws Exception SNMP Agent`t@C͂ňُ킪ꍇ
     */
    public SnmpV3AgentConfigFileParse() throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        logger.info(
            "SNMPV3 Agent Config File Parse : "
            + FilePreference.SNMPV3_AGENT_RESOURCE_XML_FILE);

        String allowHost;
        String readCommunity;
        String writeCommunity;
        String snmpEngineID;
        String snmpEngineBoots;
        String userName;
        String authPriv;
        String authProtocol;
        String authPassPhrase;
        String privProtocol;
        String privPassPhrase;
        String contextName;

        Document doc = null;

        // jart@C邩fBNgwt@C擾邩
        // doc = getDocument(RESOURCE_XML_FILE);
        doc = getResourceFileDocumentPath(
                FilePreference.SNMPV3_AGENT_RESOURCE_XML_FILE);

        if (doc == null) {
            logger.severe("Resource File Doc null ");

            return;
        }

        snmpV3AgentConfigInfo = new SnmpV3AgentConfigInfo();
        snmpAgentInfo = new SnmpAgentConfigInfo();

        try {
            // rootvfo
            Element root = doc.getRootElement();

            allowHost =
                (root.getChild(ALLOW_HOST)).getAttributeValue(XML_FILE_VALUE);
            snmpAgentInfo.setAllowHost(allowHost);
            readCommunity =
                (root.getChild(READ_COMMUNITY)).getAttributeValue(
                    XML_FILE_VALUE);
            snmpAgentInfo.setReadCommunity(readCommunity);
            writeCommunity =
                (root.getChild(WRITE_COMMUNITY)).getAttributeValue(
                    XML_FILE_VALUE);
            snmpAgentInfo.setWriteCommunity(writeCommunity);

            Element snmpV3 = root.getChild(SNMPV3);

            // snmpEngineID
            snmpEngineID =
                (snmpV3.getChild(SNMP_ENGINE_ID)).getAttributeValue(
                    XML_FILE_VALUE);
            snmpV3AgentConfigInfo.setSnmpEngineID(snmpEngineID);
            snmpEngineBoots =
                (snmpV3.getChild(SNMP_ENGINE_BOOTS)).getAttributeValue(
                    XML_FILE_VALUE);
            snmpV3AgentConfigInfo.setSnmpEngineBoots(snmpEngineBoots);
            userName =
                (snmpV3.getChild(USER_NAME)).getAttributeValue(XML_FILE_VALUE);
            snmpV3AgentConfigInfo.setUserName(userName);
            authPriv =
                (snmpV3.getChild(AUTH_PRIV)).getAttributeValue(XML_FILE_VALUE);
            snmpV3AgentConfigInfo.setAuthPriv(authPriv);
            authProtocol =
                (snmpV3.getChild(AUTH_PROTOCOL)).getAttributeValue(
                    XML_FILE_VALUE);
            snmpV3AgentConfigInfo.setAuthProtocol(authProtocol);
            authPassPhrase =
                (snmpV3.getChild(AUTH_PASSPHRSE)).getAttributeValue(
                    XML_FILE_VALUE);
            snmpV3AgentConfigInfo.setAuthPassPhrase(authPassPhrase);
            privProtocol =
                (snmpV3.getChild(PRIV_PROTOCOL)).getAttributeValue(
                    XML_FILE_VALUE);
            snmpV3AgentConfigInfo.setPrivProtocol(privProtocol);
            privPassPhrase =
                (snmpV3.getChild(PRIV_PASSPHRSE)).getAttributeValue(
                    XML_FILE_VALUE);
            snmpV3AgentConfigInfo.setPrivPassPhrase(privPassPhrase);
            contextName =
                (snmpV3.getChild(CONTEXT_NAME)).getAttributeValue(
                    XML_FILE_VALUE);
            snmpV3AgentConfigInfo.setContextName(contextName);

            // USMXgɓo^
            // SnmpV3MPSubSystem v3 = new SnmpV3MPSubSystem();
            try {
                // USMXgɓo^
                this.setSnmpV3AgentConfig(snmpV3AgentConfigInfo);
            } catch (SnmpV3ConfigurationException e) {
                // throw e;
                e.printStackTrace();
            }
        } catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    /**
     * SNMP V3\Zbg܂B
     *
     * @param info SNMP V3 Agent\
     * @throws SnmpV3ConfigurationException SNMP V3 Agent\Ɉُ킪ꍇ
     */
    private void setSnmpV3AgentConfig(SnmpV3AgentConfigInfo info)
        throws SnmpV3ConfigurationException {
        // snmpEngineID & snmpEngineBoots
        SnmpEngineID snmpEngineID = new SnmpEngineID(info.getSnmpEngineID());

        // [U}l[W
        UsmUserAgentManager.getInstance().registAgentList(snmpEngineID, info);

        try {
            MessageDigest.getInstance(UsmUserManager.MSG_DIGEST_MD5);
            MessageDigest.getInstance(UsmUserManager.MSG_DIGEST_SHA1);

            Mac.getInstance(UsmLocalizeKey.KEY_GEN_ALGO_HMAC_MD5);
            Mac.getInstance(UsmLocalizeKey.KEY_GEN_ALGO_HMAC_SHA);
            Cipher.getInstance(UsmUserManager.CIPHER_DES);
            SecretKeyFactory.getInstance(UsmUserManager.CIPHER_DES);
        } catch (Throwable e) {
            throw new SnmpV3ConfigurationException(e.toString());
        }
    }

    /**
     * Snmp Agent\Ԃ܂B
     *
     * @return snmpAgentInfo Snmp Agent\
     */
    public SnmpAgentConfigInfo getSnmpAgentResourceInfo() {
        return snmpAgentInfo;
    }

    /**
     * Snmp V3 Agent\Ԃ܂B
     *
     * @return snmpV3AgentConfigInfo Snmp V3 Agent\
     */
    public SnmpV3AgentConfigInfo getSnmpV3AgentResourceInfo() {
        return snmpV3AgentConfigInfo;
    }

    /**
     * wt@CURLԂ܂B
     *
     * @param file t@C
     * @return URL
     */
    public URL getResourceFileURL(String file) {
        /* bZ[W\[Xt@C */
        ClassLoader loader = SystemResourceFileParse.class.getClassLoader();
        URL url = loader.getResource(file);

        if (url == null) {
            /* bZ[W\[Xt@CȂꍇMO̎ */
            logger.info("Resource XML file url : " + url);
        }

        return url;
    }

    /**
     * XMLt@Co͗p̃obt@C^[Ԃ܂B
     *
     * @return bufferedWriter obt@C^[
     */
    public BufferedWriter getResourceFileWriter() {
        File file = new File(FilePreference.SNMPV3_AGENT_RESOURCE_XML_FILE);
        logger.info("Path : " + file.getAbsolutePath());

        if (file == null) {
            return null;
        }

        BufferedWriter bufferedWriter = null;

        try {
            FileWriter fileWriter =
                new FileWriter(FilePreference.SNMPV3_AGENT_RESOURCE_XML_FILE);
            bufferedWriter = new BufferedWriter(fileWriter);
        } catch (IOException e1) {
            e1.printStackTrace();

            return null;
        }

        return bufferedWriter;
    }

    /**
     * wfBNgXMLt@C͂DocumentԂ܂B
     * ijart@ČȂj
     *
     * @param file XMLt@C
     * @return doc Document
     */
    public Document getResourceFileDocumentPath(String file) {
        Document doc = null;

        File f = new File(file);
        // logger.info("Path : " + f.getAbsolutePath());

        if (f == null) {
            return null;
        }

        BufferedReader buffReader = null;

        try {
            FileReader fileReader = new FileReader(file);
            buffReader = new BufferedReader(fileReader);
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();

            return null;
        }

        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(buffReader);
        } catch (JDOMException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (NullPointerException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

        return doc;
    }

    /**
     * \[X񂩂Document𐶐AԂ܂B
     *
     * @param snmpAgentInfo SNMP Agnet\
     * @param snmpV3AgentInfo SNMP V3 Agengt\
     * @return doc Document
     */
    public Document updateDocument(
        final SnmpAgentConfigInfo snmpAgentInfo, final SnmpV3AgentConfigInfo snmpV3AgentInfo) {

        Element confElement = new Element(CONF);
        Document doc = new Document(confElement);

        Element allowHost = new Element(ALLOW_HOST);
        Element readCommunity = new Element(READ_COMMUNITY);
        Element writeCommunity = new Element(WRITE_COMMUNITY);

        Element snmpV3El = new Element(SNMPV3);
        Element snmpEngineIDEl = new Element(SNMP_ENGINE_ID);
        Element snmpEngineBootsEl = new Element(SNMP_ENGINE_BOOTS);
        Element userNameEl = new Element(USER_NAME);

        Element authPrivEl = new Element(AUTH_PRIV);
        Element authProtocolEl = new Element(AUTH_PROTOCOL);
        Element authPassphrseEl = new Element(AUTH_PASSPHRSE);

        Element privProtocolEl = new Element(PRIV_PROTOCOL);
        Element privPassphrseEl = new Element(PRIV_PASSPHRSE);
        Element contextNameEl = new Element(CONTEXT_NAME);

        confElement.addContent(allowHost);
        confElement.addContent(readCommunity);
        confElement.addContent(writeCommunity);
        allowHost.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpAgentInfo.getAllowHost()));
        readCommunity.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpAgentInfo.getReadCommunity()));
        writeCommunity.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpAgentInfo.getWriteCommunity()));

        confElement.addContent(snmpV3El);
        snmpV3El.addContent(snmpEngineIDEl);
        snmpV3El.addContent(snmpEngineBootsEl);
        snmpV3El.addContent(userNameEl);
        snmpV3El.addContent(authPrivEl);
        snmpV3El.addContent(authProtocolEl);
        snmpV3El.addContent(authPassphrseEl);
        snmpV3El.addContent(privProtocolEl);
        snmpV3El.addContent(privPassphrseEl);
        snmpV3El.addContent(contextNameEl);

        snmpEngineIDEl.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getSnmpEngineID()));
        snmpEngineBootsEl.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getSnmpEngineBoots()));
        userNameEl.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getUserName()));
        authPrivEl.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getAuthPriv()));
        authProtocolEl.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getAuthProtocol()));
        authPassphrseEl.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getAuthPassPhrase()));
        privProtocolEl.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getPrivProtocol()));
        privPassphrseEl.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getPrivPassPhrase()));
        contextNameEl.setAttribute(
            new Attribute(XML_FILE_VALUE, snmpV3AgentInfo.getContextName()));

        //@AuthPriv Rg
        snmpV3El.addContent(new Comment("AuthPriv NOAUTH/AUTH/PRIV"));

        //@AuthProtocol Rg
        snmpV3El.addContent(new Comment("AuthProtocol MD5/SHA"));

        return doc;
    }

    /**
     * XMLt@Co͂܂B
     *
     * @param bufWriter obt@C^
     * @param dom Document
     */
    public void outputXMLFile(BufferedWriter bufWriter, Document dom) {
        /*
         * qGgeGg2wAGg
         * ̉sw͂ȂiXMLt@CŌXsĂ邽߁j
         */
        // XMLOutputter outputter = new XMLOutputter("  ", true);
        XMLOutputter outputter =
            XMLOutputterFormat.getInstance().getXMLOutputterFormat();

        FileWriter writer = null;

        try {
            // outputter.output(dom, System.out);
            outputter.output(dom, bufWriter);
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }
}
