/*
 * Created on 2004/09/30
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


/**
 * SNMPV3}l[WƂAgentSNMPV3ێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpV3ManagerConfigInfo implements Serializable {
    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = -3466542271137047343L;

    /*
     * AgentEngineIDABootsySysup TimewK()ς݂ۂ
     * false:
     * true :ς
     */
    private boolean isLearned = false;

    /* EngineID */
    private String snmpEngineID;

    /* EngineBoots */
    private String snmpEngineBoots;

    /* Engine SysupTime */
    private String snmpEngineTime;

    /* Agent Address */
    private String ipAddress;

    /* User List */
    private List userList = Collections.synchronizedList(new ArrayList());

    /* Context Name */
    private String contextName;

    /*  */
    private String asn1BerZeroPadding;

    /**
     * Engine BootsԂ܂B
     *
     * @return snmpEngineBoots snmpEngineBoots
     */
    public String getSnmpEngineBoots() {
        return snmpEngineBoots;
    }

    /**
     * Engine IDԂ܂B
     *
     * @return snmpEngineID snmpEngineID
     */
    public String getSnmpEngineID() {
        return snmpEngineID;
    }

    /**
     * Engine SysupTimeԂ܂B
     *
     * @return snmpEngineTime snmpEngineTime
     */
    public String getSnmpEngineTime() {
        return snmpEngineTime;
    }

    /**
     * UserXgԂ܂
     *
     * @return userList UserXg
     */
    public List getUserList() {
        return userList;
    }

    /**
     * EngineBootsZbg܂B
     *
     * @param string EngineBoots
     */
    public void setSnmpEngineBoots(String string) {
        snmpEngineBoots = string;
    }

    /**
     * EngineIDZbg܂B
     *
     * @param string EngineID
     */
    public void setSnmpEngineID(String string) {
        snmpEngineID = string;
    }

    /**
     * Engine SysupTimeZbg܂B
     *
     * @param string Engine SysupTime
     */
    public void setSnmpEngineTime(String string) {
        snmpEngineTime = string;
    }

    /**
     * UserXgZbg܂B
     *
     * @param list UserXg
     */
    public void setUserList(ArrayList list) {
        userList = list;
    }

    /**
     * Snmp V3ǗZbg܂B
     *
     * @param userInfo Snmp V3Ǘ
     */
    public void addUserList(SnmpV3ManagerUserConfigInfo userInfo) {
        userList.add(userInfo);
    }

    /**
     * ContextԂ܂B
     *
     * @return contextName Context
     */
    public String getContextName() {
        return contextName;
    }

    /**
     * ContextZbg܂B
     *
     * @param string Context
     */
    public void setContextName(String string) {
        contextName = string;
    }

    /**
     * IP AddressԂ܂B
     *
     * @return ipAddress IP Address
     */
    public String getIpAddress() {
        return ipAddress;
    }

    /**
     * IP AddressZbg܂B
     *
     * @param string IP Address
     */
    public void setIpAddress(String string) {
        ipAddress = string;
    }

    /**
     * AgentEngineIDABootsySysup TimewK()ς݂ۂ
     * Ԃ܂B
     * false:
     * true :ς
     *
     * @return isLearned AgentEngineIDABootsySysup TimewK
     * ()ς݂ۂ
     * false:
     * true :ς
     *
     */
    public boolean isLearned() {
        return isLearned;
    }

    /**
     * AgentEngineIDABootsySysup TimewK()ς݂wK
     * ݒ肵܂B
     * false:
     * true :ς
     *
     * @param learneFlag AgentEngineIDABootsySysup TimewK()ς݃tO
     * ifalse:Atrue :ς݁j
     */
    public void setLearned(boolean learneFlag) {
        isLearned = learneFlag;
    }

    /**
     * ASN.1 [pfBOԂ܂B
     *
     * @return ASN.1 [pfBO
     */
    public String getAsn1BerZeroPadding() {
        return asn1BerZeroPadding;
    }

    /**
     * ASN.1 [pfBOZbg܂B
     *
     * @param string ASN.1 [pfBO
     */
    public void setAsn1BerZeroPadding(String string) {
        asn1BerZeroPadding = string;
    }
}
