/*
 * Created on 2004/08/06
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;


/**
 * IɃm[hHTTPĎ삷m[hĎ񃊃Xgm[hIPAhX
 * L[ƂĕێAHTTPĎsThread𐧌䂷邽߂̃Xg
 * ێNXłB
 * ʃXbhł̃Xg̃JE^PbŃJEg_E0([)
 * ȂƎsL[Push܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            | |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                  +----------+  +----- Exec
 *  ŃXgZbgj
 *
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ListQueueHTTPControl {
    /* IPAhXKeyƂHTTPĎێMap */
    private Map<String, NodeWatchInfo> httpHashMap;

    /*
     * IPAhXL[Ƃm[hĎێHashMap𐶐
     * ܂B
     *
     */
    private ListQueueHTTPControl() {
        httpHashMap = Collections.synchronizedMap(new LinkedHashMap<String, NodeWatchInfo>());
    }

    /**
     * w肳ꂽIPAhXL[ƂāAm[hĎMapɊi[
     * ܂B
     * ̎AHTTPĎJE^ɃZbg܂B
     *
     * @param ip m[hIPAhX
     * @param nodeInfo m[hĎ
     */
    public void setHTTPNode(String ip, NodeWatchInfo nodeInfo) {
        // HTTP GetJE^Zbg
        /* System.out.println(
            "nodeInfo.getHttp_period() : " + nodeInfo.getHttpPeriod());
        */
        nodeInfo.setCountHttpPeriod(nodeInfo.getHttpPeriod());

        // Xgɒǉ
        httpHashMap.put(ip, nodeInfo);
    }

    /**
     * w肳ꂽIPAhXɑΉm[hĎԂ܂B
     *
     * @param ip m[hIPAhX
     * @return m[hĎ
     */
    public NodeWatchInfo getHTTPNode(String ip) {
        return (NodeWatchInfo) httpHashMap.get(ip);
    }

    /**
     * wm[hIPAhXHTTPĎ폜܂B
     *
     * @param ip m[hĎ
     */
    public void removeHTTPNode(String ip) {
        httpHashMap.remove(ip);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ListQueueHTTPControl getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /**
     * m[hHTTPĎێMapԂ܂B
     *
     * @return m[hHTTPĎێMap
     */
    public Map getHTTPHashMap() {
        return httpHashMap;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final ListQueueHTTPControl DBPOOL = new ListQueueHTTPControl();
    }
}
