/*
 * Created on 2006/12/27
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;


public final class QueueForDatabseWatch extends AbstractQueueForProtocolCheck {
    /*
     * DatabaseĎCxgL[Ƃĕێ郊Xg
     */
    private List<NodeWatchInfo> list;

    /*
     * DatabaseĎCxgL[ƂĊǗNXCX^X𐶐܂B
     *
     */
    private QueueForDatabseWatch() {
        list = Collections.synchronizedList(new LinkedList<NodeWatchInfo>());
    }

    /**
     * m[hĎZbg܂B
     *
     * @param info m[hĎ
     */
    public synchronized void pushQue(NodeWatchInfo info) {
        if (!isPause) {
            checkQueueSize(list, info.getIpaddress());
            list.add(list.size(), info);
        }
    }

    /**
     * m[h DatabaseĎԂ܂B
     *
     * @return info m[hĎ
     */
    public synchronized NodeWatchInfo popQueue() {
        NodeWatchInfo info = null;

        if (list.size() > 0) {
            if (!isPause) {
                info = (NodeWatchInfo) list.get(0);
            }

            list.remove(0);
        }

        return info;
    }

    /**
     * DatabaseĎCxgL[Ԃ܂B
     *
     * @return list DatabaseĎCxgL[
     */
    public List getDatabaseWatchQueueList() {
        return list;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static QueueForDatabseWatch getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final QueueForDatabseWatch DBPOOL = new QueueForDatabseWatch();
    }
}
