/*
 * Created on 2004/08/06
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * HTTPĎCxgL[ƂĊǗNXłB
 * HTTPĎCxg̃L[ɓo^AHTTPĎThraed
 * ̂̈ThreadL[̃CxgǂݏoĎs܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version1.0
 */
public final class QueueForHTTP extends AbstractQueueForProtocolCheck {
    /*
     * HTTPĎCxgL[Ƃĕێ郊Xg
     */
    private List<NodeWatchInfo> list;

    /*
     * HTTPĎCxgL[ƂĊǗNXCX^X𐶐܂B
     *
     */
    private QueueForHTTP() {
        list = Collections.synchronizedList(new LinkedList<NodeWatchInfo>());
    }

    /**
     * m[hĎZbg܂B
     *
     * @param info m[hĎ
     */
    public synchronized void pushQue(NodeWatchInfo info) {
        if (!isPause) {
            checkQueueSize(list, info.getIpaddress());
            list.add(list.size(), info);
        }
    }

    /**
     * m[hĎԂ܂B
     *
     * @return info m[hĎ
     */
    public synchronized NodeWatchInfo popQueue() {
        NodeWatchInfo info = null;

        if (list.size() > 0) {
            if (!isPause) {
                info = (NodeWatchInfo) list.get(0);
            }

            list.remove(0);
        }

        return info;
    }

    /**
     * HTTPĎCxgL[Ԃ܂B
     *
     * @return list HTTPĎCxgL[
     */
    public List getHttpQueueList() {
        return list;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static QueueForHTTP getInstance() {
        return SingletonAboutMessage.INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final QueueForHTTP INSTANCE = new QueueForHTTP();
    }
}
