/*
 * Created on 2004/05/09
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.engine.nodecontrol.NodeKind;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.server.protocol.snmp.SnmpInterfacesMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpPrintMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpSystemMibGet;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;

/**
 * sL[ǂݏoāA񂪂΂ɊSystem MIBy Interface MIB̎s܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 * 
 */
public class ThreadQueueCheckDefaultSnmpMibGet implements Runnable {
	/* Thread sleep */
	private static final int WAIT_SLEEP_TIME = 1000;

	/* MO */
	private static Logger logger;

	/**
	 * System MIByInterface MIB̎ThreadNXCX^X ܂B
	 */
	public ThreadQueueCheckDefaultSnmpMibGet() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * IɃL[`FbNAL[Ƀf[^System/ Interface MIB̎s܂B
	 */
	public void run() {
		/* System MIB̎CX^X */
		SnmpSystemMibGet systemMibGetInstance = new SnmpSystemMibGet();

		/* Interface MIB̎CX^X */
		SnmpInterfacesMibGet interfacesMibGetInstance = new SnmpInterfacesMibGet();

		/* Print MIB̎CX^X */
		SnmpPrintMibGet printMibGetInstance = new SnmpPrintMibGet();
		/*
		 * IɃL[`FbN[v
		 */
		while (!Thread.interrupted()) {
			// {SNMP̎搧L[Pop
			NodeWatchInfo infoPopQueue = QueueForDefaultSnmpMib.getInstance()
					.popQueue();
			NodeWatchInfo checkIPAddress = null;

			if (infoPopQueue != null) {
				checkIPAddress = BaseNodeWatchInfoList.getInstance()
						.getNodeWatchInfo(infoPopQueue.getIpaddress());
			}

			// L[Ƀf[^System/Interface MIB̎
			if ((infoPopQueue != null) && (checkIPAddress != null)) {
				String targetIpAddress = infoPopQueue.getIpaddress();

				logger.info("System/Interfaces MIB Get " + "IP Address="
						+ targetIpAddress + " Version="
						+ infoPopQueue.getSnmpVersion());

				try {
					// System MIB̎
					systemMibGetInstance.setSnmpSystemMibGet(targetIpAddress,
							infoPopQueue.getSnmpVersion(), infoPopQueue
									.getSnmpROCommunity());
					systemMibGetInstance.getSystemMIB();

					// Interfaces MIB̎
					interfacesMibGetInstance.setSnmpInterfacesMibGet(
							targetIpAddress, infoPopQueue.getSnmpVersion(),
							infoPopQueue.getSnmpROCommunity());
					interfacesMibGetInstance.getInterfacesMIB();
					if (infoPopQueue.getNodeKind().equals(NodeKind.PRINTER)) {
						logger.info("Print MIB Get " + "IP Address="
								+ targetIpAddress + " Version="
								+ infoPopQueue.getSnmpVersion());
						// Print MIB̎
						printMibGetInstance.setSnmpPrintMibGet(
								targetIpAddress, infoPopQueue.getSnmpVersion(),
								infoPopQueue.getSnmpROCommunity());
						printMibGetInstance.getPrintMIB();
					}
				} catch (UnknownHostException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				} catch (SocketException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				} catch (SnmpMIBGetException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}

				try {
					/* Ďm[hŏI`FbNԍXV */
					LastCheckTimeUpDate updateLastCheckTime = LastCheckTimeUpDate
							.getInstance();
					updateLastCheckTime.updateCheckTime(targetIpAddress);
				} catch (DatabaseConnectionException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}

			try {
				Thread.sleep(WAIT_SLEEP_TIME);
			} catch (InterruptedException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}
	}
}
