/*
 * Created on 2004/08/06
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.logging.Logger;

import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.server.protocol.http.ExecuteHttpCheck;



/**
 * HTTP URL`FbNThreadNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadQueueCheckHTTP implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /**
     * HTTPĎsThreadNXCX^X𐶐܂B
     *
     */
    public ThreadQueueCheckHTTP() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * IɃL[`FbNAL[Ƀf[^HTTPs܂B
     */
    public void run() {
        ExecuteHttpCheck checkURL = new ExecuteHttpCheck();

        //IɃL[`FbN[v
        while (!Thread.interrupted()) {
            /* HTTPL[Popăm[hĎ擾 */
            NodeWatchInfo infoPopQueue = QueueForHTTP.getInstance().popQueue();

            /*
             * Popm[hĎIPAhXYm[hĎ
             * vpeB擾
             */
            NodeWatchInfo checkIPAddressNodeWatchInfo = null;

            if (infoPopQueue != null) {
                checkIPAddressNodeWatchInfo =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        infoPopQueue.getIpaddress());
            }

            // L[Ƀf[^URL `FbNs
            if ((infoPopQueue != null) && (checkIPAddressNodeWatchInfo != null)) {
                if (
                    BusyCheckForHttp.getInstance().getArbitrationExec(
                            infoPopQueue.getIpaddress())) {
                    checkURL.getURL(infoPopQueue.getIpaddress(), infoPopQueue);
                    BusyCheckForHttp.getInstance().release(
                        infoPopQueue.getIpaddress());
                } else {
                    logger.warning(
                        "Busy HTTP IP = " + infoPopQueue.getIpaddress());
                }
            }

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
