/*
 * Created on 2004/05/01
 *
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.logging.Logger;

import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.server.protocol.smtp.ExecuteSMTPCheck;



/**
 * IɃL[`FbNAL[Ƀf[^SMTPĎs
 * ThreadNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadQueueCheckSmtp implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /**
     * SMTPĎsThreadNXCX^X𐶐܂B
     *
     */
    public ThreadQueueCheckSmtp() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * IɃL[`FbNAL[Ƀf[^SMTPĎs
     * ܂B
     */
    public void run() {
        ExecuteSMTPCheck checkSmtp = new ExecuteSMTPCheck();

        //IɃL[`FbN[v
        while (!Thread.interrupted()) {
            // L[Pop
            NodeWatchInfo info = QueueForSmtp.getInstance().popQueue();
            NodeWatchInfo checkIPAddress = null;

            if (info != null) {
                checkIPAddress =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        info.getIpaddress());
            }

            // L[Ƀf[^URL `FbNs
            if ((info != null) && (checkIPAddress != null)) {
                if (
                    BusyCheckForSmtp.getInstance().getArbitrationExec(
                            info.getIpaddress())) {
                    checkSmtp.checkSmtp(info);
                    BusyCheckForSmtp.getInstance().release(info.getIpaddress());
                } else {
                    logger.warning("Busy Smtp IP = " + info.getIpaddress());
                }
            }

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
