/*
 * Created on 2006/12/27
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmMessageResource;
import netjfwatcher.engine.alarm.AlarmRecovery;

public class DatabaseCheck {

	/* JDBC Driver ̓o^ */
	private static final int PHASE1_NO = 0;

	/* f[^x[X RlNV */
	private static final int PHASE2_NO = 1;

	/* f[^x[X SQLs */
	private static final int PHASE3_NO = 2;

	/* eXgtF[Y */
	private static final int PHASE_COUNT = 3;

	// MO
	private static Logger logger = null;

	/* f[^x[XғeXgtF[YOKDescription */
	private static final String PHASE1_OK_DESCRIPTION = "Phase 1 OK";

	private static final String PHASE2_OK_DESCRIPTION = "Phase 2 OK";

	private static final String PHASE3_OK_DESCRIPTION = "Phase 3 OK";

	private final String ipAddress;

	/* f[^x[X */
	private final String databaseName;

	/* f[^x[XeXgtF[Yʊi[z */
	private String[] checkResult = new String[PHASE_COUNT];

	/**
	 * f[^x[XeXgsCX^X𐶐܂B
	 * 
	 * @param paraDatabaseName
	 *            f[^x[X
	 */
	public DatabaseCheck(final String ipAddress, final String paraDatabaseName) {
		logger = Logger.getLogger(this.getClass().getName());
		this.ipAddress = ipAddress;
		this.databaseName = paraDatabaseName;
	}

	public String[] checkDatabase(final String jdbcdriver, final String url,
			final String username, final String password,
			final String checkSQL, final boolean isQuery,
			final boolean isDriverCheck, final boolean isTest) throws Exception {
		logger.info("Database Test start : " + databaseName);
		logger.info("jdbcdriver : " + jdbcdriver);
		logger.info("url : " + url);
		logger.info("username : " + username);
		logger.info("password : " + password);
		logger.info("SQL : " + checkSQL);
		checkResult[PHASE1_NO] = "";
		checkResult[PHASE2_NO] = "";
		checkResult[PHASE3_NO] = "";

		/*
		 * JDBC Driver ̓o^`FbN
		 */
		checkResult = checkPhase1(jdbcdriver, isTest);

		if (!checkResult[PHASE1_NO].equals(PHASE1_OK_DESCRIPTION)) {
			return checkResult;
		}

		if (isDriverCheck) {
			return checkResult;
		}
		/*
		 * f[^x[Xւ̃RlNV𐶐eXg
		 */
		checkResult = checkPhase2(url, username, password, isTest);

		if (!checkResult[PHASE2_NO].equals(PHASE2_OK_DESCRIPTION)) {
			return checkResult;
		}

		/*
		 * ODatabaseڑُō񐳏ŏQ ł邩`FbN
		 */
		if (AlarmRecovery.getInstance().isOccurredAlarmId(ipAddress,
				AlarmMessageResource.DATABASE_CONNECTION_ERROR)) {
			/* DatabaseڑZbg */
			AlarmMessageMake message = AlarmMessageMake.getInstance();
			message.setRecoveryDatabaseConnectionError(ipAddress, "URL=" + url);
		}

		/*
		 * SQLseXg
		 */
		checkResult = checkPhase3(url, username, password, checkSQL, isQuery,
				isTest);

		if (!checkResult[PHASE3_NO].equals(PHASE3_OK_DESCRIPTION)) {
			return checkResult;
		}
		/*
		 * ODatabase SQLُō񐳏ŏQ ł邩`FbN
		 */
		if (AlarmRecovery.getInstance().isOccurredAlarmId(ipAddress,
				AlarmMessageResource.DATABASE_SQL_EXCEPTION_ERROR)) {
			/* Database SQLZbg */
			AlarmMessageMake message = AlarmMessageMake.getInstance();
			message.setRecoveryDatabaseSQLError(ipAddress, "URL=" + url
					+ " SQL=" + checkSQL);
		}

		return checkResult;
	}

	private String[] checkPhase1(final String jdbcdriver, final boolean isTest)
			throws Exception {
		try {
			if (databaseName.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
				/* Booting derbyɂEmbeddedDerbyғ󋵂UZbg */
				ApacheDerbyEmbeddedDerby.getInstance().setEmbeddedDerby(false);
			}
			// JDBC Driver ̓o^
			Class.forName(jdbcdriver).newInstance();

			if (databaseName.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
				/* Booting derbyɂEmbeddedDerbyғ󋵂ZbgB */
				ApacheDerbyEmbeddedDerby.getInstance().setEmbeddedDerby(true);
			}

			checkResult[PHASE1_NO] = PHASE1_OK_DESCRIPTION;
			logger.info(checkResult[PHASE1_NO]);
		} catch (ExceptionInInitializerError e) {
			checkResult[PHASE1_NO] = "ExceptionInInitializerError: "
					+ e.getMessage();
			logger.warning(checkResult[1]);
			// e.printStackTrace();
			if (isTest) {
				throw new DatabaseConnectionException(checkResult[PHASE1_NO]);
			}
			return checkResult;
		} catch (InstantiationException e) {
			checkResult[PHASE1_NO] = "InstantiationException: "
					+ e.getMessage();
			logger.warning(checkResult[1]);
			// e.printStackTrace();
			if (isTest) {
				throw new DatabaseConnectionException(checkResult[PHASE1_NO]);
			}
			return checkResult;
		} catch (IllegalAccessException e) {
			checkResult[PHASE1_NO] = "IllegalAccessException: "
					+ e.getMessage();
			logger.warning(checkResult[1]);
			// e.printStackTrace();
			if (isTest) {
				throw new DatabaseConnectionException(checkResult[PHASE1_NO]);
			}
			return checkResult;
		} catch (ClassNotFoundException e) {
			checkResult[PHASE1_NO] = "ClassNotFoundException: "
					+ e.getMessage();
			logger.warning(checkResult[1]);
			// e.printStackTrace();
			if (isTest) {
				throw new DatabaseConnectionException(checkResult[PHASE1_NO]);
			}
			return checkResult;
		} catch (NoClassDefFoundError e) {
			checkResult[PHASE1_NO] = "NoClassDefFoundError: " + e.getMessage();
			logger.warning(checkResult[1]);
			// e.printStackTrace();
			if (isTest) {
				throw new DatabaseConnectionException(checkResult[PHASE1_NO]);
			}
			return checkResult;
		}

		return checkResult;
	}

	private String[] checkPhase2(final String url, final String username,
			final String password, final boolean isTest) {
		Connection con = null;
		Statement stmt = null;

		try {
			con = DriverManager.getConnection(url, username, password);
			// SQL Xe[ggEIuWFNg̍쐬
			stmt = con.createStatement();

			checkResult[PHASE2_NO] = PHASE2_OK_DESCRIPTION;
			logger.info(checkResult[PHASE2_NO]);
		} catch (SQLException e1) {
			if (e1.getNextException() != null) {
				checkResult[PHASE2_NO] = "SQLException: " + e1.getMessage()
						+ " Next exception: " + e1.getNextException();
			} else {
				checkResult[PHASE2_NO] = "SQLException: " + e1.getMessage();
			}
			logger.warning("SQLException " + "URL = " + url + " : User = "
					+ username + " : Password = " + password);
			logger.warning(checkResult[PHASE2_NO]);
			if (!isTest) {
				/*
				 * A[ bZ[WA[L[Put
				 */
				AlarmMessageMake message = AlarmMessageMake.getInstance();
				message.setDatabaseConnectionError(ipAddress, "SQLException "
						+ "URL = " + url);

			}

			return checkResult;
		} catch (NoClassDefFoundError e1) {
			checkResult[PHASE2_NO] = "NoClassDefFoundError: " + e1.getMessage();
			logger.warning("NoClassDefFoundError " + "URL = " + url
					+ " : User = " + username + " : Password = " + password);
			logger.warning(checkResult[PHASE2_NO]);
			if (!isTest) {
				/*
				 * A[ bZ[WA[L[Put
				 */
				AlarmMessageMake message = AlarmMessageMake.getInstance();
				message.setDatabaseConnectionError(ipAddress,
						"NoClassDefFoundError " + "URL = " + url);
			}
			return checkResult;
		} finally {
			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (con != null) {
				try {
					con.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}
		}

		return checkResult;
	}

	private String[] checkPhase3(final String url, final String username,
			final String password, final String checkSQL,
			final boolean isQuery, final boolean isTest) {
		Connection con = null;
		Statement stmt = null;
		ResultSet rs = null;
		int result = 0;
		logger.info("Database Kind : " + databaseName);

		try {
			if (!databaseName.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
				con = DriverManager.getConnection(url, username, password);
			} else {
				con = DriverManager.getConnection(url);
			}

			stmt = con.createStatement();
			if (isQuery) {
				rs = stmt.executeQuery(checkSQL);
			} else {
				result = stmt.executeUpdate(checkSQL);
				logger
						.info(checkResult[PHASE3_NO] + " result code = "
								+ result);
			}
			checkResult[PHASE3_NO] = PHASE3_OK_DESCRIPTION;

		} catch (SQLException e2) {
			checkResult[PHASE3_NO] = "SQLException: " + e2.getMessage()
					+ " SQL : " + checkSQL;
			logger.warning("SQL : " + checkSQL);
			logger.warning(checkResult[PHASE3_NO]);
			if (!isTest) {
				/*
				 * A[ bZ[WA[L[Put
				 */
				AlarmMessageMake message = AlarmMessageMake.getInstance();
				message.setDatabaseSQLError(ipAddress, "SQLException "
						+ "URL = " + url + " SQL = " + checkSQL);
			}
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				rs = null;
			}
			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (con != null) {
				try {
					con.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}
		}

		return checkResult;
	}

}
