/*
 * Created on 2004/08/05
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.http;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmMessageResource;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * URLɐANZXo邩`FbN郁\bhNX
 * łB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ExecuteHttpCheck {
    /* HTTPX|X\o͂邩ۂtO */
    private static final boolean IS_SHOW = false;

    /* MO */
    private static Logger logger = null;

    /**
     * HTTPɂURL`FbNCX^X𐶐܂B
     *
     */
    public ExecuteHttpCheck() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * wIPAhX̎wURL`FbN܂B
     *
     * @param ipaddress IPAhX
     * @param nodeWatchInfo m[hĎ
     *
     */
    public void getURL(
        final String ipaddress, final NodeWatchInfo nodeWatchInfo) {
        String targetURL = nodeWatchInfo.getHttpUrl();
        logger.info("HTTP GET : " + targetURL);

        int httpTimeout = 0;

        try {
            httpTimeout = Integer.parseInt(nodeWatchInfo.getHttpTimeout());
        } catch (NumberFormatException e1) {
            logger.warning(
                "Illegal HttpTimeout = " + nodeWatchInfo.getHttpTimeout()
                + " : " + e1.getMessage());
        }

        try {
            // URLNX̃CX^X𐶐
            URL accessURL = new URL(targetURL);
            HttpURLConnection urlConn =
                (HttpURLConnection) accessURL.openConnection();

            urlConn.setConnectTimeout(httpTimeout);
            urlConn.setReadTimeout(httpTimeout);
            urlConn.setRequestMethod("GET");
            urlConn.setInstanceFollowRedirects(false);

            /*
             * urlconn.setRequestProperty("Accept-Language",
             *  "ja;q=0.7,en;q=0.3");
             */
            urlConn.setRequestProperty(
                "User-Agent", "NetJFWatcher URLConnect Check");
            urlConn.setRequestProperty("Accept-Language", "ja");

            urlConn.connect();

            if (chckResponseCode(ipaddress, urlConn)) {
                if (
                    AlarmRecovery.getInstance().isOccurredAlarmId(
                            ipaddress, AlarmMessageResource.HTTP_GET_ERROR)) {
                    /* HTTPANZXZbg */
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setRecoveryHTTPGetError(ipaddress, targetURL);
                }
            }

            urlConn.disconnect();
        } catch (IllegalArgumentException e) {
            logger.warning(
                "IllegalArgumentException : " + e.getMessage() + " "
                + targetURL);

            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(
                ipaddress,
                "IllegalArgumentException : " + e.getMessage() + " "
                + targetURL);
        } catch (SocketTimeoutException e) {
            /*
             * Connect Timeout܂Read Timeoutُ퓙Socket
             * Timeout
             */
            logger.warning(e.getMessage());

            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(
                ipaddress,
                "SocketTimeoutException : " + e.getMessage() + " (set timeout="
                + httpTimeout + "ms)");
        } catch (UnknownHostException e) {
            logger.warning(e.getMessage());

            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(
                ipaddress, "UnknownHostException : " + e.getMessage());
        } catch (MalformedURLException e) {
            logger.warning(e.getMessage());

            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(
                ipaddress, "MalformedURLException : " + e.getMessage());
        } catch (FileNotFoundException e) {
            logger.warning(e.getMessage());

            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(
                ipaddress, "FileNotFoundException : " + e.getMessage());
        } catch (ConnectException e) {
            logger.warning(e.getMessage());

            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(
                ipaddress, "ConnectException : " + e.getMessage());
        } catch (IOException e) {
            logger.warning(e.getMessage());

            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setHTTPGetError(
                ipaddress, "IOException : " + e.getMessage());
        }

        try {
            /* Ďm[hŏI`FbNԍXV */
            LastCheckTimeUpDate updateLastCheckTime =
                LastCheckTimeUpDate.getInstance();
            updateLastCheckTime.updateCheckTime(ipaddress);
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * WebT[ỏ`FbNA`FbNʂԂ܂B
     * `FbNe̓X|XR[h200(퉞)ł邩
     * łB
     *
     * @param ipaddress `FbNWebT[oIP Address
     * @param urlConnecrion HttpURLConnection
     * @return isOk true;Afalse:ُ
     * @throws SocketTimeoutException SocketɎsꍇ
     * @throws IOException ُ͈킪ꍇ
     */
    private boolean chckResponseCode(
        final String ipaddress, final HttpURLConnection urlConnecrion)
        throws SocketTimeoutException, IOException {
        /* `FbN */
        boolean isOk = false;

        /* f[^ǂݍStream */
        InputStream urlInputStream = null;
        InputStreamReader urlInputStreamReader = null;
        BufferedReader bufferdReader = null;

        try {
            /* X|XR[h`FbN */
            int responseCode = urlConnecrion.getResponseCode();
            String responseMessage = urlConnecrion.getResponseMessage();

            if (responseCode != HttpURLConnection.HTTP_OK) {
                /* X|XR[h200ȊO̎ɃA[Zbg */
                logger.warning(
                    "ResponseCode [" + responseCode + "] "
                    + "ResponseMessage [" + responseMessage + "]");

                AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
                makeAlarm.setHTTPGetError(
                    ipaddress,
                    "ResponseCode [" + responseCode + "] "
                    + "ResponseMessage [" + responseMessage + "]");

                /* ُ퉞HeaderMO */
                Map headers = urlConnecrion.getHeaderFields();
                Iterator it = headers.keySet().iterator();
                logger.warning("Response headers:");

                while (it.hasNext()) {
                    String key = (String) it.next();
                    logger.warning("  " + key + ": " + headers.get(key));
                }

                return isOk;
            }

            isOk = true;

            if (
                AlarmRecovery.getInstance().isOccurredAlarmId(
                        ipaddress, AlarmMessageResource.HTTP_GET_ERROR)) {
                /* Zbg */
                AlarmMessageMake message = AlarmMessageMake.getInstance();
                message.setRecoveryHTTPGetError(
                    ipaddress,
                    "ResponseCode [" + responseCode + "] "
                    + "ResponseMessage [" + responseMessage + "]");
            }

            /*
             * Response HeaderAResponse CodeyBody
             * \o͂s
             */
            if (IS_SHOW) {
                /*
                 * Header\o
                 */
                Map headers = urlConnecrion.getHeaderFields();
                Iterator it = headers.keySet().iterator();

                System.out.println("Response headers:");

                while (it.hasNext()) {
                    String key = (String) it.next();
                    System.out.println("  " + key + ": " + headers.get(key));
                }

                /* Response Code\o */
                System.out.println(
                    "ResponseCode[" + responseCode + "] " + "ResponseMessage["
                    + responseMessage + "]");

                /* Body\o */
                System.out.println(
                    System.getProperty("line.separator") + "---- Body ----");
                urlInputStream = urlConnecrion.getInputStream();
                urlInputStreamReader = new InputStreamReader(urlInputStream);
                bufferdReader = new BufferedReader(urlInputStreamReader);

                while (true) {
                    String line = bufferdReader.readLine();

                    if (line == null) {
                        break;
                    }

                    System.out.println(line);
                }
            }
        } finally {
            if (bufferdReader != null) {
                // ̓Xg[
                try {
                    bufferdReader.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (urlInputStreamReader != null) {
                try {
                    urlInputStreamReader.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (urlInputStream != null) {
                try {
                    urlInputStream.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }

        return isOk;
    }
}
