/*
 * Created on 2003/07/26
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.xmlsocket;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.XMLSocketConnectState;


/**
 * NCAgƂXML Socket PUSHʒms߂ɁANCAg
 * iNCAgƂ̐ڑXbhjPʂɐIuWFNg
 * XbhL[ƂHashMapɕێ܂B
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class XMLSocketConnectPushQueue {
    /* msJE^l */
    private static final int MS_COUNT = 1000;

    /* NCAgőڑ */
    private static final int LISTSIZE = 50;

    /* ThreadL[ƂXML SocketێMap */
    private static Map<String, XMLSocketInfo> clientEventQueue =
        Collections.synchronizedMap(new HashMap<String, XMLSocketInfo>());

    /* MO */
    private static Logger logger = null;

    /* ڑJntH[}bg */
    private final DateFormat simpleDateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /*
     * RXgN^privateɂĕspӂɒڃRXgN^
     * Ăяoh~
     */
    private XMLSocketConnectPushQueue() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static XMLSocketConnectPushQueue getInstance() {
        return SingletonXMLSocketConnectInstance.INSTANCE;
    }

    /**
     * L[iHashMapjɃXbhL[ƂXMLSocketIuWFNgo^܂B
     *
     * @param threadName L[iHashMapjKeyƂClientƂ̐ڑThread
     * @param remoteIP Client IPAhX
     * @param targetIPAddress m[hIPAhX
     *
     * @return L[ɓo^oۂtO
     * true  : o^
     * false : o^
     */
    public synchronized boolean createXMLSocketObject(
        final String threadName, final String remoteIP,
        final String targetIPAddress) {
        /*
         * NCAgڑől𒴂Ă炸A
         * Thread݂Ȃ΃L[ɓo^
         */
        if (
            (clientEventQueue.size() <= LISTSIZE)
                && !clientEventQueue.containsKey(threadName)) {
            // NCAgIPAhX
            XMLSocketInfo xmlSocketinfo = new XMLSocketInfo(remoteIP);
            xmlSocketinfo.setTargetIpAddress(targetIPAddress);
            clientEventQueue.put(threadName, xmlSocketinfo);

            return true;
        }

        return false;
    }

    /**
     * NCAgڑXbhɑΉCxgʒmpIuWFNg
     * HashMap폜܂B<BR>
     * NCAgƂ̐ڑfŌĂ΂܂B<BR>
     *
     * @param threadName ClientƂ̐ڑThread
     */
    public synchronized void dellThreadKeyInXMLSocketInfoMap(
        final String threadName) {
        clientEventQueue.remove(threadName);
    }

    /**
     * SڑNCAg̃CxgʒmpIuWFNg̃CxgXg
     * ɐVȃCxgo^܂B
     *
     *
     * @param eventObj CxgXgɒǉCxgiIuWFNgj
     */
    public synchronized void addEventToXMLSocketInfoList(final Object eventObj) {
        XMLSocketInfo xmlSocketInfo;
        String threadNameKey;

        /*
         * HashMap̃L[ɑΉXML SocketoăCxg
         * XgɃp[^Ŏw肳ꂽIuWFNgǉ
         */
        Set set = clientEventQueue.keySet();
        Iterator iterator = set.iterator();

        while (iterator.hasNext()) {
            threadNameKey = iterator.next().toString();
            xmlSocketInfo = (XMLSocketInfo) clientEventQueue.get(threadNameKey);
            xmlSocketInfo.getEventList().add(eventObj);

            clientEventQueue.put(threadNameKey, xmlSocketInfo);
        }
    }

    /**
     * ClientƂ̐ڑThreadɑΉXML SocketԂ܂B
     *
     * @param threadName ClientƂ̐ڑThread
     * @return xmlSocketInfo XML Socket
     */
    public synchronized XMLSocketInfo popXMLSocketInfo(final String threadName) {
        XMLSocketInfo xmlSocketInfo = null;

        if (clientEventQueue.containsKey(threadName)) {
            xmlSocketInfo = (XMLSocketInfo) clientEventQueue.get(threadName);
        }

        return xmlSocketInfo;
    }

    /**
     * XbhL[ƂăCxgL[o܂B<BR>
     *
     * @param threadName ClientƂ̐ڑThread
     * @return eventObj Cxg
     * @throws IndexOutOfBoundsException
     */
    public synchronized Object popXMLSocketConnectEvent(
        final String threadName) throws IndexOutOfBoundsException {
        Object eventObj = null;

        if (clientEventQueue.containsKey(threadName)) {
            XMLSocketInfo socketinfo =
                (XMLSocketInfo) clientEventQueue.get(threadName);

            if (socketinfo.getEventList().size() > 0) {
                eventObj = socketinfo.getEventList().get(0);

                // XgCxg폜āAHashMap̃IuWFNgXV
                socketinfo.getEventList().remove(0);
                clientEventQueue.put(threadName, socketinfo);
            }
        }

        return eventObj;
    }

    /**
     * NCAgڑԃXgԂ܂B
     *
     * @return@connectList NCAgڑԃXg
     */
    public synchronized ArrayList getConnectInfo() {
        ArrayList connectList = new ArrayList();

        Set set = clientEventQueue.keySet();
        Iterator iterator = set.iterator();

        while (iterator.hasNext()) {
            String threadKey = iterator.next().toString();
            XMLSocketInfo socketinfo =
                (XMLSocketInfo) clientEventQueue.get(threadKey);
            String remoteIP = socketinfo.getRemoteIP();
            Date startTime = socketinfo.getStartTime();

            XMLSocketConnectState connectstate =
                new XMLSocketConnectState(remoteIP, startTime);

            String hostName = "UnknownHost";

            try {
                InetAddress host = InetAddress.getByName(remoteIP);
                hostName = host.getHostName();
            } catch (UnknownHostException e) {
                logger.warning(
                    "UnknownHostException Remote IP = " + remoteIP + "  "
                    + e.getMessage());
            }

            connectstate.setHostName(hostName);
            connectstate.setStartDate(simpleDateformat.format(startTime));
            connectstate.setDurationDate(convDurationDate(startTime));

            connectList.add(connectstate);
        }

        return connectList;
    }

    /*
     * Datef[^bɕϊĕԂ܂B
     *
     * @param startDate Datef[^
     * @return optimeString b
     */
    private String convDurationDate(final Date startDate) {
        Date date = Calendar.getInstance().getTime();

        long opTime = date.getTime() - startDate.getTime();
        String optimeString = "";

        if (opTime != 0) {
            int day = (int) opTime / (MS_COUNT * 60 * 60 * 24);
            int hour =
                (int) (opTime - (day * MS_COUNT * 60 * 60 * 24)) / (MS_COUNT * 60 * 60);
            int min =
                (int) (opTime - (day * MS_COUNT * 60 * 60 * 24)
                - (hour * MS_COUNT * 60 * 60)) / (MS_COUNT * 60);
            int sec =
                (int) (opTime - (day * MS_COUNT * 60 * 60 * 24)
                - (hour * MS_COUNT * 60 * 60) - (min * MS_COUNT * 60)) / MS_COUNT;

            String dayString;

            if (day == 0) {
                dayString = "";
            } else {
                dayString = day + "day ";
            }

            String hourString;

            if (hour == 0) {
                hourString = "";
            } else {
                hourString = hour + "hour";
            }

            String minString;

            if (min == 0) {
                minString = "";
            } else {
                minString = min + "min";
            }

            optimeString =
                " (" + dayString + hourString + minString + sec + "sec)";
        }

        return optimeString;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonXMLSocketConnectInstance {
        static final XMLSocketConnectPushQueue INSTANCE =
            new XMLSocketConnectPushQueue();
    }
}
