/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;


/**
 * SNMP V3 AgentSNMP V3v(USM v)ێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpV3UsmStatisticsInfo {
    /**
     * <p>The total number of packets received by the SNMP engine
     *  which were dropped because they requested a securityLevel that was unknown to the SNMP engine or otherwise unavailable.</p>
     */
    private int usmStatsUnsupportedSecLevels = 0;

    /**
     * <p>The total number of packets received by the SNMP engine which were dropped because they appeared outside of the authoritative SNMP engine's window.</p>
     */
    private int usmStatsNotInTimeWindows = 0;

    /**
     * <p>The total number of packets received by the SNMP engine which were dropped because they referenced a user that was not known to the SNMP engine.</p>
     */
    private int usmStatsUnknownUserNames = 0;

    /**
     * <p>The total number of packets received by the SNMP engine which were dropped because they referenced an snmpEngineID that was not known to the SNMP engine.</p>
     */
    private int usmStatsUnknownEngineIDs = 0;

    /**
     * <p>The total number of packets received by the SNMP engine which were dropped because they didn't contain the expected digest value.</p>
     */
    private int usmStatsWrongDigests = 0;

    /**
     * <p>The total number of packets received by the SNMP engine which were dropped because they could not be decrypted.</p>
     */
    private int usmStatsDecryptionErrors = 0;

    /**
     * UsmStatsDecryptionErrorsԂ܂B
     *
     * @return usmStatsDecryptionErrors
     */
    public int getUsmStatsDecryptionErrors() {
        return usmStatsDecryptionErrors;
    }

    /**
     * UsmStatsNotInTimeWindowsԂ܂B
     *
     * @return usmStatsNotInTimeWindows
     */
    public int getUsmStatsNotInTimeWindows() {
        return usmStatsNotInTimeWindows;
    }

    /**
     * UsmStatsUnknownEngineIDsԂ܂B
     *
     * @return usmStatsUnknownEngineIDs
     */
    public int getUsmStatsUnknownEngineIDs() {
        return usmStatsUnknownEngineIDs;
    }

    /**
     * UsmStatsUnknownUserNamesԂ܂B
     *
     * @return usmStatsUnknownUserNames
     */
    public int getUsmStatsUnknownUserNames() {
        return usmStatsUnknownUserNames;
    }

    /**
     * UsmStatsUnsupportedSecLevelsԂ܂B
     *
     * @return usmStatsUnsupportedSecLevels
     */
    public int getUsmStatsUnsupportedSecLevels() {
        return usmStatsUnsupportedSecLevels;
    }

    /**
     * UsmStatsWrongDigestsԂ܂B
     *
     * @return usmStatsWrongDigests
     */
    public int getUsmStatsWrongDigests() {
        return usmStatsWrongDigests;
    }

    /**
     * UsmStatsDecryptionErrorsJEgAbv܂B
     *
     */
    public void addUsmStatsDecryptionErrors() {
        usmStatsDecryptionErrors++;
    }

    /**
     * UsmStatsNotInTimeWindowsJEgAbv܂B
     *
     */
    public void addUsmStatsNotInTimeWindows() {
        usmStatsNotInTimeWindows++;
    }

    /**
     * UsmStatsUnknownEngineIDsJEgAbv܂B
     *
     */
    public void addUsmStatsUnknownEngineIDs() {
        usmStatsUnknownEngineIDs++;
    }

    /**
     * UsmStatsUnknownUserNamesJEgAbv܂B
     *
     */
    public void addUsmStatsUnknownUserNames() {
        usmStatsUnknownUserNames++;
    }

    /**
     * UsmStatsUnsupportedSecLevelsJEgAbv܂B
     *
     */
    public void addUsmStatsUnsupportedSecLevels() {
        usmStatsUnsupportedSecLevels++;
    }

    /**
     * UsmStatsWrongDigestsJEgAbv܂B
     *
     */
    public void addUsmStatsWrongDigests() {
        usmStatsWrongDigests++;
    }

    /**
     * @param usmStatsDecryptionErrors usmStatsDecryptionErrors ݒB
     */
    public void setUsmStatsDecryptionErrors(int usmStatsDecryptionErrors) {
        this.usmStatsDecryptionErrors = usmStatsDecryptionErrors;
    }

    /**
     * @param usmStatsNotInTimeWindows usmStatsNotInTimeWindows ݒB
     */
    public void setUsmStatsNotInTimeWindows(int usmStatsNotInTimeWindows) {
        this.usmStatsNotInTimeWindows = usmStatsNotInTimeWindows;
    }

    /**
     * @param usmStatsUnknownEngineIDs usmStatsUnknownEngineIDs ݒB
     */
    public void setUsmStatsUnknownEngineIDs(int usmStatsUnknownEngineIDs) {
        this.usmStatsUnknownEngineIDs = usmStatsUnknownEngineIDs;
    }

    /**
     * @param usmStatsUnknownUserNames usmStatsUnknownUserNames ݒB
     */
    public void setUsmStatsUnknownUserNames(int usmStatsUnknownUserNames) {
        this.usmStatsUnknownUserNames = usmStatsUnknownUserNames;
    }

    /**
     * @param usmStatsUnsupportedSecLevels usmStatsUnsupportedSecLevels ݒB
     */
    public void setUsmStatsUnsupportedSecLevels(
        int usmStatsUnsupportedSecLevels) {
        this.usmStatsUnsupportedSecLevels = usmStatsUnsupportedSecLevels;
    }

    /**
     * @param usmStatsWrongDigests usmStatsWrongDigests ݒB
     */
    public void setUsmStatsWrongDigests(int usmStatsWrongDigests) {
        this.usmStatsWrongDigests = usmStatsWrongDigests;
    }
}
